package org.opensi.webmanager.utils;

public class FactureStruct extends Struct {
	// Constantes
	private final String VIDE = "";

	public final int ID_COMMANDE = 0;
	public final int MONTANT_TOTAL = 1;
	public final int MONTANT_TVA = 2;
	public final int FRAIS_PORT = 3;
	public final int REMISE = 4;
	public final int NUM_FACTURE = 5;
	public final int DATE_FACTURE = 6;
	public final int MODE_REGLEMENT = 7;
	public final int ID_CLIENT = 8;
	public final int PERS_FACT = 9;
	public final int NUM_MOIS = 10;
	public final int LISTE_ARTICLES = 11;
	public final int NB_CHAMPS = 12;

	/**
	 * Construit une nouvelle facture
	 * 
	 * @param reference
	 *          r&eacute;f&eacute;rence de l'article
	 */

	public FactureStruct() {
		super(12);

		setString(ID_COMMANDE,VIDE);
		setDouble(MONTANT_TOTAL,0.0);
		setDouble(MONTANT_TVA,0.0);
		setDouble(FRAIS_PORT,0.0);
		setDouble(REMISE,0.0);
		setString(NUM_FACTURE,VIDE);
		setString(DATE_FACTURE,VIDE);
		setString(MODE_REGLEMENT,VIDE);
		setString(ID_CLIENT,VIDE);
		setString(NUM_MOIS,VIDE);
		PersonneStruct pers = new PersonneStruct();
		setStruct(PERS_FACT,pers.getStruct());
	}
	
	public FactureStruct(Object[] listeBrut) {
		super(listeBrut);
	}
}
