package org.opensi.webmanager.utils;

/**
 * Structure repsentant une commande web
 */
public class CommandeStruct extends Struct {
	// Constantes
	private static String VIDE = "";
	
	public final int ID = 0;
	public final int MODE_PAIEMENT = 1;
	public final int FRAIS_PORT = 2;
	public final int TOTAL_TTC = 3;
	public final int TOTAL_HT = 4;
	public final int LISTE_ARTICLES = 5;
	public final int CLIENT_LIV = 6;
	public final int CLIENT = 7;
	public final int STATUT = 8;
	public final int REMISE = 9;
	public final int TAUX_REMISE = 10;
	public final int DATE = 11;
	public final int STATUT_PAIE = 12;
	public final int EMAIL_MANAGER = 13;
	public final int MODE_EXPEDITION = 14;
	public final int COMMENTAIRES = 15;
	public final int COMMENTAIRES_2 = 16;
	public final int VALIDATION = 17;
	public final int EDITION_COM = 18;
	public final int EDITION_TTC = 19;
	public final int TYPE_VENTE = 20;
	public final int CODE_PORTE = 21;
	public final int NUM_TRANSACTION = 22;
	public final int ORIGINE = 23;
	public final int INFOS_COMMANDE = 24;
	public final int NUM_COLIS = 25;
	public final int LIEN_COLIS = 26;
	public final int CODE_PAYS = 27;
	public final int CODE_PAYS_LIV = 28;
	public final int TAUX_TVA_PORT = 29;
	public final int TAUX_INDICATIF = 30;
	public final int ASSUJETTI = 31;
	public final int AFFAIRE = 32;
	public final int ENVOI_MULTIPLE = 33;
	public final int BLOQUE = 34;
	public final int NB_CHAMPS = 35;

	/**
	 * Construit une nouvelle commande
	 * 
	 * @param reference
	 *          r&eacute;f&eacute;rence de l'article
	 */
	public CommandeStruct() {
		super(35); //NB_CHAMPS
		setDefaut();
	}
	
	public CommandeStruct(String comid) {
		this();
		setString(ID, comid);
	}

	public CommandeStruct(Object[] listeBrut) {
		super(listeBrut);
	}

	public final void setDefaut() {
		setString(ID, VIDE);
		setString(MODE_PAIEMENT,VIDE);
		setDouble(FRAIS_PORT,0.0);
		setDouble(TOTAL_TTC,0.0);
		setDouble(TOTAL_HT,0.0);
		ClientStruct client = new ClientStruct();
		setStruct(CLIENT,client.getStruct());
		setStruct(CLIENT_LIV,client.getStruct());
		setString(STATUT, VIDE);
		setString(STATUT_PAIE, VIDE);
		setDouble(REMISE,0.0);
		setDouble(TAUX_REMISE,0.0);
		setString(DATE,VIDE);
		setString(EMAIL_MANAGER,VIDE);
		setString(MODE_EXPEDITION,VIDE);
		setString(COMMENTAIRES,VIDE);
		setString(COMMENTAIRES_2,VIDE);
		setInteger(VALIDATION,0);
		setInteger(EDITION_COM,0);
		setInteger(EDITION_TTC,0);
		setString(TYPE_VENTE,"N");
		setString(CODE_PORTE,VIDE);
		setString(NUM_TRANSACTION,VIDE);
		setString(ORIGINE,VIDE);
		setString(INFOS_COMMANDE,VIDE);
		setString(NUM_COLIS,VIDE);
		setString(LIEN_COLIS,VIDE);		
		setString(CODE_PAYS,VIDE);		
		setString(CODE_PAYS_LIV,VIDE);		
		setDouble(TAUX_TVA_PORT,19.6);
		setDouble(TAUX_INDICATIF,0.0);
		setInteger(ASSUJETTI,0);
		setInteger(AFFAIRE,0);
		setInteger(ENVOI_MULTIPLE,0);
		setInteger(BLOQUE,0);
	}

}
