package org.opensi.webmanager.utils;

/**
 * Structure reprsentant un article d'une commande.
 */
public class ArticleFactureStruct extends Struct {
	// Constantes
	private final String VIDE = "";
	
	public final int REFERENCE = 0;
	public final int PRIX_U = 1;
	public final int QUANTITE = 2;
	public final int REMISE = 3;
	public final int DESIGNATION = 4;
	public final int TVA = 5;
	public final int COMMENTAIRE = 6;
	public final int NB_CHAMPS = 7;

	/**
	 * Construit un nouvel article
	 * 
	 * @param reference
	 *          rfrence de l'article
	 */

	public ArticleFactureStruct(String reference) {
		super(7);
		setString(REFERENCE,VIDE + reference);
		setDouble(PRIX_U,0.0);
		setDouble(QUANTITE,0.0);
		setDouble(REMISE,0.0);
		setString(DESIGNATION,VIDE);
		setDouble(TVA,19.6);
		setString(COMMENTAIRE,VIDE);
	}

	public ArticleFactureStruct(Object[] listeBrut) {
		super(listeBrut);
	}

}