/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 *  Ajout d'un suffixe a tous les doublons
 */

package org.opensi.webmanager.init_vente;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;

import org.experlog.openeas.api.Action;
import org.experlog.openeas.api.ServletRequest;
import org.experlog.openeas.api.Session;

/**
 * Ajoute un suffixe  tous les doublons.
 */
public class ModifDoublons extends Action {

	/**
	 * 
	 * @return
	 */
	public boolean serverSide() {
		return true;
	}

	/**
	 * 
	 * @param s
	 * @param r
	 * @param info
	 * @throws java.lang.Exception
	 * @return
	 */
	public boolean service(Session s, ServletRequest r, Object info) throws Exception {

		String base = r.getParameter("base");
		String site_id = r.getParameter("site_id");
		String suff_ref = r.getParameter("suffixeref");
		String suff_des = r.getParameter("suffixedes");
		Connection con = s.getConnection(null);

		String reqOldRef = "SELECT f.Article_Id as ref, t.Designation as design";
		reqOldRef += " FROM " + base + ".FICHE_ARTICLE f, " + base + ".FICHE_ARTICLE_TEMP t ";
		reqOldRef += " WHERE t.Site_Id=" + site_id + " AND (f.Article_Id=t.Article_Id OR f.Designation=t.Designation)";

		String reqModif = " UPDATE " + base + ".FICHE_ARTICLE_TEMP SET Article_Id=?, Designation=? WHERE Site_Id=" + site_id
				+ " AND Article_Id=? ";
		PreparedStatement ps = con.prepareStatement(reqModif);

		Statement state = con.createStatement();
		ResultSet result = state.executeQuery(reqOldRef);

		while (result.next()) {
			ps.setString(1, result.getString("ref") + suff_ref);
			ps.setString(2, result.getString("design") + suff_des);
			ps.setString(3, result.getString("ref") + suff_ref);

			ps.addBatch();

		}

		ps.executeBatch();

		s.closeConnection(con, null);

		return true;

	}

}
