/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 *  Mise a jour des statuts des commandes
 */

package org.opensi.webmanager.fonctions_periodiques;

import java.io.File;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Vector;

import org.opensi.webmanager.utils.AppelServices;
import org.opensi.webmanager.utils.CommandeStruct;
import org.opensi.webmanager.utils.MultiRapports;
import org.opensi.webmanager.utils.RedactionRapport;
import org.opensi.webmanager.utils.ToolsMAJ;

/**
 * Procdure de mise  jour du statut des commandes.
 */
public class MAJStatutCom {

	private boolean appelServiceReussi;
	private boolean appelToutServiceReussi;
	private boolean noErreurRapport;
	String dateDebut;
	String dateFin;
	int nbArticlesParEnvoi = 100;
	MultiRapports lesRapports;
	private int timeout;
	private int nbEchecs;
	private int nbArticles;
	private int nbRapports;
	Vector<String> listeId;
	private File aEcrire;
	private String type;

	/**
	 * Prpare la mise  jour des statuts des commandes.
	 * 
	 * @param nbArticles
	 *          nombre d'article maximum par envoi
	 * @param timeoutService
	 *          timeout en milisecondes
	 * @param lenbRapports
	 *          nombre de rapport  conserver
	 */
	public MAJStatutCom(int nbArticles, int timeoutService, int lenbRapports,String fichier, String nomtype) {
		this(nbArticles,timeoutService,lenbRapports);
		aEcrire = new File(fichier);// le fichier de log
		this.type=nomtype;
	}
	public MAJStatutCom(int nbArticles, int timeoutService, int lenbRapports) {
		aEcrire = new File("Lancer_Maintenant.log");// le fichier de log
		this.type="";
		appelServiceReussi = true;
		appelToutServiceReussi = true;
		noErreurRapport = true;
		lesRapports = new MultiRapports();

		nbRapports = (lenbRapports > 0)?lenbRapports:10;
		nbArticlesParEnvoi = (nbArticles > 0)?nbArticles:100;
		timeout = (timeoutService >= 0)?timeoutService:20000;
		nbEchecs = 0;
		AppelServices.setTimeout(new Integer(timeout));
	}

	/**
	 * Lance la mise  jour.
	 * 
	 * La connexion  la base de donne n'est ni ouverte ni ferme.
	 * 
	 * @param serveur
	 *          adresse du web service
	 * @param dossierRoot
	 *          chemin absolu vers le seveur de OpenSi (opensi-serveur)
	 * @param dossierId
	 *          identifiant du dossier
	 * @param con
	 *          Connexion  la base de donne
	 * @param base
	 *          Nom de la base de donne FACT_qquechose
	 * @param site_id
	 *          identifiant du site
	 * @return vrai si la mise  jour s'est bien passe, faux sinon.
	 */
	public boolean lancerMAJ(String serveur, String dossierRoot, String dossierId, Connection con, String base, String site_id) {
		java.util.Date date = new java.util.Date();
		Timestamp stamp = new Timestamp(date.getTime());
		dateDebut = "" + stamp;

		appelService(serveur, con, base, site_id);

		date = new java.util.Date();
		stamp = new Timestamp(date.getTime());
		dateFin = "" + stamp;

		try {

			String requete = "UPDATE " + base + ".MAJ_AUTO SET Derniere_Maj=" + date.getTime() + " WHERE Site_Id=" + site_id
					+ " AND Type_Maj='STAT'";
			Statement state = con.createStatement();
			state.executeUpdate(requete);
		}
		catch (Exception e) {
			e.printStackTrace();
		}

		ecrireRapport(dossierRoot, dossierId, site_id);

		return this.appelToutServiceReussi;

	}

	private void appelService(String serveur, Connection con, String base, String site_id) {
		try {

			String reqCom = "SELECT cc.*, ccw.Ref_Com_Web FROM " + base + ".COMMANDE_CLIENT cc join " + base + ".COMMANDE_CLIENT_WEB ccw on cc.Commande_Id=ccw.Commande_Id";
			reqCom += " WHERE Site_Web_Id=" + site_id + " AND Statut_Modifie=1";

			Statement state = con.createStatement();
			Statement state2 = con.createStatement();
			ResultSet resCom = state.executeQuery(reqCom);

			Vector<Object> liste = new Vector<Object>();
			listeId = new Vector<String>();

			int compteur = 0;

			while (resCom.next()) {
				CommandeStruct statut_com = new CommandeStruct();
				listeId.add(resCom.getString("Commande_Id"));

				String statutCommande = resCom.getString("Etat");
				if (statutCommande.equals("T")) {
					if (resCom.getInt("Soldee")==1) {
						statutCommande = "L";
					}
					else {
						String reqBL = "SELECT count(Bon_Id) as nb FROM " + base + ".BON_LIVRAISON";
						reqBL += " WHERE Commande_Id ="+resCom.getInt("Commande_Id");

						ResultSet resBL = state2.executeQuery(reqBL);
						
						if (resBL.next()) {
							if ((resBL.getInt("nb"))>0) {
								statutCommande = "E";
							}
						}
					}
				}
				statut_com.setString(statut_com.ID,resCom.getString("Ref_Com_Web"));
				statut_com.setString(statut_com.STATUT, statutCommande);
				statut_com.setString(statut_com.STATUT_PAIE,resCom.getString("Statut_Paiement"));
		
				String reqCol = "SELECT Ident_Suivi,Lien FROM " + base + ".BON_LIVRAISON bl, " + base + ".COLIS c";
				reqCol += " WHERE Commande_Id=" + resCom.getString("Commande_Id") + " AND c.Bon_Id=bl.Bon_Id";
				ResultSet resCol = state2.executeQuery(reqCol);
				while (resCol.next()) {
					statut_com.setString(statut_com.NUM_COLIS,resCol.getString("Ident_Suivi"));
					statut_com.setString(statut_com.LIEN_COLIS,resCol.getString("Lien"));
				}
				
				liste.add(statut_com.getStruct());
				// On envoi tout les nbArticlesParEnvoi articles
				if ((compteur % nbArticlesParEnvoi) == 0 && compteur > 0) {
					ToolsMAJ.ecrireLog(aEcrire,type,"[MAJStatutCom(appelService)] Appel du service pour " + nbArticlesParEnvoi + " articles.");
					envoyerMaj(serveur, liste.toArray());

					appelToutServiceReussi = appelToutServiceReussi && appelServiceReussi;

					if (appelServiceReussi) {
						ToolsMAJ.ecrireLog(aEcrire,type,"[MAJStatutCom(appelService)] Je valide ");
						validerDansOpenSi(con, base, site_id);
					}
					else {
						nbEchecs += nbArticlesParEnvoi;
					}

					liste = new Vector<Object>();
					listeId = new Vector<String>();// pour valider
				}
				compteur++;

			}
			nbArticles = compteur;

			// la fin de la liste
			if (nbArticles > 0) {
				ToolsMAJ.ecrireLog(aEcrire,type,"[MAJStatutCom(appelService)] Appel du service pour " + nbArticlesParEnvoi + " articles.");
				envoyerMaj(serveur, liste.toArray());
				appelToutServiceReussi = appelToutServiceReussi && this.appelServiceReussi;

				if (appelServiceReussi) {
					ToolsMAJ.ecrireLog(aEcrire,type,"[MAJStatutCom(appelService)] Je valide ");
					validerDansOpenSi(con, base, site_id);
				}
				else {
					nbEchecs += nbArticlesParEnvoi;
				}
			}

		}
		catch (Exception e) {
			ToolsMAJ.ecrireLog(aEcrire,type,"[MAJStatutCom(appelService)] ERREUR " + e);
			e.printStackTrace();
		}
	}

	private void envoyerMaj(String serveur, Object[] liste) {
		appelServiceReussi = true;
		try {
			Object resultat = AppelServices.MAJStatutCom(serveur, liste);
			Object[] rep = (Object[]) resultat;

			Object[] rapport = (Object[]) rep[0];

			lesRapports.addRapport(rapport);

		}
		catch (Exception e) {
			ToolsMAJ.ecrireLog(aEcrire,type,"[MAJStatutCom(envoyerMaj)] ERREUR:" + e);
			appelServiceReussi = false;
		}

	}

	private void ecrireRapport(String dossierRoot, String dossierId, String site_id) {

		try {
			RedactionRapport ecriveur = new RedactionRapport(ToolsMAJ.TYPE_MAJ_STATUT, nbRapports, dossierRoot, dossierId, site_id);

			ecriveur.ajouterLigne(dateDebut + ":La mise a jour des statuts a t lance", true);
			if (nbArticles > 0) {
				if (!appelToutServiceReussi) {
					ecriveur.ajouterLigne("\nUne erreur s'est produite.", false);
				}

				String lesDetails = "";

				int cptErreur = 0;
				int cptOk = 0;

				while (lesRapports.next()) {
					if (lesRapports.aReussi()) {
						lesDetails += "\n<br>" + lesRapports.getMessageUtilisateur();
						cptOk++;
					}
					else {
						lesDetails += "\n<br><span class=\"echec\">" + lesRapports.getMessageUtilisateur() + "</span>";
						cptErreur++;
					}

					noErreurRapport = noErreurRapport && (lesRapports.aReussi());
				}

				if (noErreurRapport && nbEchecs == 0) {
					ecriveur.ajouterLigne(dateFin + ":Tous les statuts ont t mis a jour", true);
				}
				else {
					ecriveur.ajouterLigne(dateFin + ":" + nbEchecs + " commandes n'ont pas t mise a jour sur " + nbArticles + ".", false);
					ecriveur.ajouterLigne(dateFin + ":Fin de la transmission.", true);
				}

				if (!lesDetails.equals("")) {
					ecriveur.ajouterLigne(" ****************** DETAILS **************", true);
					ecriveur.ajouterLigne(lesDetails, true);
				}
			}
			else {
				ecriveur.ajouterLigne("Pas de commande a mettre  jour", true);
			}

			ecriveur.fermerFichier();

		}
		catch (java.io.IOException e) {
			ToolsMAJ.ecrireLog(aEcrire,type,"[MAJStatutCom(ecrireRapport)] ERREUR:" + e);
		}

	}

	private void validerDansOpenSi(Connection con, String base, String site_id) {
		try {
			String listeId_str = "";

			if (!listeId.isEmpty()) {
				listeId_str += "'" + ToolsMAJ.sqlEncode(listeId.elementAt(0)) + "'";
			}

			for (int i = 1; i < listeId.size(); i++) {
				listeId_str += ",'" + ToolsMAJ.sqlEncode(listeId.elementAt(i)) + "'";
			}

			String req = "UPDATE " + base + ".COMMANDE_CLIENT_WEB SET Statut_Modifie=0 WHERE Site_Web_Id=" + site_id;
			req += " AND Commande_Id IN (" + listeId_str + ")";
			Statement state = con.createStatement();
			state.executeUpdate(req);
		}
		catch (Exception e) {
			ToolsMAJ.ecrireLog(aEcrire,type,"[MAJStatutCom(validerDansOpenSi)] ERREUR " + e);
		}
	}
}
