/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 *  Mise a jour des articles
 */

package org.opensi.webmanager.fonctions_periodiques;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Vector;

import org.opensi.webmanager.utils.AppelServices;
import org.opensi.webmanager.utils.ArticleFournisseurStruct;
import org.opensi.webmanager.utils.ArticleStruct;
import org.opensi.webmanager.utils.ListeArticleFournisseurStruct;
import org.opensi.webmanager.utils.ListeArticleStruct;
import org.opensi.webmanager.utils.ToolsMAJ;

/**
 * Procdure de mise  jour des articles. (on-line/off-line)
 */
public class MAJArticles extends MAJ {

	public Vector<String> listeIdWeb;
	public Vector<String> listeIdOpenSi;
	
	/**
	 * Procdure de mise  jour des articles.
	 * 
	 * Timeout:Le temps maximum d'attente d'une rponse de la part du webservice.
	 * Si il y a plus de nbRapport pour cette mise  jour, alors les plus vieux
	 * rapports sont effacs.
	 * 
	 * @param nbArticles
	 *          nombre d'article maximum par envoi
	 * @param timeoutService
	 *          timeout en milisecondes
	 * @param lenbRapports
	 *          nombre de rapport  conserver
	 */
	public MAJArticles(int nbArticles, int timeoutService, int lenbRapports,String fichier, String nomtype) {
		super(nbArticles,timeoutService,lenbRapports,fichier,nomtype);
	}
	public MAJArticles(int nbArticles, int timeoutService, int lenbRapports) {
		super(nbArticles,timeoutService,lenbRapports);
	}

	/**
	 * Lance la mise  jour.
	 * 
	 * La mise  jour est faite en plusieurs tapes: On regarde si il y a des
	 * articles  mettre  jour, puis on cre la liste d'article a envoyer au
	 * serveur, si tout s'est bien pass, on enregistre dans OpenSi que ces
	 * articles sont maintenant  jour.
	 * 
	 * @param serveur
	 *          url du web service
	 * @param dossierRoot
	 *          chemin vers la racine du serveur (opensi-serveur)
	 * @param dossierId
	 *          Identifiant du dossier
	 * @param con
	 *          Connexion  la base de donne (elle n'est ni ouverte ni ferme)
	 * @param base
	 *          Nom de la base de donne sur la quelle rcuprer les infos
	 *          (FACTU_qquechose)
	 * @param site_id
	 *          identifiant du site
	 * @return vrai si la mise  jour s'est bien passe, faux sinon.
	 */
	public boolean lancerMAJ(String serveur, String dossierRoot, String dossierId, Connection con, String base, String site_id) {

		java.util.Date date = new java.util.Date();
		Timestamp stamp = new Timestamp(date.getTime());
		dateDebut = "" + stamp;

		appelService(serveur, con, base, site_id, dossierRoot, dossierId);

		date = new java.util.Date();
		stamp = new Timestamp(date.getTime());
		dateFin = "" + stamp;
		ecrireRapport(dossierRoot, dossierId, site_id,type,ToolsMAJ.TYPE_MAJ_ARTICLES);

		return appelToutServiceReussi;

	}

	/**
	 * 
	 * @param serveur
	 * @param con
	 * @param base
	 * @param site_id
	 * @param dossierRoot
	 * @param dossierId
	 */
	private void appelService(String serveur, Connection con, String base, String site_id, String dossierRoot, String dossierId) {
		try {
			AppelServices.setTimeout(Integer.valueOf(timeout));

			System.out.print("[MAJArticles] Debut appels du service");
			ListeArticleStruct listeArticle = new ListeArticleStruct();

			// Les articles a ajouter
			String liste = "SELECT 1 as En_Ligne,w.Article_Id as refOpensi, w.Article_Id_Site as ref, Stock_Web, Prix_Web,Tarif_1,Tarif_2,Tarif_3,Tarif_4,Tarif_5,Tarif_1_TTC,Tarif_2_TTC,Tarif_3_TTC,Tarif_4_TTC,Tarif_5_TTC, Designation, fa1.Libelle as Famille_1, coalesce(fa2.Libelle,'') as Famille_2,";
			liste += " coalesce(ma.Libelle,'') as Marque, coalesce(cca.Libelle,'') as Collection, if(Mesure_Poids='K',Poids_Brut,if(Mesure_Poids='G',Poids_Brut/1000,Poids_Brut*1000)) as Poids_Brut, Descrip_1, t.Taux_Tva, coalesce(ta.Libelle,'') as Taille, coalesce(ca.Libelle,'') as Couleur, Eco_Taxe ";
			liste += " FROM " + base + ".FICHE_ARTICLE_WEB w, " + base + ".TAUX_TVA t, "+ base +".FAMILLE_ARTICLE fa1, " + base + ".FICHE_ARTICLE f";
			liste += " left join "+ base +".FAMILLE_ARTICLE fa2 on f.Famille_2=fa2.Famille_Id";
			liste += " left join "+ base +".MARQUE_ARTICLE ma on f.Marque_Id=ma.Marque_Id";
			liste += " left join "+ base +".COULEUR_ARTICLE ca on f.Couleur_Id=ca.Couleur_Id";
			liste += " left join "+ base +".TAILLE_ARTICLE ta on f.Taille_Id=ta.Taille_Id";
			liste += " left join "+ base +".COLLECTION_ARTICLE cca on f.Collection_Id=cca.Collection_Id";
			liste += " WHERE f.Famille_1=fa1.Famille_Id and Site_Id=" + site_id + " AND f.Article_Id=w.Article_Id AND w.Etat_Existance=1 AND t.Code_Tva=f.Code_Tva and f.Supprime=0";
			liste += " UNION ";
			liste += "SELECT 0 as En_Ligne,w.Article_Id as refOpensi, w.Article_Id_Site as ref, Stock_Web, Prix_Web,Tarif_1,Tarif_2,Tarif_3,Tarif_4,Tarif_5,Tarif_1_TTC,Tarif_2_TTC,Tarif_3_TTC,Tarif_4_TTC,Tarif_5_TTC, Designation, fa1.Libelle as Famille_1, coalesce(fa2.Libelle,'') as Famille_2,";
			liste += " coalesce(ma.Libelle,'') as Marque, coalesce(cca.Libelle,'') as Collection, if(Mesure_Poids='K',Poids_Brut,if(Mesure_Poids='G',Poids_Brut/1000,Poids_Brut*1000)) as Poids_Brut, Descrip_1, t.Taux_Tva, coalesce(ta.Libelle,'') as Taille, coalesce(ca.Libelle,'') as Couleur, Eco_Taxe";
			liste += " FROM " + base + ".FICHE_ARTICLE_WEB w, " + base + ".TAUX_TVA t, "+ base +".FAMILLE_ARTICLE fa1, " + base + ".FICHE_ARTICLE f";
			liste += " left join "+ base +".FAMILLE_ARTICLE fa2 on f.Famille_2=fa2.Famille_Id";
			liste += " left join "+ base +".MARQUE_ARTICLE ma on f.Marque_Id=ma.Marque_Id";
			liste += " left join "+ base +".COULEUR_ARTICLE ca on f.Couleur_Id=ca.Couleur_Id";
			liste += " left join "+ base +".TAILLE_ARTICLE ta on f.Taille_Id=ta.Taille_Id";
			liste += " left join "+ base +".COLLECTION_ARTICLE cca on f.Collection_Id=cca.Collection_Id";
			liste += " WHERE f.Famille_1=fa1.Famille_Id and Site_Id=" + site_id + " AND f.Article_Id=w.Article_Id AND w.Etat_Existance=-1 AND t.Code_Tva=f.Code_Tva and f.Supprime=0";
			
			listeIdWeb = new Vector<String>();
			listeIdOpenSi = new Vector<String>();
			PreparedStatement psListeAdd = con.prepareStatement(liste);
			ResultSet resultListeAdd = psListeAdd.executeQuery();

			nbArticles = 0;
			int compteur = 0;
			while (resultListeAdd.next()) {
				System.out.print("[MAJArticles] " + resultListeAdd.getString("ref"));
				ArticleStruct articleTemp = new ArticleStruct();
				articleTemp.setString(articleTemp.REFERENCE,"" + resultListeAdd.getString("ref"));
				articleTemp.setString(articleTemp.REFERENCE_OPENSI,"" + resultListeAdd.getString("refOpensi"));
				articleTemp.setBoolean(articleTemp.EN_LIGNE,(resultListeAdd.getDouble("En_Ligne")==1)?true:false);
				articleTemp.setString(articleTemp.DESIGNATION,resultListeAdd.getString("Designation"));
				String desc = resultListeAdd.getString("Descrip_1");
				articleTemp.setString(articleTemp.DESCRIPTION,(desc != null)?desc:"");
				articleTemp.setDouble(articleTemp.POIDS,resultListeAdd.getDouble("Poids_Brut"));
				articleTemp.setString(articleTemp.MARQUE,resultListeAdd.getString("Marque"));
				articleTemp.setString(articleTemp.COLLECTION,resultListeAdd.getString("Collection"));
				articleTemp.setDouble(articleTemp.PRIX_WEB,resultListeAdd.getDouble("Prix_Web"));
				articleTemp.setDouble(articleTemp.TARIF_1,resultListeAdd.getDouble("Tarif_1"));
				articleTemp.setDouble(articleTemp.TARIF_1_TTC,resultListeAdd.getDouble("Tarif_1_TTC"));
				articleTemp.setDouble(articleTemp.TARIF_2,resultListeAdd.getDouble("Tarif_2"));
				articleTemp.setDouble(articleTemp.TARIF_2_TTC,resultListeAdd.getDouble("Tarif_2_TTC"));
				articleTemp.setDouble(articleTemp.TARIF_3,resultListeAdd.getDouble("Tarif_3"));
				articleTemp.setDouble(articleTemp.TARIF_3_TTC,resultListeAdd.getDouble("Tarif_3_TTC"));
				articleTemp.setDouble(articleTemp.TARIF_4,resultListeAdd.getDouble("Tarif_4"));
				articleTemp.setDouble(articleTemp.TARIF_4_TTC,resultListeAdd.getDouble("Tarif_4_TTC"));
				articleTemp.setDouble(articleTemp.TARIF_5,resultListeAdd.getDouble("Tarif_5"));
				articleTemp.setDouble(articleTemp.TARIF_5_TTC,resultListeAdd.getDouble("Tarif_5_TTC"));
				articleTemp.setDouble(articleTemp.STOCK,resultListeAdd.getDouble("Stock_Web"));
				articleTemp.setString(articleTemp.FAMILLE,resultListeAdd.getString("Famille_1"));
				articleTemp.setString(articleTemp.SOUS_FAMILLE,resultListeAdd.getString("Famille_2"));
				articleTemp.setDouble(articleTemp.TVA,resultListeAdd.getDouble("Taux_Tva"));
				articleTemp.setString(articleTemp.TAILLE,resultListeAdd.getString("Taille"));
				articleTemp.setString(articleTemp.COULEUR,resultListeAdd.getString("Couleur"));
				articleTemp.setDouble(articleTemp.ECO_TAXE,resultListeAdd.getDouble("Eco_Taxe"));
				
				ListeArticleFournisseurStruct listeArticleFournisseur=new ListeArticleFournisseurStruct();

				String listeaf = "SELECT * from " + base + ".FOURNISSEUR_ARTICLE where Article_Id='"+resultListeAdd.getString("refOpensi")+"'";
				
				PreparedStatement psListeaf = con.prepareStatement(listeaf);
				ResultSet resultListeaf = psListeaf.executeQuery();
				while (resultListeaf.next()) {
					ArticleFournisseurStruct article=new ArticleFournisseurStruct();
					article.setString(article.REFERENCE,resultListeaf.getString("Article_Id"));
					article.setString(article.FOURNISSEUR,resultListeaf.getString("Fournisseur_Id"));
					article.setString(article.REFERENCE_FOURNISSEUR,resultListeaf.getString("Ref_Fournisseur"));

					listeArticleFournisseur.addArticle(article);
					
				}
				articleTemp.setStruct(articleTemp.LISTE_REFERENCE_FOURNISSEUR,listeArticleFournisseur.getListeStruct());				
			
				listeArticle.addArticle(articleTemp);
				listeIdWeb.add(resultListeAdd.getString("ref"));
				listeIdOpenSi.add(resultListeAdd.getString("refOpensi"));
				
				
				// On envoi tout les nbArticlesParEnvoi articles
				if ((compteur % nbArticlesParEnvoi) == 0 && compteur > 0) {
					publication(serveur, listeArticle.getListeArticle());

					//envoyerImagesArticles(serveur, dossierRoot, dossierId);

					if (appelServiceReussi) {
						validerDansOpenSi(con, base, site_id);
					}
					else {
						nbEchecs += nbArticlesParEnvoi;
					}

					listeIdWeb = new Vector<String>();// pour les images
					listeIdOpenSi = new Vector<String>();// pour les images et la
					// validation
					listeArticle = new ListeArticleStruct();
				}

				compteur++;
			}
			nbArticles = compteur;

			if (nbArticles > 0) {
				// On publie les derniers
				System.out.print("[MAJArticles] Les derniers J'en envoie " + nbArticlesParEnvoi);
				publication(serveur, listeArticle.getListeArticle());

				System.out.print("[MAJArticles] J'envoie les images");
				envoyerImagesArticles(serveur, dossierRoot, dossierId);

				if (appelServiceReussi) {
					System.out.print("[MAJArticles] Appel russi, je valide");
					validerDansOpenSi(con, base, site_id);
				}
				else {
					nbEchecs += listeArticle.getTaille();
				}
			}

		}
		catch (Exception e) {
			e.printStackTrace();
			appelToutServiceReussi = false;

		}

	}
	private void publication(String url_serveur, Object[] articles) {

		appelServiceReussi = true;
		Object result = AppelServices.ajoutArticles(url_serveur, articles);
		try {
			Object[] rep = (Object[]) result;
			rapport = (Object[]) rep[0];
			lesRapports.addRapport(rapport);
			for (int i = 0; i < rapport.length; i++) {
				Object[] contenu = (Object[]) rapport[i];
				if (Integer.parseInt(""+contenu[0]) > 100) {
					appelServiceReussi = false;
					appelToutServiceReussi = appelToutServiceReussi && appelServiceReussi;
				}
			}
		}
		catch (Exception e) {
			appelServiceReussi = false;
			appelToutServiceReussi = appelToutServiceReussi && appelServiceReussi;
			e.printStackTrace();
		}
	}

	private void envoyerImagesArticles(String serveur, String dossierRoot, String dossierId) {
		// Ajout des images au site
		for (int i = 0; i < listeIdWeb.size(); i++) {
			publicationImage(serveur, dossierRoot, dossierId, "" + listeIdOpenSi.elementAt(i), "" + listeIdWeb.elementAt(i));
		}
	}

	private void validerDansOpenSi(Connection con, String base, String site_id) {
		try {
			String listeIds = "";

			if (listeIdOpenSi.size() > 0) {
				listeIds += "'" + ToolsMAJ.sqlEncode("" + listeIdOpenSi.elementAt(0)) + "'";
			}

			for (int i = 1; i < listeIdOpenSi.size(); i++) {
				listeIds += ",'" + ToolsMAJ.sqlEncode("" + listeIdOpenSi.elementAt(i)) + "'";
			}

			String requeteMaj = "UPDATE " + base + ".FICHE_ARTICLE_WEB SET Statut_Web='n' WHERE Etat_Existance=1 And Site_Id=" + site_id;
			requeteMaj += " AND Article_Id IN(" + listeIds + ")";


			Statement state = con.createStatement();
			state.executeUpdate(requeteMaj);

			requeteMaj = "UPDATE " + base + ".FICHE_ARTICLE_WEB SET Statut_Web='f' WHERE Etat_Existance=-1 And Site_Id=" + site_id;
			requeteMaj += " AND Article_Id IN(" + listeIds + ")";


			state = con.createStatement();
			state.executeUpdate(requeteMaj);

			requeteMaj = "UPDATE " + base + ".FICHE_ARTICLE_WEB SET Etat_Existance=0 ";
			requeteMaj += " WHERE ( Etat_Existance=-1 Or Etat_Existance=1) And Site_Id=" + site_id;
			requeteMaj += " AND Article_Id IN(" + listeIds + ")";
			state = con.createStatement();
			state.executeUpdate(requeteMaj);
		}
		catch (Exception e) {
			e.printStackTrace();
		}
	}
}
