/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

package org.opensi.webmanager.fonctions_periodiques;

/**
 * Lance le serveur de mise  jour de faon indpedante de OpenSi.
 */
public class LancementServeur extends Thread {
	private String root;

	private String driver;

	private String url;

	private String login;

	private String mdp;

	private String dossier_maj;

	private int port;

	/**
	 * Constructeur
	 * 
	 * @param dossier_root
	 *          dossier ou se trouve "opensi-serveur"
	 * @param url_bd
	 *          url de la base de donnes
	 * @param driver_bd
	 *          driver de la base de donne
	 * @param login_bd
	 *          login de la base de donne
	 * @param mdp_bd
	 *          mot de passe pour la base de donne
	 * @param port
	 *          numro de port a utiliser pour le service de mise  jour
	 * @param dossier_maj
	 *          chemin vers le dossier "maj_automatiques"
	 */
	public LancementServeur(String dossier_root, String url_bd, String driver_bd, String login_bd, String mdp_bd, int port, String dossier_maj) {
		root = dossier_root;
		driver = driver_bd;
		url = url_bd;
		login = login_bd;
		mdp = mdp_bd;
		this.dossier_maj = dossier_maj;
		this.port = port;

	}

	/**
	 * Execution de la thread
	 */
	public void run() {
		String cmde = "sh " + dossier_maj + "/maj_automatiques/lancerServeur.sh " + dossier_maj + "/maj_automatiques/";
		cmde += " \"" + url + "|" + driver + "|" + login + "|" + mdp + "|" + root + "\" " + port + " ";

		try {
			// execution de la commande
			Runtime run = Runtime.getRuntime();
			run.exec(cmde);
		}
		catch (Exception e) {
			e.printStackTrace();
		}
	}

}
