/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Gnration d'un bordereau de remise d'espces
 */

package org.opensi.facturation.reglements.clients;


import java.awt.Color;

import org.opensi.util.pdf.MultiPagesDocument;
import org.opensi.util.pdf.PdfWidths;
import org.opensi.util.pdf.TableBuilder;
import org.opensi.util.tools.Formatter;

import com.lowagie.text.DocumentException;
import com.lowagie.text.Font;
import com.lowagie.text.Image;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;


public class PdfRemiseEspeces extends MultiPagesDocument {


private static final Font fontTitreColonne = new Font(Font.HELVETICA, 10, Font.BOLD);
private static final Font fontEnteteColonne = new Font(Font.HELVETICA, 9, Font.BOLD);
private static final Font fontGen = new Font(Font.HELVETICA , 10, Font.NORMAL);
private static final Font fontLine = new Font(Font.HELVETICA , 8, Font.NORMAL);
private static final Font fontTitre = new Font(Font.HELVETICA, 16, Font.BOLD);
private static final Font fontSousTotal = new Font(Font.HELVETICA , 10, Font.NORMAL);
private static final Font fontTotal = new Font(Font.HELVETICA , 10, Font.BOLD);

private Formatter numFormat = new Formatter("0.00", true);


private DataRemiseEspeces dre;	   // les donnes dynamiques du bordereau de remise d'espces

private float[] widthsCols;
private int nbCols;



  public PdfRemiseEspeces(String tempdir, DataRemiseEspeces dre) throws Exception {

		super(tempdir);
		
		this.dre = dre;
		
		PdfWidths pw = new PdfWidths();
		
		pw.addColonneVariableMin(1,15);
		pw.addColonneVariableMin(1,10);
		pw.addColonneVariableMin(1,15);
		pw.addColonneFixe(0.5f);
		pw.addColonneVariableMin(1,15);
		pw.addColonneVariableMin(1,10);
		pw.addColonneVariableMin(1,10);
		pw.addColonneVariableMin(1,10);
		pw.addColonneVariableMin(1,15);
		
		nbCols = pw.getNbCols();
		widthsCols = pw.getWidthsCols();
	}


	
	/* implmentation des fonctions de MultiPagesDocument */
	
	public PdfPTable firstHeader() throws DocumentException {
		
		TableBuilder tb = new TableBuilder();
		
		tb.add(makeEntete());
		tb.add(makeRIB());
		tb.add(makeSpace(5));
		tb.add(makeEntetesColonnes());		
		
		return tb.getTable();	
	}
	
	
	public PdfPTable middleHeader(int lastLine) throws DocumentException {
		
		TableBuilder tb = new TableBuilder();
		
		tb.add(firstHeader());
		
		return tb.getTable();
	}
	
	
	public PdfPTable lastFooter() throws DocumentException {
		
		TableBuilder tb = new TableBuilder();
		
		tb.add(makeTotauxLast());
		
		return tb.getTable();
	}
	
	
	public PdfPTable middleFooter(int nbLinesPage, int lastLine) throws DocumentException {
			
		TableBuilder tb = new TableBuilder();
		
		tb.add(makeFinPage());
		
		return tb.getTable();		
	}
	
	
	public PdfPTable bodyLine(int numLine) throws DocumentException {
	
		return makeLine(numLine);
	}
	
	
	public PdfPTable emptyLine(float emptyHeight) throws DocumentException {
		
		PdfPTable pptSpace = new PdfPTable(nbCols);
		pptSpace.setWidthPercentage(100);
		pptSpace.setWidths(widthsCols);
		
		PdfPCell cell = new PdfPCell(pptSpace.getDefaultCell());
		cell.setBorder(PdfPCell.LEFT+PdfPCell.RIGHT);
		cell.setPaddingBottom(0);
		cell.setPaddingTop(0);
		cell.setFixedHeight(emptyHeight);		
		cell.setPhrase(new Phrase(""));		
	
		for (int i=0; i<nbCols; i++) {
			pptSpace.addCell(cell);
		}
	
		return pptSpace;
	}
	
	
	public int nbLines() {
		int nbLignesPieces = dre.getNbLignesPieces();
		int nbLignesBillets = dre.getNbLignesBillets();
		return nbLignesPieces>nbLignesBillets?nbLignesPieces:nbLignesBillets;
	}
	
	
	public int nbEx() {
	
		return 1;
	}
	
	
	public Image imageFond() {
	
		return null;
	}



	/* mthodes internes */
		

	private PdfPTable makeSpace(int space) {
	
		PdfPTable pptSpace = new PdfPTable(1);
		PdfPCell cell = new PdfPCell(pptSpace.getDefaultCell());
		cell.setBorder(PdfPCell.NO_BORDER);
		cell.setFixedHeight(space);
		cell.setPhrase(new Phrase(""));
	
		pptSpace.addCell(cell);
	
		return pptSpace;
	}
	

	private PdfPTable makeEntete() throws DocumentException {
	
		PdfPTable bandeau = new PdfPTable(1);

		bandeau.setWidthPercentage(100);

		PdfPTable entete = new PdfPTable(3);

		PdfPCell cellEntete = new PdfPCell(entete.getDefaultCell());

		cellEntete.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
		cellEntete.setBorderWidth(0);
		cellEntete.setMinimumHeight(10);

		cellEntete.setColspan(1);
		cellEntete.setPhrase(new Phrase("Date : " + dre.dateCourante, fontGen));
		entete.addCell(cellEntete);

		cellEntete.setPhrase(new Phrase(dre.raisonSociale, fontGen));
		cellEntete.setColspan(2);
		cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
		entete.addCell(cellEntete);

		cellEntete.setColspan(1);
		cellEntete.setPhrase(new Phrase("", fontGen));
		cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
		entete.addCell(cellEntete);

		cellEntete.setPhrase(new Phrase(dre.adresse1, fontGen));
		cellEntete.setColspan(2);
		cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
		entete.addCell(cellEntete);
		cellEntete.setColspan(1);

		cellEntete.setPhrase(new Phrase("Page : "+ currentPage, fontGen));
		cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
		entete.addCell(cellEntete);

		cellEntete.setPhrase(new Phrase(dre.adresse2, fontGen));
		cellEntete.setColspan(2);
		cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
		entete.addCell(cellEntete);
		cellEntete.setColspan(1);

		cellEntete.setPhrase(new Phrase("", fontGen));
		cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
		entete.addCell(cellEntete);
		
		if (!dre.adresse3.equals("")) {
			cellEntete.setPhrase(new Phrase(dre.adresse3, fontGen));
			cellEntete.setColspan(2);
			cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
			entete.addCell(cellEntete);
			cellEntete.setColspan(1);

			cellEntete.setPhrase(new Phrase("", fontGen));
			cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
			entete.addCell(cellEntete);
		}

		cellEntete.setPhrase(new Phrase(dre.codePostal + " " + dre.ville, fontGen));
		cellEntete.setColspan(2);
		cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
		entete.addCell(cellEntete);

		cellEntete.setPhrase(new Phrase("BORDEREAU DE REMISE " + dre.typer+" en Euros", fontTitre));
		cellEntete.setColspan(3);
		cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
		entete.addCell(cellEntete);

		PdfPCell cellBandeau = new PdfPCell(entete);
		cellBandeau.setPadding(10);

		bandeau.addCell(cellBandeau);
		
		return bandeau;		
	}
	
	
	private PdfPTable makeRIB() throws DocumentException {
		
		int widthsHaut[] = {14,14,11,10,1,50}; // largeurs des colonnes du RIB Haut
		int widthsBas[] = {7,7,7,7,7,7,7,1,50}; // largeurs des colonnes du RIB Bas
		
		PdfPTable pptRIB = new PdfPTable(1);
		pptRIB.setWidthPercentage(100);
		
		PdfPTable RIBHaut = new PdfPTable(6);
		RIBHaut.setWidthPercentage(100);
		RIBHaut.setWidths(widthsHaut);
		PdfPCell cellRIB = new PdfPCell(RIBHaut.getDefaultCell());

		cellRIB.setColspan(6);
		cellRIB.setFixedHeight(20);
		cellRIB.setBorder(PdfPCell.NO_BORDER);
		cellRIB.setPhrase(new Phrase("", fontLine));
		RIBHaut.addCell(cellRIB);

		cellRIB.setFixedHeight(15);
		cellRIB.setBorder(PdfPCell.BOX);

		cellRIB.setColspan(1);
		cellRIB.setBackgroundColor(Color.LIGHT_GRAY);
		cellRIB.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
		cellRIB.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);

		cellRIB.setPhrase(new Phrase("C/ETAB'", fontLine));
		RIBHaut.addCell(cellRIB);

		cellRIB.setPhrase(new Phrase("C/GUICHET", fontLine));
		RIBHaut.addCell(cellRIB);

		cellRIB.setPhrase(new Phrase("N\u00B0 COMPTE", fontLine));
		RIBHaut.addCell(cellRIB);

		cellRIB.setPhrase(new Phrase("CLE RIB", fontLine));
		RIBHaut.addCell(cellRIB);

		cellRIB.setBackgroundColor(Color.WHITE);
		cellRIB.setBorder(PdfPCell.LEFT+PdfPCell.RIGHT);
		cellRIB.setPhrase(new Phrase("", fontLine));
		RIBHaut.addCell(cellRIB);
		cellRIB.setBorder(PdfPCell.BOX);
		cellRIB.setBackgroundColor(Color.LIGHT_GRAY);

		cellRIB.setPhrase(new Phrase("DOMICILIATION", fontLine));
		RIBHaut.addCell(cellRIB);

		cellRIB.setBackgroundColor(Color.WHITE);

		cellRIB.setPhrase(new Phrase(dre.codeAgence, fontLine));
		RIBHaut.addCell(cellRIB);

		cellRIB.setPhrase(new Phrase(dre.codeGuichet, fontLine));
		RIBHaut.addCell(cellRIB);

		cellRIB.setPhrase(new Phrase(dre.compte, fontLine));
		RIBHaut.addCell(cellRIB);

		cellRIB.setPhrase(new Phrase(dre.cleRib, fontLine));
		RIBHaut.addCell(cellRIB);

		cellRIB.setBorder(PdfPCell.LEFT+PdfPCell.RIGHT);
		cellRIB.setPhrase(new Phrase("", fontLine));
		RIBHaut.addCell(cellRIB);
		cellRIB.setBorder(PdfPCell.BOX);

		cellRIB.setPhrase(new Phrase(dre.adresseBanque, fontLine));
		RIBHaut.addCell(cellRIB);
		
		
		PdfPTable RIBBas = new PdfPTable(9);
		RIBBas.setWidthPercentage(100);
		RIBBas.setWidths(widthsBas);
		cellRIB = new PdfPCell(RIBBas.getDefaultCell());

		cellRIB.setColspan(7);
		cellRIB.setFixedHeight(5);
		cellRIB.setBorder(PdfPCell.TOP);
		cellRIB.setBackgroundColor(Color.WHITE);
		cellRIB.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
		cellRIB.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);

		cellRIB.setPhrase(new Phrase("", fontLine));
		RIBBas.addCell(cellRIB);

		cellRIB.setBorder(PdfPCell.NO_BORDER);
		cellRIB.setColspan(1);
		cellRIB.setPhrase(new Phrase("", fontLine));
		RIBBas.addCell(cellRIB);

		cellRIB.setBorder(PdfPCell.TOP);
		cellRIB.setColspan(1);
		cellRIB.setPhrase(new Phrase("", fontLine));
		RIBBas.addCell(cellRIB);

		cellRIB.setFixedHeight(15);
		cellRIB.setBorder(PdfPCell.BOX);
		cellRIB.setBackgroundColor(Color.LIGHT_GRAY);
		cellRIB.setColspan(7);
		cellRIB.setPhrase(new Phrase("IBAN", fontLine));
		RIBBas.addCell(cellRIB);

		cellRIB.setColspan(1);

		cellRIB.setBackgroundColor(Color.WHITE);
		cellRIB.setBorder(PdfPCell.LEFT+PdfPCell.RIGHT);
		cellRIB.setPhrase(new Phrase("", fontLine));
		RIBBas.addCell(cellRIB);
		cellRIB.setBorder(PdfPCell.BOX);
		cellRIB.setBackgroundColor(Color.LIGHT_GRAY);

		cellRIB.setPhrase(new Phrase("BIC", fontLine));
		RIBBas.addCell(cellRIB);


		if (dre.iban.equals("")) {
			cellRIB.setColspan(7);
			cellRIB.setBackgroundColor(Color.WHITE);
			cellRIB.setBorder(PdfPCell.BOX);
			cellRIB.setPhrase(new Phrase("", fontLine));
			RIBBas.addCell(cellRIB);

		}
		else {
			cellRIB.setColspan(1);
			cellRIB.setBackgroundColor(Color.WHITE);

			cellRIB.setBorder(PdfPCell.BOX-PdfPCell.RIGHT);
			cellRIB.setPhrase(new Phrase(dre.iban, fontLine));
			RIBBas.addCell(cellRIB);

			cellRIB.setBorder(PdfPCell.BOX-PdfPCell.LEFT-PdfPCell.RIGHT);
			cellRIB.setPhrase(new Phrase(dre.codeAgence.substring(0,4), fontLine));
			RIBBas.addCell(cellRIB);

			cellRIB.setPhrase(new Phrase(dre.codeAgence.substring(4)+""+dre.codeGuichet.substring(0,3), fontLine));
			RIBBas.addCell(cellRIB);

			cellRIB.setPhrase(new Phrase(dre.codeGuichet.substring(3)+""+dre.compte.substring(0,2), fontLine));
			RIBBas.addCell(cellRIB);

			cellRIB.setPhrase(new Phrase(dre.compte.substring(2,6), fontLine));
			RIBBas.addCell(cellRIB);

			cellRIB.setPhrase(new Phrase(dre.compte.substring(6,10), fontLine));
			RIBBas.addCell(cellRIB);
			cellRIB.setBorder(PdfPCell.BOX-PdfPCell.LEFT);
			cellRIB.setPhrase(new Phrase(dre.compte.substring(10)+""+dre.cleRib, fontLine));
			RIBBas.addCell(cellRIB);
		}
		cellRIB.setBackgroundColor(Color.WHITE);
		cellRIB.setBorder(PdfPCell.LEFT+PdfPCell.RIGHT);
		cellRIB.setPhrase(new Phrase("", fontLine));
		cellRIB.setColspan(1);
		RIBBas.addCell(cellRIB);
		cellRIB.setBorder(PdfPCell.BOX);

		cellRIB.setColspan(1);
		cellRIB.setPhrase(new Phrase(dre.bic, fontLine));
		RIBBas.addCell(cellRIB);

		
		PdfPCell cell = new PdfPCell(RIBHaut);
		cell.setBorder(PdfPCell.NO_BORDER);
		pptRIB.addCell(cell);
		
		cell = new PdfPCell(RIBBas);
		cell.setBorder(PdfPCell.NO_BORDER);
		pptRIB.addCell(cell);
		
		return pptRIB;
		
	}


	private PdfPTable makeEntetesColonnes() throws DocumentException {
	
		PdfPTable pptCols = new PdfPTable(nbCols);
		pptCols.setWidthPercentage(100);
		pptCols.setWidths(widthsCols);
		
		PdfPCell cell = new PdfPCell(pptCols.getDefaultCell());		
		
		cell.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
		cell.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
		cell.setPaddingBottom(4);
		cell.setMinimumHeight(15);
		cell.setBackgroundColor(Color.LIGHT_GRAY);
		cell.setPaddingLeft(20);
		cell.setPhrase(new Phrase("BILLETS", fontTitreColonne));
		cell.setColspan(3);
		pptCols.addCell(cell);
		
		cell.setPhrase(new Phrase("", fontTitreColonne));
		cell.setBackgroundColor(Color.WHITE);
		cell.setBorder(PdfPCell.NO_BORDER);
		cell.setColspan(1);
		pptCols.addCell(cell);
		
		cell.setBackgroundColor(Color.LIGHT_GRAY);
		cell.setBorder(PdfPCell.BOX);
		cell.setPhrase(new Phrase("PIECES", fontTitreColonne));
		cell.setColspan(5);
		pptCols.addCell(cell);
		
		cell.setPaddingLeft(0);
		cell.setPaddingRight(0);
		cell.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
		cell.setColspan(1);
		cell.setPhrase(new Phrase("Valeur faciale", fontEnteteColonne));
		pptCols.addCell(cell);
		
		cell.setPhrase(new Phrase("Nombre", fontEnteteColonne));
		pptCols.addCell(cell);

		cell.setPhrase(new Phrase("Montant", fontEnteteColonne));		
		pptCols.addCell(cell);
		
		cell.setPhrase(new Phrase("", fontEnteteColonne));
		cell.setBackgroundColor(Color.WHITE);
		cell.setBorder(PdfPCell.NO_BORDER);
		pptCols.addCell(cell);

		cell.setBackgroundColor(Color.LIGHT_GRAY);
		cell.setBorder(PdfPCell.BOX);
		cell.setPhrase(new Phrase("Valeur faciale", fontEnteteColonne));
		pptCols.addCell(cell);			
		
		cell.setPhrase(new Phrase("Nb pi\u00E8ces / rouleaux", fontEnteteColonne));
		pptCols.addCell(cell);
		
		cell.setPhrase(new Phrase("Valeur rouleau", fontEnteteColonne));
		pptCols.addCell(cell);
		
		cell.setPhrase(new Phrase("Nb Rouleaux", fontEnteteColonne));
		pptCols.addCell(cell);
		
		cell.setPhrase(new Phrase("Montant", fontEnteteColonne));		
		pptCols.addCell(cell);
		
		return pptCols;
	}
	
	
	private PdfPTable makeFinPage() {
	
		PdfPTable pptFP = new PdfPTable(1);
		pptFP.setWidthPercentage(100);
		
		PdfPCell cell = new PdfPCell(pptFP.getDefaultCell());
		cell.setBorder(PdfPCell.TOP);
		cell.setPhrase(new Phrase(""));
		cell.setPaddingBottom(0);
		cell.setPaddingTop(0);
		cell.setFixedHeight(1);
				
		pptFP.addCell(cell);
	
		return pptFP;
	}
	
	
	private PdfPTable makeLine(int numLine) throws DocumentException {
	
		PdfPTable pptLine = new PdfPTable(nbCols);
		pptLine.setWidthPercentage(100);
		pptLine.setWidths(widthsCols);
		
		PdfPCell cell = new PdfPCell(pptLine.getDefaultCell());
		cell.setBorder(PdfPCell.RIGHT + PdfPCell.LEFT);
		
		if (dre.getNbLignesBillets()>numLine) {
			LigneRemiseEspeces ligne = dre.lignesBillets.get(numLine);
			cell.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
			cell.setPhrase(new Phrase(numFormat.get(ligne.valeurFaciale), fontLine));
			pptLine.addCell(cell);
			cell.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
			cell.setPhrase(new Phrase(""+ligne.nombre, fontLine));
			pptLine.addCell(cell);
			cell.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
			cell.setPhrase(new Phrase(numFormat.get(ligne.montant), fontLine));
			pptLine.addCell(cell);
		} else {
			cell.setPhrase(new Phrase(""));
			pptLine.addCell(cell);
			pptLine.addCell(cell);
			pptLine.addCell(cell);
		}
		
		cell.setPhrase(new Phrase("", fontEnteteColonne));
		cell.setBorder(PdfPCell.NO_BORDER);
		pptLine.addCell(cell);

		cell.setBorder(PdfPCell.RIGHT + PdfPCell.LEFT);

		if (dre.getNbLignesPieces()>numLine) {
			LigneRemiseEspeces ligne = dre.lignesPieces.get(numLine);
			cell.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
			cell.setPhrase(new Phrase(numFormat.get(ligne.valeurFaciale), fontLine));
			pptLine.addCell(cell);
			cell.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
			cell.setPhrase(new Phrase(""+ligne.nbPiecesParRouleau, fontLine));
			pptLine.addCell(cell);
			cell.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
			cell.setPhrase(new Phrase(numFormat.get(ligne.valeurRouleau), fontLine));
			pptLine.addCell(cell);
			cell.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
			cell.setPhrase(new Phrase(""+ligne.nombre, fontLine));
			pptLine.addCell(cell);
			cell.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
			cell.setPhrase(new Phrase(numFormat.get(ligne.montant), fontLine));
			pptLine.addCell(cell);
		} else {
			cell.setPhrase(new Phrase(""));
			pptLine.addCell(cell);
			pptLine.addCell(cell);
			pptLine.addCell(cell);
			pptLine.addCell(cell);
			pptLine.addCell(cell);
		}

		return pptLine;
	}
	
	
	private PdfPTable makeTotauxLast() throws DocumentException {		
		
		PdfPTable pptTotaux = new PdfPTable(nbCols);
		pptTotaux.setWidthPercentage(100);
		pptTotaux.setWidths(widthsCols);
		
		PdfPCell cell = new PdfPCell(pptTotaux.getDefaultCell());
		cell.setBorder(PdfPCell.BOX-PdfPCell.RIGHT);
		cell.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
		cell.setBackgroundColor(Color.LIGHT_GRAY);
		
		cell.setColspan(2);
		cell.setPhrase(new Phrase("Total billets :", fontSousTotal));
		pptTotaux.addCell(cell);
		cell.setColspan(1);
		cell.setBorder(PdfPCell.BOX-PdfPCell.LEFT);
		cell.setPhrase(new Phrase(numFormat.get(dre.totalBillets) + " \u20AC", fontSousTotal));
		pptTotaux.addCell(cell);
		
		cell.setPhrase(new Phrase("", fontEnteteColonne));
		cell.setBackgroundColor(Color.WHITE);
		cell.setBorder(PdfPCell.NO_BORDER);
		pptTotaux.addCell(cell);
		
		cell.setBackgroundColor(Color.LIGHT_GRAY);
		cell.setBorder(PdfPCell.BOX-PdfPCell.RIGHT);
		cell.setColspan(4);
		cell.setPhrase(new Phrase("Total pices :", fontSousTotal));
		pptTotaux.addCell(cell);
		cell.setColspan(1);
		cell.setBorder(PdfPCell.BOX-PdfPCell.LEFT);
		cell.setPhrase(new Phrase(numFormat.get(dre.totalPieces) + " \u20AC", fontSousTotal));
		pptTotaux.addCell(cell);
		
		cell.setPhrase(new Phrase("", fontSousTotal));
		cell.setBackgroundColor(Color.WHITE);
		cell.setColspan(nbCols);
		cell.setFixedHeight(5);
		cell.setBorder(PdfPCell.NO_BORDER);
		pptTotaux.addCell(cell);
		
		cell.setMinimumHeight(0);
		cell.setBackgroundColor(Color.LIGHT_GRAY);
		cell.setBorder(PdfPCell.BOX-PdfPCell.RIGHT);
		cell.setColspan(8);
		cell.setPhrase(new Phrase("TOTAL :", fontTotal));
		pptTotaux.addCell(cell);
		cell.setColspan(1);
		cell.setBorder(PdfPCell.BOX-PdfPCell.LEFT);
		cell.setPhrase(new Phrase(numFormat.get(dre.totalBillets + dre.totalPieces) + " \u20AC", fontTotal));
		pptTotaux.addCell(cell);
		
		return pptTotaux;	
	}
	

} // fin PdfRemiseEspeces
