/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Donnes ncessaires  l'dition d'une liste de rglements
 */

package org.opensi.facturation.reglements.clients;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;

import org.opensi.api.SessionOSI;
import org.opensi.util.tools.DateTime;

public class DataReglements {
	
	protected String dateCourante;

	protected String dossierId;
	protected String raisonSociale;
	protected String adresse1;
	protected String adresse2;
	protected String adresse3;
	protected String codePostal;
	protected String ville;

	protected String debutExerciceStr = "";
	protected String finExerciceStr = "";
	
	protected String clientId = "";
	protected String modeReglement = "";
	protected String denominationClient = "";
	protected boolean detail;
	protected boolean sousTotaux;
	protected String tri;
	protected boolean historique;
	
	protected ArrayList<LigneReglements> lignes = new ArrayList<LigneReglements>(10);
	
	
	public DataReglements(SessionOSI sosi, String etat, long dateDebut, long dateFin, String modeReglement, String clientId, boolean detail, String tri, boolean sousTotaux) {

		try {
			Connection con = sosi.getConnection();
			Statement stt = con.createStatement();
			String base = sosi.getBaseDossier();
			this.dossierId = sosi.getDossierId();
			this.dateCourante = DateTime.formatTime(new DateTime().getTimeInMillis(), "dd/MM/yyyy");
			if (dateDebut!=0) { this.debutExerciceStr = DateTime.formatTime(dateDebut, "dd/MM/yyyy"); }
			if (dateFin!=0) { this.finExerciceStr = DateTime.formatTime(dateFin, "dd/MM/yyyy"); }
			this.detail = detail;
			this.tri = tri;
			this.sousTotaux = sousTotaux;
			this.historique = (etat.equals("T"));
			
			// coordonnes de l'entreprise
			String reqSociete = "select s.Denomination, s.Adresse_1, s.Adresse_2, s.Adresse_3, s.Code_Postal, s.Ville";
			reqSociete += " from "+ base +".SOCIETE s";
			ResultSet rset = stt.executeQuery(reqSociete);
			rset.next();
			this.raisonSociale = rset.getString("Denomination");
			this.adresse1 = rset.getString("Adresse_1");
			this.adresse2 = rset.getString("Adresse_2");
			this.adresse3 = rset.getString("Adresse_3");
			this.codePostal = rset.getString("Code_Postal");
			this.ville = rset.getString("Ville");
			rset.close();
			
			boolean afficherReglements = true;
			boolean afficherAvoirs = true;
			
			if (modeReglement.equals("A")) {
				this.modeReglement = "Avoir";
				afficherReglements = false;
			} else if (!modeReglement.equals("0")) {
				String reqModeReglement = "select Libelle from "+ base +".MODE_REGLEMENT where Mode_Reg_Id="+Integer.parseInt(modeReglement);
				rset = stt.executeQuery(reqModeReglement);
				rset.next();
				this.modeReglement = rset.getString("Libelle");
				rset.close();
				afficherAvoirs = false;
			}
			
			if (!clientId.equals("")) {
		 		String reqDenomination = "select Denomination from "+ base +".FICHE_CLIENT where Client_Id=?";
		 		PreparedStatement psDenomination = con.prepareStatement(reqDenomination);
				psDenomination.setString(1, clientId);
				rset = psDenomination.executeQuery();
				if (rset.next()) {
					this.clientId = clientId;
					this.denominationClient = rset.getString("Denomination");
				}
				rset.close();
				psDenomination.close();
			}
			
			String listeReglements = "select Reglement_Id, Date_Reg, Denomination, Num_Piece, Montant_Du, Montant_Restant, Client_Id, Mode_Reglement, Type from (";
			
			if (afficherReglements) {
				listeReglements += " (select rc.Reglement_Id, rc.Date_Reg, rc.Denomination, rc.Num_Piece,";
				listeReglements += " rc.Montant as Montant_Du, rc.Montant_Restant, coalesce(rc.Client_Id,'') as Client_Id,";
				listeReglements += " mr.Libelle as Mode_Reglement, 'R' as Type";
				listeReglements += " from "+ base +".REGLEMENT_CLIENT rc join "+ base +".MODE_REGLEMENT mr on rc.Mode_Reg_Id=mr.Mode_Reg_Id";
				listeReglements += " where rc.Statut='V'";
				if (!etat.equals("0")) {
					if (etat.equals("N")) { listeReglements += " and rc.Etat in ('N', 'P')"; }
					else { listeReglements += " and rc.Etat='T'"; }
				}
				if (!clientId.equals("")) {
					if (this.clientId.equals("")) { listeReglements += " and rc.Client_Id like ?"; }
					else { listeReglements += " and rc.Client_Id=?"; }
				}
				if (dateDebut != 0) { listeReglements += " and rc.Date_Reg>=?"; }
				if (dateFin != 0) { listeReglements += " and rc.Date_Reg<=?"; }
				if (!modeReglement.equals("0")) { listeReglements += " and rc.Mode_Reg_Id=?"; }
				listeReglements += ")";
			}
			if (modeReglement.equals("0")) { listeReglements += " union "; }
			if (afficherAvoirs) {
				listeReglements += " (select a.Avoir_Id as Reglement_Id, a.Date_Avoir as Date_Reg, a.Denomination, a.Num_Entier as Num_Piece,";
				listeReglements += " a.Total_TTC as Montant_Du, a.Montant_Restant, coalesce(a.Client_Id,'') as Client_Id,";
				listeReglements += " 'Avoir' as Mode_Reglement, 'A' as Type";
				listeReglements += " from "+ base +".AVOIR a where Numero<>0";
				if (!etat.equals("0")) {
					if (etat.equals("N")) { listeReglements += " and a.Etat in ('N', 'P')"; }
					else { listeReglements += " and a.Etat='T'"; }
				}
				if (!clientId.equals("")) {
					if (this.clientId.equals("")) { listeReglements += " and a.Client_Id like ?"; }
					else { listeReglements += " and a.Client_Id=?"; }
				}
				if (dateDebut != 0) { listeReglements += " and a.Date_Avoir>=?"; }
				if (dateFin != 0) { listeReglements += " and a.Date_Avoir<=?"; }
				listeReglements += ")";
			}
			listeReglements += ") as t";
			
			if (tri.equals("Date")) { listeReglements += " order by Date_Reg"; }
			else if (tri.equals("Client")) { listeReglements += " order by Client_Id, Denomination"; }
			else if (tri.equals("Piece")) { listeReglements += " order by Num_Piece"; }
			else if (tri.equals("Mode")) { listeReglements += " order by Mode_Reglement"; }
			else if (tri.equals("Montant")) { listeReglements += " order by Montant_Du"; }
			
			PreparedStatement psListeReglements = con.prepareStatement(listeReglements);
			int numPos = 0;
			if (afficherReglements) {
				if (!clientId.equals("")) {
					if (this.clientId.equals("")) { psListeReglements.setString(++numPos, "%"+clientId+"%"); }
					else { psListeReglements.setString(++numPos, clientId); }
				}
				if (dateDebut != 0) { psListeReglements.setLong(++numPos, dateDebut); }
				if (dateFin != 0) { psListeReglements.setLong(++numPos, dateFin); }
				if (!modeReglement.equals("0")) { psListeReglements.setInt(++numPos, Integer.parseInt(modeReglement)); }
			}
			if (afficherAvoirs) {
				if (!clientId.equals("")) {
					if (this.clientId.equals("")) { psListeReglements.setString(++numPos, "%"+clientId+"%"); }
					else { psListeReglements.setString(++numPos, clientId); }
				}
				if (dateDebut != 0) { psListeReglements.setLong(++numPos, dateDebut); }
				if (dateFin != 0) { psListeReglements.setLong(++numPos, dateFin); }
			}
			rset = psListeReglements.executeQuery();
			
			double total = 0;
			double totalRestant = 0;
			
			double montantTemp = 0;
			double montantRestantTemp = 0;
			long ancDateReglement=0;
			String ancClientId="";
			String ancDenomination="";
			String ancModeReglement="";
			String moisRegPrec = "";
			boolean premier=true;

			String reqDetailsReg = "select ec.Date_Echeance, rc.Num_Piece, mr.Libelle as Mode_Reglement, iec.Montant, 0 as Montant_Restant";
			reqDetailsReg += " from "+ base +".ECHEANCE_CLIENT ec join "+ base +".MODE_REGLEMENT mr on ec.Mode_Reg_Id=mr.Mode_Reg_Id";
			reqDetailsReg += " join "+ base +".IMPUTATION_ECHEANCE_CLIENT iec on ec.Echeance_Id=iec.Echeance_Id";
			reqDetailsReg += " join "+ base +".IMPUTATION_ECHEANCE_REGLEMENT_CLIENT ierc on iec.Imputation_Id=ierc.Imputation_Id";
			reqDetailsReg += " join "+ base +".REGLEMENT_CLIENT rc on ierc.Reglement_Id=rc.Reglement_Id";
			reqDetailsReg += " where rc.Reglement_Id=? order by ec.Date_Echeance";
			PreparedStatement psDetailsReg = con.prepareStatement(reqDetailsReg);
			
			String reqDetailsAvoir = "select ec.Date_Echeance, a.Num_Entier as Num_Piece, 'Avoir' as Mode_Reglement, iec.Montant, 0 as Montant_Restant";
			reqDetailsAvoir += " from "+ base +".ECHEANCE_CLIENT ec";
			reqDetailsAvoir += " join "+ base +".IMPUTATION_ECHEANCE_CLIENT iec on ec.Echeance_Id=iec.Echeance_Id";
			reqDetailsAvoir += " join "+ base +".IMPUTATION_ECHEANCE_AVOIR_CLIENT ieac on iec.Imputation_Id=ieac.Imputation_Id";
			reqDetailsAvoir += " join "+ base +".AVOIR a on ieac.Avoir_Id=a.Avoir_Id";
			reqDetailsAvoir += " where a.Avoir_Id=? order by ec.Date_Echeance";
			PreparedStatement psDetailsAvoir = con.prepareStatement(reqDetailsAvoir);
			
			String reqRegularisationReg = "select coalesce(sum(rrc.Montant),0) as Regularisation";
			reqRegularisationReg += " from "+ base +".IMPUTATION_REGLEMENT_CLIENT irc join "+ base +".REGULARISATION_REGLEMENT_CLIENT rrc on irc.Imputation_Id=rrc.Imputation_Id";
			reqRegularisationReg += " where irc.Reglement_Id=?";
			PreparedStatement psRegularisationReg = con.prepareStatement(reqRegularisationReg);
			
			String reqRegularisationAvoir = "select coalesce(sum(rac.Montant),0) as Regularisation";
			reqRegularisationAvoir += " from "+ base +".IMPUTATION_AVOIR_CLIENT iac join "+ base +".REGULARISATION_AVOIR_CLIENT rac on iac.Imputation_Id=rac.Imputation_Id";
			reqRegularisationAvoir += " where iac.Avoir_Id=?";
			PreparedStatement psRegularisationAvoir = con.prepareStatement(reqRegularisationAvoir);
			
			while (rset.next()) {
				int reglementId = rset.getInt("Reglement_Id");
				String type = rset.getString("Type");
				
				long curDateReglement = rset.getLong("Date_Reg");
				String curDenomination = rset.getString("Denomination");
				String curClientId = rset.getString("Client_Id");
				String curModeReglement = rset.getString("Mode_Reglement");
				String moisRegCourant = DateTime.formatTime(curDateReglement,"MMyy");
				
				double curMontant = rset.getDouble("Montant_Du");
				double curMontantRestant = rset.getDouble("Montant_Restant");
				

				if (!premier && sousTotaux) {
					if (tri.equals("Date") && (!moisRegCourant.equals(moisRegPrec))) {
						LigneReglements le = new LigneReglements();
						le.setType('T');
						le.setDateReglement(ancDateReglement);
						le.setMontant(montantTemp);
						le.setMontantRestant(montantRestantTemp);
						lignes.add(le);

						montantTemp = 0;
						montantRestantTemp = 0;
					}
					else if (tri.equals("Client") && (!ancClientId.equalsIgnoreCase(curClientId) || (curClientId.equalsIgnoreCase("") && !ancDenomination.equalsIgnoreCase(curDenomination) ))) {
						LigneReglements le = new LigneReglements();
						le.setType('T');
						le.setClientId(ancClientId);
						le.setDenomination(ancDenomination);
						le.setMontant(montantTemp);
						le.setMontantRestant(montantRestantTemp);
						lignes.add(le);

						montantTemp = 0;
						montantRestantTemp = 0;
					}
					else if (tri.equals("Mode") && (!ancModeReglement.equals(curModeReglement))) {
						LigneReglements le = new LigneReglements();
						le.setType('T');
						le.setModeReglement(ancModeReglement);
						le.setDenomination(ancDenomination);
						le.setMontant(montantTemp);
						le.setMontantRestant(montantRestantTemp);
						lignes.add(le);
						
						montantTemp = 0;
						montantRestantTemp = 0;
					}
				}
				else {
					premier=false;
				}
				moisRegPrec = moisRegCourant;
				ancDateReglement = curDateReglement;
				ancClientId=curClientId;
				ancDenomination=curDenomination;
				ancModeReglement=curModeReglement;

				montantTemp += curMontant;
				montantRestantTemp += curMontantRestant;
				
				LigneReglements le = new LigneReglements();
				le.setDateReglement(curDateReglement);
				le.setDenomination(curDenomination);
				le.setNumPiece(rset.getString("Num_Piece"));
				le.setMontant(curMontant);
				le.setMontantRestant(curMontantRestant);
				le.setClientId(curClientId);
				le.setModeReglement(curModeReglement);
				le.setType('L');
				lignes.add(le);
				
				
				if (detail) {
					double regularisation = 0;
					ResultSet rset2;
					if (type.equals("R")) {
						psDetailsReg.setInt(1, reglementId);
						rset2 = psDetailsReg.executeQuery();
					} else {
						psDetailsAvoir.setInt(1, reglementId);
						rset2 = psDetailsAvoir.executeQuery();
					}
					
					while (rset2.next()) {
						LigneReglements le2 = new LigneReglements();
						le2.setNumPiece(rset2.getString("Num_Piece"));
						le2.setDatePiece(rset2.getLong("Date_Echeance"));
						le2.setMontant(rset2.getDouble("Montant"));
						le2.setModeReglement(rset2.getString("Mode_Reglement"));
						le2.setType('D');
						lignes.add(le2);
					}
					rset2.close();
					
					if (type.equals("R")) {
						psRegularisationReg.setInt(1, reglementId);
						rset2 = psRegularisationReg.executeQuery();
					} else {
						psRegularisationAvoir.setInt(1, reglementId);
						rset2 = psRegularisationAvoir.executeQuery();
					}
					
					if (rset2.next()) {
						regularisation = rset2.getDouble("Regularisation");
					}
					rset2.close();
					if (regularisation != 0) {
						LigneReglements le2 = new LigneReglements();
						le2.setMontant(regularisation);
						le2.setType('R');
						lignes.add(le2);
					}
				}

				total += curMontant;
				totalRestant += curMontantRestant;
			}
			rset.close();
			psListeReglements.close();
			psDetailsReg.close();
			psDetailsAvoir.close();
			psRegularisationReg.close();
			psRegularisationAvoir.close();
			
			if (sousTotaux) {
				if (tri.equals("Date")) {
					LigneReglements le = new LigneReglements();
					le.setType('T');
					le.setDateReglement(ancDateReglement);
					le.setMontant(montantTemp);
					le.setMontantRestant(montantRestantTemp);
					lignes.add(le);
				}
				else if (tri.equals("Client")) {
					LigneReglements le = new LigneReglements();
					le.setType('T');
					le.setClientId(ancClientId);
					le.setDenomination(ancDenomination);
					le.setMontant(montantTemp);
					le.setMontantRestant(montantRestantTemp);
					lignes.add(le);
				}
				else if (tri.equals("Mode")) {
					LigneReglements le = new LigneReglements();
					le.setType('T');
					le.setModeReglement(ancModeReglement);
					le.setDenomination(ancDenomination);
					le.setMontant(montantTemp);
					le.setMontantRestant(montantRestantTemp);
					lignes.add(le);
				}
			}
			
			LigneReglements le = new LigneReglements();
			le.setType('G');
			le.setMontant(total);
			le.setMontantRestant(totalRestant);
			lignes.add(le);
			
			
			stt.close();

		}
		catch(Exception e) {
			e.printStackTrace();
		}			
	}
	
	
	public int getNbLignes() {
		return lignes.size();
	}


} // fin DataReglements
