/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Donnes pour l'edition de l'inventaire
 */

package org.opensi.facturation.actions.inventaire;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;

import org.experlog.openeas.api.Session;
import org.opensi.util.tools.DateTime;


public class DataInventaire {

	protected ArrayList<LigneInventaire> lignes = new ArrayList<LigneInventaire>(10);

	protected String raisonSociale;
	protected String adresse1;
	protected String adresse2;
	protected String adresse3;
	protected String codePostal;
	protected String ville;
	protected String dateCourante;
	
	protected String dossierId;
	protected int inventaireId;
	protected String typeInventaire;
	protected String criteres = "";
	
	protected String typeEdition = "V"; // 'V'-> inventaire vierge; 'E'-> edition des carts; 'R'-> inventaire rempli
	protected double totalValorisation = 0;
	
	public DataInventaire(Session s, int inventaireId, int marque, int famille1, int famille2, int famille3, String typeInventaire, String typeEdition) {	
		try {
			Connection con = s.getConnection(null);
			Statement stt = con.createStatement();
      			
			String base = s.getCookie().get("BaseDossier");
			this.dossierId = s.getCookie().get("Dossier_Id");			
			this.dateCourante = DateTime.formatTime(System.currentTimeMillis(), "dd/MM/yyyy");

			this.inventaireId = inventaireId;
			this.typeInventaire = typeInventaire;
			this.typeEdition = typeEdition;
			
			String reqLeDossier = "select * from "+ base +".SOCIETE";

			ResultSet rset = stt.executeQuery(reqLeDossier);
			rset.next();
			this.raisonSociale = rset.getString("Denomination");
			this.adresse1 = rset.getString("Adresse_1");
			this.adresse2 = rset.getString("Adresse_2");
			this.adresse3 = rset.getString("Adresse_3");
			this.codePostal = rset.getString("Code_Postal");
			this.ville = rset.getString("Ville");
			rset.close();

			
			String reqArticles = " select ai.Article_Id, fa.Designation, fa.Unite, ai.Qte_Theorique as Stock_Info, ai.Qte_Inventaire as Stock_Physique, ai.Valorisation";
			reqArticles += " from "+ base +".FICHE_ARTICLE fa,"+ base +".ARTICLE_INVENTAIRE ai";
			reqArticles += " where ai.Article_Id=fa.Article_Id and Inventaire_Id="+ inventaireId;
			if (typeEdition.equals("E")) {
				reqArticles += " and ai.Qte_Theorique<>ai.Qte_Inventaire";
			}
			if (typeInventaire.equalsIgnoreCase("C")) {
				
				String reqLibelleMarque = "select Libelle from "+ base +".MARQUE_ARTICLE where Marque_Id=?";
				PreparedStatement psLibelleMarque = con.prepareStatement(reqLibelleMarque);
				
				if (marque != 0) {
					reqArticles += " and fa.Marque_Id="+ marque;
					psLibelleMarque.setInt(1, marque);
					rset = psLibelleMarque.executeQuery();
					rset.next();
					criteres += "Marque : "+ rset.getString("Libelle");
					rset.close();
				}
				psLibelleMarque.close();
				
				String reqLibelleFamille = "select Libelle from "+ base +".FAMILLE_ARTICLE where Famille_Id=?";
				PreparedStatement psLibelleFamille = con.prepareStatement(reqLibelleFamille);
				
				if (famille1 != 0) {
					reqArticles += " and fa.Famille_1="+ famille1;
					if (criteres.length()>0) {
						criteres += " - ";
					}
					psLibelleFamille.setInt(1, famille1);
					rset = psLibelleFamille.executeQuery();
					rset.next();
					criteres += "Famille 1 : "+ rset.getString("Libelle");
					rset.close();
					if (famille2 != 0) {
						reqArticles += " and fa.Famille_2="+ famille2;
						if (criteres.length()>0) {
							criteres += " - ";
						}
						psLibelleFamille.setInt(1, famille2);
						rset = psLibelleFamille.executeQuery();
						rset.next();
						criteres += "Famille 2 : "+ rset.getString("Libelle");
						rset.close();
						if (famille3 != 0) {
							reqArticles += " and fa.Famille_3="+ famille3;
							if (criteres.length()>0) {
								criteres += " - ";
							}
							psLibelleFamille.setInt(1, famille3);
							rset = psLibelleFamille.executeQuery();
							rset.next();
							criteres += "Famille 3 : "+ rset.getString("Libelle");
							rset.close();
						}
					}
				}
				psLibelleFamille.close();
			}
			reqArticles += " order by ai.Article_Id";
			
			rset = stt.executeQuery(reqArticles);
			while (rset.next()) {
				LigneInventaire li = new LigneInventaire();

				li.setRefArticle(rset.getString("Article_Id"));
				li.setDesignation(rset.getString("Designation"));
				li.setUnite(rset.getString("Unite"));
				li.setStockInfo(rset.getDouble("Stock_Info"));
				li.setStockPhysique(rset.getDouble("Stock_Physique"));
				li.setValorisation(rset.getDouble("Valorisation")*rset.getDouble("Stock_Physique"));
				totalValorisation += li.valorisation;

				lignes.add(li);
			}

			stt.close();
			s.closeConnection(con, null);
			
		} catch(Exception e) { e.printStackTrace();	}
	
	}
	
	
	public int getNbLignes() {
		return lignes.size();
	}


} // fin DataInventaire
