/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Donnes ncessaires  l'exportation
 */

package org.opensi.facturation.actions.idep;

import org.opensi.util.tools.Arrondi;


public class LigneExportIdep {
	
	protected String provenanceDestination;
	protected int valeur;
	protected String referenceProduit;
	protected String codeNGP9;
	protected String libelleProduit;
	protected int masseNette;
	protected int valeurStatistique;
	protected int unitesSupplementaires;
	protected String paysOrigine;
	protected String numTVAPartenaire;
	protected String refFacture;
	protected String codeDevise;
	protected int valeurDevise;
	protected int valeurStatDevise;
	
	protected Arrondi arr = new Arrondi(0);
	
	public void setProvenanceDestination(String provenanceDestination) {
		this.provenanceDestination = provenanceDestination;
	}	
	public void setValeur(double valeur) {
		this.valeur = (int)this.arr.round(valeur);
	}
	public void setReferenceProduit(String referenceProduit) {
		this.referenceProduit = referenceProduit;
	}
	public void setCodeNGP9(String codeNGP9) {
		this.codeNGP9 = codeNGP9;
	}
	public void setLibelleProduit(String libelleProduit) {
		this.libelleProduit = libelleProduit;
	}
	public void setMasseNette(double masseNette) {
		this.masseNette = (int)this.arr.round(masseNette);
	}
	public void setValeurStatistique(double valeurStatistique) {
		this.valeurStatistique = (int)this.arr.round(valeurStatistique);
	}
	public void setUnitesSupplementaires(int unitesSupplementaires) {
		this.unitesSupplementaires = unitesSupplementaires;
	}
	public void setPaysOrigine(String paysOrigine) {
		this.paysOrigine = paysOrigine;
	}
	public void setNumTVAPartenaire(String numTVAPartenaire) {
		this.numTVAPartenaire = numTVAPartenaire;
	}
	public void setRefFacture(String refFacture) {
		this.refFacture = refFacture;
	}
	public void setCodeDevise(String codeDevise) {
		this.codeDevise = codeDevise;
	}
	public void setValeurDevise(double valeurDevise) {
		this.valeurDevise = (int)this.arr.round(valeurDevise);
	}
	public void setValeurStatDevise(double valeurStatDevise) {
		this.valeurStatDevise = (int)this.arr.round(valeurStatDevise);
	}

} // fin LigneExportIdep