/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Gnration d'un historique d'articles nomenclaturs fabriqus
 */

package org.opensi.facturation.actions.fabrication;

import org.opensi.util.listing.ListingFile;
import org.opensi.util.listing.ListingTabFile;
import org.opensi.util.tools.DateTime;

public class CsvHistoriqueFabrication {
	
	public CsvHistoriqueFabrication(String buffer, String fichier, DataHistoriqueFabrication dhf) throws Exception {
		
		ListingFile lf = new ListingTabFile();

		lf.newLine();
		lf.addToLine("Date Fabrication");
		lf.addToLine("R\u00E9f. Article");
		lf.addToLine("D\u00E9signation");
		lf.addToLine("Quantit\u00E9");
		lf.addToLine("Type");
		
		int nbLignes = dhf.getNbLignes();
		for (int i=0; i<nbLignes; i++) {
			LigneHistoriqueFabrication lhf = dhf.lignes.get(i);
			lf.newLine();
			lf.addToLine(DateTime.formatTime(lhf.dateFabrication, "dd/MM/yyyy"));
			lf.addToLine(lhf.refArticle);
			lf.addToLine(lhf.designation);
			lf.addToLine(("" + lhf.quantite).replaceAll("\\.", ","));
			lf.addToLine(lhf.type);
		}
		
		lf.write(buffer, fichier, true);
	}



} // fin CsvHistoriqueFabrication
