/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Modle d'tiquette standard 120 x 80
 */

package org.opensi.facturation.actions.editions.etiquettes;

import com.lowagie.text.DocumentException;
import com.lowagie.text.Font;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;



public class ModeleStd120X80 implements Etiquette {


private static final Font font9N = new Font(Font.HELVETICA, 9, Font.NORMAL);
private static final Font font10G = new Font(Font.HELVETICA, 10, Font.BOLD);


	public int getDimX() {	return 120;	}
	
	public int getDimY() {	return 80; }

	
	public PdfPTable makeEtiquette(String absdir, InfosEtiquette ie) throws DocumentException {
		
		CoordExp exp = ie.getExpediteur();
		CoordExp dest = ie.getDestinataire();
		
		
		PdfPTable ppt = new PdfPTable(3);
		ppt.setWidthPercentage(100);
		int widths[] = {24, 1, 75};
		ppt.setWidths(widths);
		
		PdfPCell cell = new PdfPCell(ppt.getDefaultCell());
		
		cell.setVerticalAlignment(PdfPCell.ALIGN_TOP);
		cell.setBorder(PdfPCell.NO_BORDER);
		cell.setPaddingLeft(0);
		cell.setLeading(13,0);
		
		cell.setPhrase(new Phrase("EXPEDITEUR", font9N));
		ppt.addCell(cell);
		cell.setPhrase(new Phrase("", font9N));
		ppt.addCell(cell);
		
		String expediteur = exp.nom +"\n"+ exp.adresse +"\n"+ exp.compAdresse +"\n"+ exp.cp +" "+ exp.ville;
		
		cell.setPhrase(new Phrase(expediteur, font10G));
		ppt.addCell(cell);
		
		ppt.addCell(cellSpace(3, 8));
		
		cell.setPhrase(new Phrase("DESTINATAIRE", font9N));
		ppt.addCell(cell);
		cell.setPhrase(new Phrase("", font9N));
		ppt.addCell(cell);
		
		String destinataire = dest.nom +"\n"+ dest.adresse +"\n"+ dest.compAdresse +"\n"+ dest.cp +" "+ dest.ville;
		
		cell.setPhrase(new Phrase(destinataire, font10G));
		ppt.addCell(cell);
		
		cell.setLeading(0,(float)1.4);
		ppt.addCell(cellSpace(3, 8));
		
		cell.setBorder(PdfPCell.BOTTOM);
		cell.setColspan(3);
		cell.setPhrase(new Phrase(""));
		ppt.addCell(cell);
		cell.setColspan(1);	
		cell.setBorder(PdfPCell.NO_BORDER);
		
		ppt.addCell(cellSpace(3, 4));
		
		cell.setPaddingLeft(0);
		cell.setPhrase(new Phrase("REF.CDE", font9N));
		ppt.addCell(cell);
		cell.setPhrase(new Phrase(":", font9N));
		ppt.addCell(cell);
		cell.setPaddingLeft(20);
		cell.setPhrase(new Phrase(ie.refCom, font9N));
		ppt.addCell(cell);
		
		cell.setPaddingLeft(0);
		cell.setPhrase(new Phrase("N\u00B0 AFFAIRE", font9N));
		ppt.addCell(cell);
		cell.setPhrase(new Phrase(":", font9N));
		ppt.addCell(cell);
		cell.setPaddingLeft(20);
		cell.setPhrase(new Phrase(ie.numAffaire, font9N));
		ppt.addCell(cell);
		
		cell.setPaddingLeft(0);
		cell.setPhrase(new Phrase("N\u00B0 BL", font9N));
		ppt.addCell(cell);
		cell.setPhrase(new Phrase(":", font9N));
		ppt.addCell(cell);
		cell.setPaddingLeft(20);
		cell.setPhrase(new Phrase(ie.numBL, font9N));
		ppt.addCell(cell);
		
		cell.setPaddingLeft(0);
		cell.setPhrase(new Phrase("COLIS", font9N));
		ppt.addCell(cell);
		cell.setPhrase(new Phrase(":", font9N));
		ppt.addCell(cell);
		cell.setPaddingLeft(20);
		cell.setPhrase(new Phrase(ie.numColis +"/"+ ie.nbColis, font9N));
		ppt.addCell(cell);
		
		
		return ppt;
	}

	private PdfPCell cellSpace(int colspan, int space) {
		
		PdfPTable sectionSpace = new PdfPTable(1);

		PdfPCell cell = new PdfPCell(sectionSpace.getDefaultCell());

		cell.setPhrase(new Phrase(""));
		cell.setFixedHeight(space);
		cell.setBorder(PdfPCell.NO_BORDER);
		cell.setColspan(colspan);
		
		return cell;
	}
	
	
	public float toPoints(double dim) {
	
		return (float) ((dim/10) / 2.54 * 72);
	}


} // fin ModeleStd120X80
