/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Donnes ncessaires  l'dition d'un tableau de statistiques
 */

package org.opensi.facturation.actions.editions;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;

import org.experlog.openeas.api.Session;

public class DataStatistiquesMA {

	// les lignes de la liste des statistiques
	protected ArrayList<LigneStatistiqueMA> lignes = new ArrayList<LigneStatistiqueMA>(10);
	protected ArrayList<LigneStatistiqueMA> totaux1 = new ArrayList<LigneStatistiqueMA>(10);
	protected ArrayList<LigneStatistiqueMA> totaux2 = new ArrayList<LigneStatistiqueMA>(10);
	protected long debutPeriode;
	protected long finPeriode;
	protected long debutNmoins1;
	protected long finNmoins1;
	
	public DataStatistiquesMA(Session s, long debutPeriode, long finPeriode, long debutNmoins1, long finNmoins1) {
		
		try {
			
			Connection con = s.getConnection(null);
			Statement stt = con.createStatement();
			Statement stt2 = con.createStatement();
			String base = s.getCookie().get("BaseDossier");
			double totMargeV = 0;
			double totCA = 0;
			this.debutPeriode=debutPeriode;
			this.finPeriode=finPeriode;
			this.debutNmoins1=debutNmoins1;
			this.finNmoins1=finNmoins1;
			
			
			String reqArticleCA = " select TG.Article_Id, TG.Designation, TG.Fournisseur_Id,TG.Prix_Achat, sum(TG.Quantite) as Qte, sum(TG.CA_HT) as CA_HT from"
				+" ((select fa.Article_Id, fa.Designation, coalesce(sum(af.Quantite),0) as Quantite,foa.Fournisseur_Id,foa.Prix_Achat,  coalesce(if(f.Edition_TTC=0, sum(af.Montant_Ligne * (1-f.Remise/100)), sum(af.Montant_Ligne * (1-f.Remise/100) / (1+af.Taux_TVA/100))),0) as CA_HT"
				+" from "+ base +".FACTURE f join "+ base +".LIGNE_FACTURE af on f.Facture_Id=af.Facture_Id join "+ base +".FOURNISSEUR_ARTICLE foa on foa.Article_Id=af.Reference, "+ base +".FICHE_ARTICLE fa "
				+" where f.Numero<>0 and f.Date_Facture<="+ finPeriode +" and f.Date_Facture>="+ debutPeriode +" and fa.Article_Id=af.Reference and foa.Principal=1 group by fa.Article_Id, fa.Designation)"
				+" union "
				+" (select fa.Article_Id, fa.Designation,foa.Fournisseur_Id,foa.Prix_Achat, -coalesce(sum(aa.Quantite),0) as Quantite, -coalesce(if(a.Edition_TTC=0, sum(aa.Montant_Ligne * (1-a.Remise/100)), sum(aa.Montant_Ligne * (1-a.Remise/100) / (1+aa.Taux_TVA/100))), 0) as CA_HT"
				+" from "+ base +".AVOIR a join "+ base +".LIGNE_AVOIR aa on a.Avoir_Id=aa.Avoir_Id join "+ base +".FOURNISSEUR_ARTICLE foa on foa.Article_Id=aa.Reference, "+ base +".FICHE_ARTICLE fa"
				+" where a.Numero<>0 and a.Date_Avoir<="+ finPeriode +" and a.Date_Avoir>="+ debutPeriode +" and fa.Article_Id=aa.Reference and foa.Principal=1  group by fa.Article_Id, fa.Designation)) as TG"
				+" group by TG.Article_Id, TG.Designation order by TG.CA_HT desc";
			
		
			ResultSet rset = stt.executeQuery(reqArticleCA);
			while (rset.next()) {
				double marge=0;
				double margeP=0;
				double prixVente=0;
				LigneStatistiqueMA lsma = new LigneStatistiqueMA();
				lsma.setArticle_Id(rset.getString("TG.Article_Id"));
				lsma.setFournisseur(rset.getString("TG.Fournisseur_Id"));
				lsma.setPrix_achat(rset.getDouble("TG.Prix_Achat"));
				lsma.setQte(rset.getDouble("Qte"));
				prixVente=rset.getDouble("CA_HT")/rset.getDouble("Qte");
				lsma.setPrix_vente(prixVente);
				lsma.setCA_HT(rset.getDouble("CA_HT"));
				//if (rset.getDouble("CA_HT")/rset.getDouble("Qte")>0){
				marge=(prixVente -rset.getDouble("TG.Prix_Achat"))*rset.getDouble("Qte");
				if (marge>0){
					margeP=((prixVente -rset.getDouble("TG.Prix_Achat"))/prixVente)*100;
				}				
				else{				
				margeP=0;
				}
				lsma.setMargeValeur(marge);
				lsma.setMargePourcent(margeP);
				if (rset.getDouble("Qte")!=0 && (rset.getDouble("CA_HT")!=0)){
				lignes.add(lsma);
				totCA+=rset.getDouble("CA_HT");
				totMargeV+= marge;
				}
				
			}
			//ligne des totaux
			LigneStatistiqueMA lt = new LigneStatistiqueMA();
			lt.setTotCA(totCA);
			lt.setTotMargeV(totMargeV);
			lt.setTotMargeP(totCA==0?0:totMargeV*100/totCA);
			totaux1.add(lt);
			rset.close();
			
			
			
			double marge2=0;
			double totMargeV2 = 0;
			double totCA2 = 0;
			
			String reqArticleCA2 = " select TG.Article_Id, TG.Designation, TG.Fournisseur_Id,TG.Prix_Achat, sum(TG.Quantite) as Qte, sum(TG.CA_HT) as CA_HT from"
				+" ((select fa.Article_Id, fa.Designation, coalesce(sum(af.Quantite),0) as Quantite,foa.Fournisseur_Id,foa.Prix_Achat,  coalesce(if(f.Edition_TTC=0, sum(af.Montant_Ligne * (1-f.Remise/100)), sum(af.Montant_Ligne * (1-f.Remise/100) / (1+af.Taux_TVA/100))),0) as CA_HT"
				+" from "+ base +".FACTURE f join "+ base +".LIGNE_FACTURE af on f.Facture_Id=af.Facture_Id join "+ base +".FOURNISSEUR_ARTICLE foa on foa.Article_Id=af.Reference, "+ base +".FICHE_ARTICLE fa "
				+" where f.Numero<>0 and f.Date_Facture<="+ finNmoins1 +" and f.Date_Facture>="+ debutNmoins1 +" and fa.Article_Id=af.Reference and foa.Principal=1 group by fa.Article_Id, fa.Designation)"
				+" union "
				+" (select fa.Article_Id, fa.Designation,foa.Fournisseur_Id,foa.Prix_Achat, -coalesce(sum(aa.Quantite),0) as Quantite, -coalesce(if(a.Edition_TTC=0, sum(aa.Montant_Ligne * (1-a.Remise/100)), sum(aa.Montant_Ligne * (1-a.Remise/100) / (1+aa.Taux_TVA/100))), 0) as CA_HT"
				+" from "+ base +".AVOIR a join "+ base +".LIGNE_AVOIR aa on a.Avoir_Id=aa.Avoir_Id join "+ base +".FOURNISSEUR_ARTICLE foa on foa.Article_Id=aa.Reference, "+ base +".FICHE_ARTICLE fa"
				+" where a.Numero<>0 and a.Date_Avoir<="+ finNmoins1 +" and a.Date_Avoir>="+ debutNmoins1 +" and fa.Article_Id=aa.Reference and foa.Principal=1  group by fa.Article_Id, fa.Designation)) as TG"
				+" group by TG.Article_Id, TG.Designation order by TG.CA_HT desc";
			
			
			ResultSet rset2 = stt2.executeQuery(reqArticleCA2);
			while (rset2.next()) {
				
					marge2=rset2.getDouble("CA_HT")-(rset2.getDouble("TG.Prix_Achat")*rset2.getDouble("Qte"));
					
				
				if (rset2.getDouble("Qte")!=0 && (rset2.getDouble("CA_HT")!=0)){
					totCA2+=rset2.getDouble("CA_HT");
					totMargeV2+= marge2;
				}
					
			}
//			ligne des totaux de l'anne prcedente
			LigneStatistiqueMA lt2 = new LigneStatistiqueMA();
			lt2.setTotCA(totCA2);
			lt2.setTotMargeV(totMargeV2);
			lt2.setTotMargeP(totCA2==0?0:totMargeV2*100/totCA2);
			totaux2.add(lt2);
			rset2.close();
		}
		
		catch(Exception e) {
			e.printStackTrace();
		}		
	}
	
	
	
	public int getNbLignes() {
		return lignes.size();
	}
	public int getNbLignesTot1() {
		return totaux1.size();
	}
	public int getNbLignesTot2() {
		return totaux2.size();
	}
	


} // fin DataStatistiquesMA
