/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Donnes ncessaires  l'dition d'un listing article
 */

package org.opensi.facturation.actions.editions;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;

import org.experlog.openeas.api.Session;


public class DataListeArticle {

	
	// les lignes du listing article
	protected ArrayList<LigneArticle> lignes = new ArrayList<LigneArticle>(100);
	
	protected String labelTarif1 = "Tarif 1";
	protected String labelTarif2 = "Tarif 2";
	protected String labelTarif3 = "Tarif 3";
	protected String labelTarif4 = "Tarif 4";
	protected String labelTarif5 = "Tarif 5";

	public DataListeArticle(Session s, int famille1, int famille2, int famille3, int marque) {
		try {
			
			Connection con = s.getConnection(null);
			Statement stt = con.createStatement();
			
			String base = s.getCookie().get("BaseDossier");
			
			String reqParam = "select Label_Tarif_1, Label_Tarif_2, Label_Tarif_3, Label_Tarif_4, Label_Tarif_5 from "+ base +".PARAM_DOSSIER";
			ResultSet rset = stt.executeQuery(reqParam);
			if (rset.next()) {
				this.labelTarif1 = rset.getString("Label_Tarif_1");
				this.labelTarif2 = rset.getString("Label_Tarif_2");
				this.labelTarif3 = rset.getString("Label_Tarif_3");
				this.labelTarif4 = rset.getString("Label_Tarif_4");
				this.labelTarif5 = rset.getString("Label_Tarif_5");
			}
			rset.close();
			
			String reqArticles = "select f.Article_Id, f.Designation, coalesce(ma.Libelle,'') as Marque, fa1.Libelle as Famille1, coalesce(fa2.Libelle,'') as Famille2, coalesce(fa3.Libelle,'') as Famille3,";
			reqArticles += " f.Tarif_1, f.Tarif_2, f.Tarif_3, f.Tarif_4, f.Tarif_5, f.Tarif_1_TTC, f.Tarif_2_TTC, f.Tarif_3_TTC, f.Tarif_4_TTC, f.Tarif_5_TTC,";
			reqArticles += " coalesce(fa.Fournisseur_Id,'') as Ref_Fournisseur, coalesce(fa.Prix_Achat,0) as Prix_Achat";
			reqArticles += " from "+ base +".FICHE_ARTICLE f join "+ base +".FAMILLE_ARTICLE fa1 on f.Famille_1=fa1.Famille_Id";
			reqArticles += " left join "+ base +".FAMILLE_ARTICLE fa2 on f.Famille_2=fa2.Famille_Id";
			reqArticles += " left join "+ base +".FAMILLE_ARTICLE fa3 on f.Famille_3=fa3.Famille_Id";
			reqArticles += " left join "+ base +".MARQUE_ARTICLE ma on f.Marque_Id=ma.Marque_Id";
			reqArticles += " left join "+ base +".FOURNISSEUR_ARTICLE fa on f.Article_Id=fa.Article_Id and fa.Principal=1 where f.Supprime=0";

			if (famille1 != 0) {
				reqArticles += " and f.Famille_1="+ famille1;
				if (famille2 != 0) {
					reqArticles += "and f.Famille_2="+ famille2;
					if (famille3 != 0) {
						reqArticles += "and f.Famille_3="+ famille3;
					}
				}
			}

			if (marque != 0) {
				reqArticles += " and f.Marque_Id="+ marque;
			}
			
			rset = stt.executeQuery(reqArticles);			
			while (rset.next()) {				
				LigneArticle la = new LigneArticle();

				la.setRefArticle(rset.getString("Article_Id"));
				la.setDesignation(rset.getString("Designation"));
				la.setMarque(rset.getString("Marque"));
				la.setFamille1(rset.getString("Famille1"));
				la.setFamille2(rset.getString("Famille2"));
				la.setFamille3(rset.getString("Famille3"));
				la.setTarif1HT(rset.getDouble("Tarif_1"));
				la.setTarif2HT(rset.getDouble("Tarif_2"));
				la.setTarif3HT(rset.getDouble("Tarif_3"));
				la.setTarif4HT(rset.getDouble("Tarif_4"));
				la.setTarif5HT(rset.getDouble("Tarif_5"));
				la.setTarif1TTC(rset.getDouble("Tarif_1_TTC"));
				la.setTarif2TTC(rset.getDouble("Tarif_2_TTC"));
				la.setTarif3TTC(rset.getDouble("Tarif_3_TTC"));
				la.setTarif4TTC(rset.getDouble("Tarif_4_TTC"));
				la.setTarif5TTC(rset.getDouble("Tarif_5_TTC"));
				la.setRefFournisseur(rset.getString("Ref_Fournisseur"));
				la.setPrixAchat(rset.getDouble("Prix_Achat"));
				
				lignes.add(la);
			}
			rset.close();
			stt.close();
			s.closeConnection(con, null);
			
		} catch(Exception e) {
			e.printStackTrace();
		}			
	}
	
	
	public int getNbLignes() {
		return lignes.size();
	}



} // fin DataListeArticle
