/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Donnes ncessaires  l'dition d'un proforma standard
 */

package org.opensi.facturation.actions.documents.modeles;


import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;

import org.experlog.openeas.api.Session;
import org.opensi.facturation.DocumentUtils;
import org.opensi.util.tools.DateTime;

public class DataSuiviLot {	


	// coordonnes socit mettrice

	protected String raisonSociale;
	protected String adresse1;
	protected String adresse2;
	protected String adresse3;
	protected String codePostal;
	protected String ville;
	protected String tel;
	protected String fax;
	protected String email;
	protected String web;
	
	protected double capital;
	protected String typeSociete;
	protected String tvaIntra;
	protected String rcs;
	protected String siren;
	protected boolean logoAdr;
	protected String urlLogo = "";
	
	protected String numLot;
	protected String refArticle = "";
	protected String designationArticle = "";
	protected boolean nbPieces = false;
	
	protected ArrayList<LigneSuiviLot> lignes = new ArrayList<LigneSuiviLot>(10);
	
	
	public DataSuiviLot(Session s, String numLot) {	
		try {
		
			Connection con = s.getConnection(null);
			Statement stt = con.createStatement();
			
			String dossierId = s.getCookie().get("Dossier_Id");
			String base = s.getCookie().get("BaseDossier");
			this.urlLogo = s.getAppConfiguration().get("opensi.absdir") +"/logos/"+ dossierId +".jpg";
			this.numLot = numLot;
			
			
			// Paramtres dossier
		      
			String reqCom = "select Logo_Adr from "+ base +".PARAM_DOSSIER";
			ResultSet rset = stt.executeQuery(reqCom);			
			rset.next();
			
			logoAdr = rset.getInt("Logo_Adr")==1;			
			
			rset.close();			
      
			// coordonnes de l'entreprise facturante
      
			String reqFacturante = "select s.Ville_RCS, s.Num_TVA_Intra, ts.Libelle as Type_Societe, s.Montant_Capital, s.Num_SIRET, s.Denomination, s.Adresse_1, s.Adresse_2, s.Adresse_3, s.Code_Postal, s.Ville, s.Telephone, s.Fax, s.Email, s.Site_Web";
			reqFacturante += " from "+ base +".SOCIETE s join "+ base +".TYPE_SOCIETE ts on s.Type_Societe=ts.Type_Societe_Id";
			rset = stt.executeQuery(reqFacturante);			
			rset.next();			
			this.raisonSociale = rset.getString("Denomination");
			this.adresse1 = rset.getString("Adresse_1");
			this.adresse2 = rset.getString("Adresse_2");
			this.adresse3 = rset.getString("Adresse_3");
			this.codePostal = rset.getString("Code_Postal");
			this.ville = rset.getString("Ville");
			this.tel = rset.getString("Telephone");
			this.fax = rset.getString("Fax");
			this.email = rset.getString("Email");
			this.web = rset.getString("Site_Web");			
			this.siren = DocumentUtils.formatSiren(rset.getString("Num_SIRET"));
			this.typeSociete = rset.getString("Type_Societe");
			this.capital = rset.getDouble("Montant_Capital");
			this.tvaIntra = rset.getString("Num_TVA_Intra");
			this.rcs = rset.getString("Ville_RCS");			
			rset.close();
			
			// Recherche rf article et dsignation pour le num lot
			
			String reqRef = "select Reference, Designation from";
			reqRef += " (select ac.Reference, ac.Designation";
			reqRef += " from "+ base +".BON_LIVRAISON bl, "+ base +".LIGNE_BON_LIVRAISON abl, "+ base +".LIGNE_COMMANDE_CLIENT ac";
			reqRef += " where bl.Etat='V' and ac.Statut='V' and bl.Bon_Id=abl.Bon_Id and abl.Num_Lot='"+ this.numLot +"' and abl.Ref_Ligne=ac.Ligne_Id and abl.Statut='V'";
			reqRef += " union";
			reqRef += " select af.Reference, af.Designation";
			reqRef += " from "+ base +".FACTURE f, "+ base +".LIGNE_FACTURE af";
			reqRef += " where f.Facture_Id=af.Facture_Id and af.Num_Lot='"+ this.numLot +"' and f.Directe=1 and f.Numero>0";
			reqRef += " union";
			reqRef += " select ac.Reference, ac.Designation";
			reqRef += " from "+ base +".BON_RECEPTION br, "+ base +".LIGNE_BON_RECEPTION abr, "+ base +".LIGNE_COMMANDE_FOURNISSEUR ac";
			reqRef += " where br.Etat='V' and br.BR_Id=abr.BR_Id and abr.Num_Lot='"+ this.numLot +"' and abr.Ref_Ligne=ac.Ligne_Id) t limit 1";
			rset = stt.executeQuery(reqRef);
			if (rset.next()) {
				this.refArticle = rset.getString("Reference");
				this.designationArticle = rset.getString("Designation");
			}
			
			// Infos des BL
			String reqBL = "select Nom_Liv, Adresse_1_Liv, Adresse_2_Liv, Adresse_3_Liv, Code_Postal_Liv, Ville_Liv, Code_Pays_Liv, sum(Quantite) as Qte_Livree, sum(Nb_Pieces) as Nb_Pieces, Civ_Courte, Nom_Inter_Liv, Prenom_Inter_Liv, Tel_Inter_Liv, Date_Liv as Date_Livraison from";
			reqBL += " (select bl.Nom_Liv, bl.Adresse_1_Liv, bl.Adresse_2_Liv, bl.Adresse_3_Liv, bl.Code_Postal_Liv, bl.Ville_Liv, bl.Code_Pays_Liv, abl.Quantite, abl.Nb_Pieces, c.Civ_Courte, bl.Nom_Inter_Liv, bl.Prenom_Inter_Liv, bl.Tel_Inter_Liv, bl.Date_Liv";
			reqBL += " from "+ base +".BON_LIVRAISON bl, "+ base +".LIGNE_BON_LIVRAISON abl, CIVILITE c";
			reqBL += " where bl.Etat='V' and abl.Statut='V' and bl.Bon_Id=abl.Bon_Id and bl.Civ_Inter_Liv=c.Civ_Id and abl.Num_Lot='"+ numLot +"'";
			reqBL += " union all";
			reqBL += " select f.Denomination_Liv as Nom_Liv, f.Adresse_1_Liv, f.Adresse_2_Liv, f.Adresse_3_Liv, f.Code_Postal_Liv, f.Ville_Liv, f.Code_Pays_Liv, af.Quantite, af.Nb_Pieces, c.Civ_Courte, f.Nom_Inter_Liv, f.Prenom_Inter_Liv, f.Tel_Inter_Liv, f.Date_Facture as Date_Liv";
			reqBL += " from "+ base +".FACTURE f, "+ base +".LIGNE_FACTURE af, CIVILITE c";
			reqBL += " where f.Facture_Id=af.Facture_Id and f.Civ_Inter_Liv=c.Civ_Id and af.Num_Lot='"+ numLot +"' and f.Directe=1 and f.Numero>0) t";
			reqBL += " group by Nom_Liv, Adresse_1_Liv, Adresse_2_Liv, Adresse_3_Liv, Code_Postal_Liv, Ville_Liv, Code_Pays_Liv, Civ_Courte, Nom_Inter_Liv, Prenom_Inter_Liv, Tel_Inter_Liv, Date_Livraison";
			rset = stt.executeQuery(reqBL);
			
			while (rset.next()) {
				LigneSuiviLot ls = new LigneSuiviLot();
				
				String dateLivraison = DateTime.formatTime(rset.getLong("Date_Livraison"),"dd/MM/yyyy");
				
				ls.setType("BL");
				ls.setDenomination(rset.getString("Nom_Liv"));
				ls.setAdresse1(rset.getString("Adresse_1_Liv"));
				ls.setAdresse2(rset.getString("Adresse_2_Liv"));
				ls.setAdresse3(rset.getString("Adresse_3_Liv"));
				ls.setCodePostal(rset.getString("Code_Postal_Liv"));
				ls.setVille(rset.getString("Ville_Liv"));
				ls.setCodePays(rset.getString("Code_Pays_Liv"));
				ls.setInterlocuteur(rset.getString("Civ_Courte") + " " + rset.getString("Nom_Inter_Liv").toUpperCase() + " " + rset.getString("Prenom_Inter_Liv"));
				ls.setTelInter(rset.getString("Tel_Inter_Liv"));
				ls.setDate(dateLivraison);
				ls.setQte(rset.getDouble("Qte_Livree"));
				ls.setNbPieces(rset.getInt("Nb_Pieces"));
				
				if (ls.nbPieces != 0) { this.nbPieces = true; }
				
				this.lignes.add(ls);
			}
			rset.close();
			
			// Infos des BR			
			String reqBR = "select c.Denomination, c.Adresse_1, c.Adresse_2, c.Adresse_3, c.Code_Postal, c.Ville, c.Code_Pays, br.Date_BR as Date_Reception, sum(abr.Quantite) as Qte_Recep, sum(abr.Nb_Pieces) as Nb_Pieces";
			reqBR += " from "+ base +".BON_RECEPTION br, "+ base +".LIGNE_BON_RECEPTION abr, "+ base +".COMMANDE_FOURNISSEUR c";
			reqBR += " where c.Commande_Id=br.Commande_Id and br.Etat='V' and br.BR_Id=abr.BR_Id and abr.Num_Lot='"+ numLot +"'";
			reqBR += " group by c.Denomination, c.Adresse_1, c.Adresse_2, c.Adresse_3, c.Code_Postal, c.Ville, c.Code_Pays, Date_Reception";
			rset = stt.executeQuery(reqBR);
			while (rset.next()) {
				LigneSuiviLot ls = new LigneSuiviLot();
				
				String dateReception = DateTime.formatTime(rset.getLong("Date_Reception"),"dd/MM/yyyy");
				
				ls.setType("BR");
				ls.setDenomination(rset.getString("Denomination"));
				ls.setAdresse1(rset.getString("Adresse_1"));
				ls.setAdresse2(rset.getString("Adresse_2"));
				ls.setAdresse3(rset.getString("Adresse_3"));
				ls.setCodePostal(rset.getString("Code_Postal"));
				ls.setVille(rset.getString("Ville"));
				ls.setCodePays(rset.getString("Code_Pays"));
				ls.setDate(dateReception);
				ls.setQte(rset.getDouble("Qte_Recep"));
				ls.setNbPieces(rset.getInt("Nb_Pieces"));
				
				if (ls.nbPieces != 0) { this.nbPieces = true; }
				
				this.lignes.add(ls);
			}
			rset.close();
			
			stt.close();			
			s.closeConnection(con, null);
			
		} catch(Exception e) {
			e.printStackTrace();
		}	
	}
	
	public int getNbLignes() {
		return lignes.size();
	}
	
	
} // fin DataSuiviLot
