/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Gnration d'un acompte client au format standard
 */

package org.opensi.facturation.actions.documents.modeles;


import java.awt.Color;
import java.sql.Date;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;

import org.opensi.util.pdf.PdfWidths;
import org.opensi.util.pdf.TableBuilder;

import com.lowagie.text.DocumentException;
import com.lowagie.text.Font;
import com.lowagie.text.Image;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;


public class AcompteClientStd extends AcompteClientPDF {


	private static final Font fontAdrGras = new Font(Font.HELVETICA, 11, Font.BOLD);
	private static final Font fontAdrSociete = new Font(Font.HELVETICA, 10, Font.NORMAL);
	private static final Font fontAdrSocieteGras = new Font(Font.HELVETICA, 11, Font.BOLD);
	private static final Font fontAdresse = new Font(Font.HELVETICA, 8, Font.NORMAL);
	private static final Font fontTitre = new Font(Font.HELVETICA , 16, Font.BOLD, Color.WHITE);
	private static final Font fontWeb = new Font(Font.HELVETICA, 10, Font.ITALIC);
	private static final Font fontEnteteColonne = new Font(Font.HELVETICA, 8, Font.BOLD);
	private static final Font fontInfosFact = new Font(Font.HELVETICA , 10, Font.NORMAL);
	private static final Font fontLegale = new Font(Font.HELVETICA , 8, Font.NORMAL);
	private static final Font fontLine = new Font(Font.HELVETICA , 8, Font.NORMAL);
	private static final Font fontLineLibelle = new Font(Font.HELVETICA , 10, Font.NORMAL);
	private static final Font fontModalites = new Font(Font.HELVETICA , 10, Font.BOLD);
	private static final Font fontTotaux = new Font(Font.HELVETICA , 10, Font.NORMAL);
	private static final Font fontSmallTitre = new Font(Font.HELVETICA , 8, Font.BOLD+Font.ITALIC, Color.WHITE);


	private DecimalFormat numFormat = new DecimalFormat("0.00");
	private DecimalFormat numFormatCap = new DecimalFormat("0.##");
	private SimpleDateFormat formatDate = new SimpleDateFormat("dd/MM/yyyy");

	private float[] widthsCols;
	private int nbCols;

	private Image logo;
	private boolean afficherAdrFact;

	
	public AcompteClientStd(String tempdir, DataAcompteClient id) throws Exception {

		super(tempdir, id);

		DecimalFormatSymbols dfs = new DecimalFormatSymbols();
		dfs.setDecimalSeparator('.');
		dfs.setGroupingSeparator(' ');

		numFormat.setDecimalFormatSymbols(dfs);
		numFormat.setNegativeSuffix("");
		numFormat.setNegativePrefix("-");
		numFormat.setPositiveSuffix(" ");
		numFormat.setGroupingUsed(true);
		numFormat.setGroupingSize(3);		

		numFormatCap.setDecimalFormatSymbols(dfs);
		numFormatCap.setGroupingUsed(true);
		numFormatCap.setGroupingSize(3);		

		try {
			logo = Image.getInstance(id.urlLogo);
			if (logo.getDpiX()!=0 && logo.getDpiY()!=0) {
				logo.scaleAbsolute(logo.getPlainWidth() * 72 / logo.getDpiX(), logo.getPlainHeight() * 72 / logo.getDpiY());
			}
		}
		catch (Exception e) {
			logo = null;
		}
		
		this.afficherAdrFact = (!id.denominationFact.equals(id.denominationEnvoi) || !id.adresse1Fact.equals(id.adresse1Envoi) || !id.adresse2Fact.equals(id.adresse2Envoi) || !id.adresse3Fact.equals(id.adresse3Envoi)
			|| !id.codePostalFact.equals(id.codePostalEnvoi) || !id.villeFact.equals(id.villeEnvoi) || !id.paysFact.equals(id.paysEnvoi));

		PdfWidths pw = new PdfWidths();
		
		pw.addColonneVariableMin(4,20);
		pw.addColonneVariableMin(1, 9);
		
		nbCols = pw.getNbCols();
		widthsCols = pw.getWidthsCols();

	}



	/* implmentation des fonctions de MultiPagesDocument */

	public PdfPTable firstHeader() throws DocumentException {

		TableBuilder tb = new TableBuilder();

		tb.add(makeEntete());
		tb.add(makeSpace(5));
		tb.add(makeTitre());
		tb.add(makeSpace(5));
		tb.add(makeCadreRefs());
		tb.add(makeSpace(5));
		tb.add(makeEntetesColonnes());

		return tb.getTable();	
	}


	public PdfPTable middleHeader(int lastLine) throws DocumentException {

		TableBuilder tb = new TableBuilder();

		tb.add(makeEntete());
		tb.add(makeSpace(5));
		tb.add(makeTitre());
		tb.add(makeSpace(5));
		tb.add(makeEntetesColonnes());

		return tb.getTable();
	}


	public PdfPTable lastFooter() throws DocumentException {

		TableBuilder tb = new TableBuilder();
		
		tb.add(makeTotauxLast());		
		tb.add(makeSpace(5));
		tb.add(makeInfosLegales());

		return tb.getTable();
	}	
	
	
	public int nbLines() {
		return 1;
	}


	public PdfPTable middleFooter(int nbLinesPage, int lastLine) throws DocumentException {

		TableBuilder tb = new TableBuilder();

		tb.add(lastFooter());

		return tb.getTable();		
	}


	public PdfPTable bodyLine(int numLine) throws DocumentException {

		return makeLineAcompte();	
	}


	public PdfPTable emptyLine(float emptyHeight) throws DocumentException {

		PdfPTable pptSpace = new PdfPTable(nbCols);
		pptSpace.setWidthPercentage(100);
		pptSpace.setWidths(widthsCols);

		PdfPCell cell = new PdfPCell(pptSpace.getDefaultCell());
		cell.setBorder(PdfPCell.LEFT+PdfPCell.RIGHT);
		cell.setPaddingBottom(0);
		cell.setPaddingTop(0);
		cell.setFixedHeight(emptyHeight);		
		cell.setPhrase(new Phrase(""));

		for (int i=0; i<nbCols; i++) {
			pptSpace.addCell(cell);
		}

		return pptSpace;
	}



	public int nbEx() {

		return (multi?id.getNbEx():1);
	}


	public Image imageFond() {
		if (id.annule) {	
			try {
				Image fond = Image.getInstance(id.urlAnnule);
				fond.scaleAbsolute(324, 468);
				fond.setAbsolutePosition(135,100);
				
				return fond;
			}
			catch (Exception e) {
				return null;
			}
		}
		else
			return null;
	}



	/* mthodes internes */

	private PdfPTable makeSpace(int space) {

		PdfPTable pptSpace = new PdfPTable(1);
		PdfPCell cell = new PdfPCell(pptSpace.getDefaultCell());
		cell.setBorder(PdfPCell.NO_BORDER);
		cell.setFixedHeight(space);
		cell.setPhrase(new Phrase(""));

		pptSpace.addCell(cell);

		return pptSpace;
	}


	private PdfPTable makeEntete() throws DocumentException {

		PdfPTable pptEntete = new PdfPTable(2);
		pptEntete.setWidthPercentage(100);
		int[] widths = {50,50};
		pptEntete.setWidths(widths);
		
		PdfPTable pptEnteteGauche = new PdfPTable(1);
		pptEnteteGauche.setWidthPercentage(100);
		PdfPTable pptEnteteDroite = new PdfPTable(1);
		pptEnteteDroite.setWidthPercentage(100);
		
		PdfPCell cellSociete = new PdfPCell(makeInfosSociete());
		cellSociete.setMinimumHeight(115);
		cellSociete.setBorder(PdfPCell.NO_BORDER);
		pptEnteteGauche.addCell(cellSociete);
		if (this.afficherAdrFact) {
			PdfPCell cellAdrFact = new PdfPCell(makeAdrFact());
			cellAdrFact.setBorder(PdfPCell.NO_BORDER);
			pptEnteteGauche.addCell(cellAdrFact);
			PdfPCell cellVide = new PdfPCell(pptEnteteGauche.getDefaultCell());
			cellVide.setBorder(PdfPCell.NO_BORDER);
			cellVide.setPhrase(new Phrase(""));
			pptEnteteGauche.addCell(cellVide);
		}
		PdfPCell cellVide = new PdfPCell(pptEnteteGauche.getDefaultCell());
		cellVide.setBorder(PdfPCell.NO_BORDER);
		cellVide.setPhrase(new Phrase(""));
		pptEnteteGauche.addCell(cellVide);
		
		PdfPCell cellFacture = new PdfPCell(makeInfosFacture());
		cellFacture.setFixedHeight(115);
		cellFacture.setBorder(PdfPCell.NO_BORDER);
		pptEnteteDroite.addCell(cellFacture);		
		PdfPCell cellAdrEnvoi = new PdfPCell(makeAdrEnvoi());
		cellAdrEnvoi.setMinimumHeight(80);
		cellAdrEnvoi.setBorder(PdfPCell.NO_BORDER);
		pptEnteteDroite.addCell(cellAdrEnvoi);
		pptEnteteDroite.addCell(cellVide);
		
		PdfPCell cellPartieGauche = new PdfPCell(pptEnteteGauche);
		cellPartieGauche.setBorder(PdfPCell.NO_BORDER);
		PdfPCell cellPartieDroite = new PdfPCell(pptEnteteDroite);		
		cellPartieDroite.setBorder(PdfPCell.NO_BORDER);
		pptEntete.addCell(cellPartieGauche);
		pptEntete.addCell(cellPartieDroite);
		
		return pptEntete;	
	}


	private PdfPTable makeInfosSociete() {

		PdfPTable pptInfos = new PdfPTable(1);

		PdfPCell cell;

		if (logo != null) {
			cell = new PdfPCell(logo, false);

			cell.setBorder(PdfPCell.NO_BORDER);
			cell.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);

			pptInfos.addCell(cell);

			cell.setImage(null);

			cell.setMinimumHeight(5);
			cell.setPhrase(new Phrase("", fontAdrSociete));
			pptInfos.addCell(cell);
			cell.setMinimumHeight(0);
		}
		else {
			cell = new PdfPCell(pptInfos.getDefaultCell());
			cell.setBorder(PdfPCell.NO_BORDER);
			cell.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
		}		

		if (!id.logoAdr) {
			cell.setPhrase(new Phrase(id.raisonSociale, fontAdrSocieteGras));		
			pptInfos.addCell(cell);
			cell.setPhrase(new Phrase(id.adresse1, fontAdrSociete));		
			pptInfos.addCell(cell);
			if (!id.adresse2.equals("")) {
				cell.setPhrase(new Phrase(id.adresse2, fontAdrSociete));
				pptInfos.addCell(cell);
			}
			if (!id.adresse3.equals("")) {
				cell.setPhrase(new Phrase(id.adresse3, fontAdrSociete));
				pptInfos.addCell(cell);
			}
			cell.setPhrase(new Phrase(id.codePostal+" "+id.ville, fontAdrSociete));		
			pptInfos.addCell(cell);

			String telfax = "";

			if (id.tel.length()>0) {
				telfax = "T\u00E9l: "+ id.tel;
				if (id.fax.length()>0) {
					telfax += " - Fax: "+ id.fax;
				}
			}
			else if (id.fax.length()>0) {
				telfax = "Fax: "+ id.fax;
			}		

			if (telfax.length()>0) {
				cell.setPhrase(new Phrase(telfax, fontAdrSociete));		
				pptInfos.addCell(cell);
			}

			if (!id.email.equals("")) {
				cell.setPhrase(new Phrase("e-mail: "+ id.email, fontAdrSociete));		
				pptInfos.addCell(cell);
			}
			if (!id.web.equals("")) {
				cell.setPhrase(new Phrase(id.web, fontWeb));		
				pptInfos.addCell(cell);
			}
		}

		cell.setPhrase(new Phrase(""));		
		pptInfos.addCell(cell);

		return pptInfos;	
	}
	
	
	private PdfPTable makeAdrFact() throws DocumentException {

		PdfPTable pptInfosFacture = new PdfPTable(1);

		PdfPCell cell = new PdfPCell(pptInfosFacture.getDefaultCell());

		cell.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);

		cell.setBackgroundColor(new Color(175,175,175));

		cell.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
		cell.setPhrase(new Phrase("FACTURATION", fontSmallTitre));
		pptInfosFacture.addCell(cell);

		cell.setBackgroundColor(Color.WHITE);

		cell.setPaddingBottom(0);
		cell.setPaddingLeft(5);

		cell.setBorder(PdfPCell.BOX-PdfPCell.BOTTOM);

		cell.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
		cell.setPhrase(new Phrase(id.denominationFact, fontAdresse));
		pptInfosFacture.addCell(cell);

		cell.setBorder(PdfPCell.LEFT+PdfPCell.RIGHT);

		cell.setPhrase(new Phrase(id.adresse1Fact, fontAdresse));
		pptInfosFacture.addCell(cell);

		if (!id.adresse2Fact.equals("")) {
			cell.setPhrase(new Phrase(id.adresse2Fact, fontAdresse));
			pptInfosFacture.addCell(cell);
		}

		if (!id.adresse3Fact.equals("")) {
			cell.setPhrase(new Phrase(id.adresse3Fact, fontAdresse));
			pptInfosFacture.addCell(cell);
		}

		cell.setPhrase(new Phrase(id.codePostalFact+" "+id.villeFact, fontAdresse));
		pptInfosFacture.addCell(cell);

		if (!id.paysFact.equals("")) {
			cell.setPhrase(new Phrase(id.paysFact, fontAdresse));
			pptInfosFacture.addCell(cell);
		}
		
		cell.setBorder(PdfPCell.BOX-PdfPCell.TOP);
		cell.setMinimumHeight(5);
		cell.setPhrase(new Phrase("", fontAdresse));
		pptInfosFacture.addCell(cell);

		PdfPTable pptGlobale = new PdfPTable(2);
		int[] widths = {60,40};
		pptGlobale.setWidths(widths);

		PdfPCell cellGlob = new PdfPCell(pptInfosFacture);
		cellGlob.setBorder(PdfPCell.NO_BORDER);

		pptGlobale.addCell(cellGlob);

		cellGlob = new PdfPCell(pptGlobale.getDefaultCell());
		cellGlob.setPhrase(new Phrase(""));
		cellGlob.setBorder(PdfPCell.NO_BORDER);

		pptGlobale.addCell(cellGlob);

		return pptGlobale;
	}
	
	
	private PdfPTable makeAdrEnvoi() throws DocumentException {

		PdfPTable pptInfosFacture = new PdfPTable(2);

		PdfPCell cell = new PdfPCell(pptInfosFacture.getDefaultCell());

		cell.setColspan(2);
		cell.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);

		cell.setMinimumHeight(0);
		cell.setPaddingLeft(0);
		cell.setPaddingBottom(0);
		
		cell.setBorder(PdfPCell.NO_BORDER);
		
		cell.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
		cell.setPhrase(new Phrase(id.denominationEnvoi, fontAdrGras));
		pptInfosFacture.addCell(cell);
		
		cell.setPhrase(new Phrase(id.adresse1Envoi, fontAdrGras));
		pptInfosFacture.addCell(cell);
		
		if (!id.adresse2Envoi.equals("")) {
			cell.setPhrase(new Phrase(id.adresse2Envoi, fontAdrGras));
			pptInfosFacture.addCell(cell);
		}
		
		if (!id.adresse3Envoi.equals("")) {
			cell.setPhrase(new Phrase(id.adresse3Envoi, fontAdrGras));
			pptInfosFacture.addCell(cell);
		}
		
		cell.setPhrase(new Phrase(id.codePostalEnvoi+" "+id.villeEnvoi, fontAdrGras));
		pptInfosFacture.addCell(cell);
		
		if (!id.paysEnvoi.equals("")) {
			cell.setPhrase(new Phrase(id.paysEnvoi, fontAdrGras));
			pptInfosFacture.addCell(cell);
		}
		
		cell.setPhrase(new Phrase("", fontLine));
		pptInfosFacture.addCell(cell);

		PdfPTable pptGlobale = new PdfPTable(2);
		int[] widths = {85,15};
		pptGlobale.setWidths(widths);

		PdfPCell cellGlob = new PdfPCell(pptInfosFacture);
		cellGlob.setBorder(PdfPCell.NO_BORDER);

		pptGlobale.addCell(cellGlob);

		cellGlob = new PdfPCell(pptGlobale.getDefaultCell());
		cellGlob.setPhrase(new Phrase(""));
		cellGlob.setBorder(PdfPCell.NO_BORDER);

		pptGlobale.addCell(cellGlob);

		return pptGlobale;
	}
	

	private PdfPTable makeInfosFacture() throws DocumentException {

		PdfPTable pptInfosFacture = new PdfPTable(2);

		int[] widths = {60,40};
		pptInfosFacture.setWidths(widths);

		PdfPCell cell = new PdfPCell(pptInfosFacture.getDefaultCell());

		cell.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
		cell.setPaddingLeft(4);
		cell.setPaddingBottom(4);

		cell.setPhrase(new Phrase("Facture d'acompte n\u00B0 "+ id.numAcompte, fontInfosFact));
		pptInfosFacture.addCell(cell);

		cell.setPhrase(new Phrase("Date : "+ formatDate.format(new Date(id.dateAcompte)), fontInfosFact));
		pptInfosFacture.addCell(cell);

		String codeClient = (id.clientId.length()>0?"Client N\u00B0 "+ id.clientId +" - ":"Client : ") + id.denominationFact;

		cell.setColspan(2);
		cell.setPhrase(new Phrase(codeClient, fontInfosFact));
		pptInfosFacture.addCell(cell);

		if (id.interlocuteur.length()>0) {
			cell.setPhrase(new Phrase("Interlocuteur : "+ id.interlocuteur, fontInfosFact));
			pptInfosFacture.addCell(cell);
		}

		cell.setBorder(PdfPCell.NO_BORDER);

		cell.setPhrase(new Phrase("", fontLine));
		cell.setFixedHeight(5);
		pptInfosFacture.addCell(cell);
		cell.setMinimumHeight(0);

		cell.setPhrase(new Phrase("Page "+ currentPage +" / "+ totalPages, fontInfosFact));
		cell.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
		pptInfosFacture.addCell(cell);

		cell.setPhrase(new Phrase("", fontLine));
		cell.setFixedHeight(55);
		pptInfosFacture.addCell(cell);

		return pptInfosFacture;		
	}


	private PdfPTable makeTitre() {

		PdfPTable pptTitre = new PdfPTable(1);
		pptTitre.setWidthPercentage(100);

		PdfPCell cell = new PdfPCell(pptTitre.getDefaultCell());		
		cell.setBorder(PdfPCell.NO_BORDER);
		cell.setBackgroundColor(new Color(175,175,175));
		cell.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
		cell.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
		cell.setFixedHeight(30);
		cell.setPaddingBottom(5);
		cell.setPhrase(new Phrase("F   A   C   T   U   R   E      D   '   A   C   O   M   P   T   E", fontTitre));

		pptTitre.addCell(cell);

		return pptTitre;	
	}


	private PdfPTable makeCadreRefs() throws DocumentException {

		PdfPTable pptCadre = new PdfPTable(2);
		int[] widths = {50,50};
		pptCadre.setWidths(widths);

		PdfPCell cell = new PdfPCell(pptCadre.getDefaultCell());		

		cell.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
		cell.setFixedHeight(20);
		cell.setPaddingLeft(5);
		
		cell.setBorder(PdfPCell.BOX-PdfPCell.RIGHT);
		cell.setPhrase(new Phrase("R\u00E9f. Commande : "+ id.refCommande, fontLine));
		pptCadre.addCell(cell);
		
		cell.setBorder(PdfPCell.BOX-PdfPCell.LEFT);
		cell.setPhrase(new Phrase("N\u00B0 Commande : "+ id.numCommande, fontLine));
		pptCadre.addCell(cell);
		
		return pptCadre;
	}


	private PdfPTable makeEntetesColonnes() throws DocumentException {

		PdfPTable pptCols = new PdfPTable(nbCols);
		pptCols.setWidthPercentage(100);
		pptCols.setWidths(widthsCols);

		PdfPCell cell = new PdfPCell(pptCols.getDefaultCell());		

		cell.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
		cell.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
		cell.setPaddingBottom(4);
		cell.setMinimumHeight(40);

		cell.setPhrase(new Phrase("Libell\u00E9", fontEnteteColonne));
		pptCols.addCell(cell);

		cell.setPhrase(new Phrase("Montant", fontEnteteColonne));
		pptCols.addCell(cell);

		return pptCols;
	}	


	private PdfPTable makeLineAcompte() throws DocumentException {

		PdfPTable pptLine = new PdfPTable(nbCols);
		pptLine.setWidthPercentage(100);
		pptLine.setWidths(widthsCols);

		PdfPCell cell = new PdfPCell(pptLine.getDefaultCell());

		cell.setBorder(PdfPCell.RIGHT+PdfPCell.LEFT);
		
		cell.setPhrase(new Phrase("", fontLineLibelle));
		cell.setFixedHeight(20);
		pptLine.addCell(cell);
		pptLine.addCell(cell);
		
		cell.setMinimumHeight(0);
		cell.setPaddingLeft(5);
		cell.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
		cell.setPhrase(new Phrase(id.libelle, fontLineLibelle));
		pptLine.addCell(cell);
		cell.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
		cell.setPhrase(new Phrase(numFormat.format(id.totalTTC), fontLineLibelle));
		pptLine.addCell(cell);
		
		cell.setFixedHeight(15);
		cell.setPhrase(new Phrase(""));
		pptLine.addCell(cell);
		pptLine.addCell(cell);
		
		cell.setMinimumHeight(0);
		cell.setPhrase(new Phrase(id.comFin, fontLine));
		pptLine.addCell(cell);
		cell.setPhrase(new Phrase(""));
		pptLine.addCell(cell);

		return pptLine;
	}


	private PdfPTable makeTotauxLast() throws DocumentException {

		PdfPTable pptTotaux = new PdfPTable(3);
		pptTotaux.setWidthPercentage(100);
		int[] widths = {50,15,35};
		pptTotaux.setWidths(widths);		

		PdfPCell cell = new PdfPCell(makeCadreDivers());	
		cell.setBorder(PdfPCell.BOTTOM+PdfPCell.TOP+PdfPCell.LEFT);		
		pptTotaux.addCell(cell);

		cell = new PdfPCell(pptTotaux.getDefaultCell());	
		cell.setBorder(PdfPCell.BOTTOM+PdfPCell.TOP);		
		cell.setPhrase(new Phrase(""));
		pptTotaux.addCell(cell);

		cell = new PdfPCell(makeCadreTotaux());
		cell.setBorder(PdfPCell.BOTTOM+PdfPCell.TOP+PdfPCell.RIGHT);		
		pptTotaux.addCell(cell);		

		return pptTotaux;	
	}


	private PdfPTable makeCadreDivers() throws DocumentException {

		PdfPTable pptDivers = new PdfPTable(2);
		pptDivers.setWidthPercentage(100);
		int[] widths = {30,70};
		pptDivers.setWidths(widths);

		PdfPCell cell = new PdfPCell(pptDivers.getDefaultCell());

		cell.setBorder(PdfPCell.NO_BORDER);
		cell.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
		cell.setColspan(2);
		cell.setPaddingLeft(5);
		
		cell.setPhrase(new Phrase("Mode de r\u00E8glement : "+ id.modeReglement, fontModalites));
		pptDivers.addCell(cell);

		cell.setMinimumHeight(10);
		cell.setPhrase(new Phrase("", fontModalites));
		pptDivers.addCell(cell);		

		return pptDivers;
	}
	


	private PdfPTable makeCadreTotaux() throws DocumentException {

		PdfPTable pptCadreTotaux = new PdfPTable(2);
		pptCadreTotaux.setWidthPercentage(100);
		int[] widths = {55,45};
		pptCadreTotaux.setWidths(widths);

		PdfPCell cell = new PdfPCell(pptCadreTotaux.getDefaultCell());
		cell.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);		
		cell.setBorder(PdfPCell.NO_BORDER);		
		cell.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);

		cell.setPhrase(new Phrase("Total HT :", fontTotaux));
		pptCadreTotaux.addCell(cell);
		cell.setPhrase(new Phrase(numFormat.format(id.totalHT) +" \u20AC", fontTotaux));
		pptCadreTotaux.addCell(cell);

		cell.setPhrase(new Phrase("Total TVA "+ (id.totalTVA!=0?"("+ numFormat.format(id.tauxTVA) +" %) ":"")+":", fontTotaux));
		pptCadreTotaux.addCell(cell);
		cell.setPhrase(new Phrase(numFormat.format(id.totalTVA) +" \u20AC", fontTotaux));
		pptCadreTotaux.addCell(cell);
		
		cell.setPhrase(new Phrase("Total TTC :", fontTotaux));
		pptCadreTotaux.addCell(cell);
		cell.setPhrase(new Phrase(numFormat.format(id.totalTTC) +" \u20AC", fontTotaux));
		pptCadreTotaux.addCell(cell);

		cell.setColspan(2);
		cell.setPhrase(new Phrase(""));
		pptCadreTotaux.addCell(cell);

		return pptCadreTotaux;
	}


	private PdfPTable makeInfosLegales() {

		PdfPTable pptLegales = new PdfPTable(1);
		pptLegales.setWidthPercentage(100);

		PdfPCell cell = new PdfPCell(pptLegales.getDefaultCell());		

		cell.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
		cell.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
		cell.setBorder(PdfPCell.NO_BORDER);
		cell.setPhrase(new Phrase(id.raisonSociale +" - "+ id.typeSociete + (id.capital>0?" au capital de "+ numFormatCap.format(id.capital) +" Euros":"") +" - immatricul\u00E9e au RCS "+ id.rcs +" "+ id.siren +" - N\u00B0 TVA : "+ id.tvaIntra, fontLegale));

		pptLegales.addCell(cell);

		return pptLegales;	
	}


} // fin AcompteClientStd
