/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Gnration d'un bon de livraison
 */

package org.opensi.facturation.actions.documents;


import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;

import org.experlog.openeas.api.Action;
import org.experlog.openeas.api.ServletRequest;
import org.experlog.openeas.api.Session;
import org.opensi.facturation.actions.documents.modeles.BonLivraisonPDF;
import org.opensi.facturation.actions.documents.modeles.BonLivraisonStd;
import org.opensi.facturation.actions.documents.modeles.DataBonLivraison;
import org.opensi.facturation.actions.documents.modeles.OrdreLivraisonStd;
import org.opensi.util.pdf.GlobalDocument;


public class GenBonLivraison extends Action {


  public boolean serverSide() { return true; }

  public boolean service(Session s, ServletRequest r, Object info) throws Exception {
	
		String fichierPdf = "bon_"+ r.getParameter("Id_Bon") +".pdf";
		String absdir = s.getAppConfiguration().get("opensi.absdir");
		String base = s.getCookie().get("BaseDossier");
		
		String repPdf = absdir +"/pdf/";
		String repTemp = repPdf;
		
		String reqModeleBL = "select mbl.Modele_Id, mbl.Class from "+ base +".MODELE_BON_LIVRAISON mbl, "+ base +".PARAM_DOSSIER d";
		reqModeleBL += " where mbl.Modele_Id=d.Modele_Pdf_BL";
		Connection con = s.getConnection(null);
		Statement stt = con.createStatement();
		ResultSet rset = stt.executeQuery(reqModeleBL);
		rset.next();
		String modele = rset.getString("Modele_Id");
		String chemin = rset.getString("Class");
		rset.close();
		stt.close();
		s.closeConnection(con, null);
		
		GlobalDocument gd = new GlobalDocument(repPdf, fichierPdf);
		
		boolean multi = r.getParameter("MultiEx")!=null;
		
		if (r.getParameter("Ordre_Livraison")!=null) {
			OrdreLivraisonStd ordreLivraison = new OrdreLivraisonStd(repTemp, new DataBonLivraison(s, r.getParameter("Bon_Id")));
			ordreLivraison.setMultiEx(multi);
			
			if (r.getParameter("Chiffre")!=null)
				ordreLivraison.setBonChiffre(r.getParameter("Chiffre").equals("1"));
			
			if (r.getParameter("Affichage")!=null)
				ordreLivraison.setAffCoord(!r.getParameter("Affichage").equalsIgnoreCase("R"));
		
			gd.addInternal(ordreLivraison);
		} else {
			BonLivraisonPDF bonLivraison;
			DataBonLivraison dbl = new DataBonLivraison(s, r.getParameter("Bon_Id"));
			if (modele.equals("STD01")) {
				bonLivraison = new BonLivraisonStd(repTemp, dbl);
			}
			else {
				Object[] o = {repTemp, dbl};
				Class<?> cl = Class.forName(chemin);
				Constructor<?> c = cl.getConstructors()[0];
				bonLivraison = (BonLivraisonPDF)c.newInstance(o);
			}
			bonLivraison.setMultiEx(multi);
			
			if (r.getParameter("Chiffre")!=null)
				bonLivraison.setBonChiffre(r.getParameter("Chiffre").equals("1"));
			
			if (r.getParameter("Affichage")!=null)
				bonLivraison.setAffCoord(!r.getParameter("Affichage").equalsIgnoreCase("R"));
		
			gd.addInternal(bonLivraison);
		}
		
		
		gd.close(GlobalDocument.ON_EXIT);
	
		return true;
		
	} // fin service


} // fin GenBonLivraison
