/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Gnration d'une liste des commandes
 */

package org.opensi.facturation.actions.commandes;

import org.opensi.util.listing.ListingFile;
import org.opensi.util.listing.ListingTabFile;
import org.opensi.util.tools.DateTime;


public class CsvListeCommandesFournisseurs {

	public CsvListeCommandesFournisseurs(String buffer, String fichier, DataListeCommandesFournisseurs dlc) throws Exception {
		
		ListingFile lf = new ListingTabFile();

		lf.newLine();
		lf.addToLine("Date");
		lf.addToLine("N\u00B0 Commande");
		lf.addToLine("Intitul\u00E9");
		lf.addToLine("N\u00B0 Fournisseur");
		lf.addToLine("Fournisseur");
		lf.addToLine("Responsable");
		lf.addToLine("Etat");
		lf.addToLine("CA R\u00E9ceptionn\u00E9");
		lf.addToLine("CA Restant");
		lf.addToLine("Total HT");

		int nbLignes = dlc.getNbLignes();

		for (int i=0; i<nbLignes; i++) {
			LigneListeCommandesFournisseurs llc = dlc.lignes.get(i);

			lf.newLine();
			lf.addToLine(DateTime.formatTime(llc.dateCommande, "dd/MM/yyyy"));
			lf.addToLine("\"" + llc.numCommande + "\"");
			lf.addToLine("\"" + llc.intitule + "\"");
			lf.addToLine("\"" + llc.numFournisseur + "\"");
			lf.addToLine("\"" + llc.nomFournisseur + "\"");
			lf.addToLine("\"" + llc.nomResponsable + "\"");
			lf.addToLine("\"" + llc.etatCommande + "\"");
			lf.addToLine(("" + llc.caReceptionne).replaceAll("\\.", ","));
			lf.addToLine(("" + llc.caRestant).replaceAll("\\.", ","));
			lf.addToLine(("" + llc.totalHT).replaceAll("\\.", ","));
		}

		lf.write(buffer, fichier, true);
	}



} // fin CsvListeCommandesFournisseurs
