/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Gnration ou actualisation du colisage d'un BL
 */

package org.opensi.facturation.actions.colisage;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

import org.experlog.openeas.api.Action;
import org.experlog.openeas.api.ServletRequest;
import org.experlog.openeas.api.Session;



public class ColisageBL extends Action {



private PreparedStatement psNewColis;
private PreparedStatement psNewContenu;

private PreparedStatement psSupColis;
private PreparedStatement psSupContenu;

private PreparedStatement psMajQteCont;
private PreparedStatement psMajPoidsColis;

private PreparedStatement psExContenu;

private PreparedStatement psCalcPoidsColis;


  public boolean serverSide() { return true; }

  public boolean service(Session s, ServletRequest r, Object info) {

		try {
		Connection con = s.getConnection(null);
		
		String base = s.getCookie().get("BaseDossier");
		
		String bonId = r.getParameter("Bon_Id");
		
		
		String reqArticlesBL = "select ab.Ref_Ligne, ab.Quantite, ac.Type_Ligne, ac.Reference from "+ base +".LIGNE_BON_LIVRAISON ab, "
														+ base +".LIGNE_COMMANDE_CLIENT ac where Bon_Id="+ bonId +" and ab.Ref_Ligne=ac.Ligne_Id and ac.Statut='V' and ab.Statut='V'";
		
		String reqColisage = "select Colisage, if(Mesure_Poids='K',Poids_Brut,if(Mesure_Poids='G',Poids_Brut/1000,Poids_Brut*1000)) as Poids_Brut from "+ base +".FICHE_ARTICLE where Article_Id=?";
		
		String reqNewColis = "insert into "+ base +".COLIS (Bon_Id, Ident_Suivi, Poids) values ("+ bonId +",'',?)";
		
		String reqNewContenu = "insert into "+ base +".CONTENU_COLIS (Colis_Id, Ref_Ligne, Quantite, Poids) values (?,?,?,?)";
		
		String reqQteLigne = "select sum(Quantite) as QteLigne from "+ base +".CONTENU_COLIS where Ref_Ligne=?";
		
		String reqContInfColisage = "select Colis_Id, Ref_Ligne, Quantite from "+ base +".CONTENU_COLIS where Ref_Ligne=? and Quantite<?";
		
		String reqContenuLigne = "select Colis_Id, Quantite from "+ base +".CONTENU_COLIS where Ref_Ligne=? order by Quantite";
		
		String reqMajQteCont = "update "+ base +".CONTENU_COLIS set Quantite=? where Colis_Id=? and Ref_Ligne=?";
		
		String reqMajPoidsColis = "update "+ base +".COLIS set Poids=? where Colis_Id=?";

		String reqSupColis = "delete from "+ base +".COLIS where Colis_Id=?";
		
		String reqSupContenu = "delete from "+ base +".CONTENU_COLIS where Colis_Id=? and Ref_Ligne=?";
		
		String reqExContenu = "select Colis_Id from "+ base +".CONTENU_COLIS where Colis_Id=?";
		
		String reqCalcPoidsColis = "select sum(Poids) as Poids_Colis from "+ base +".CONTENU_COLIS where Colis_Id=?";
		
		String reqRefSupBL = "select cc.Colis_Id, cc.Ref_Ligne from "+ base +".CONTENU_COLIS cc left join "
														+ base +".LIGNE_BON_LIVRAISON ab on cc.Ref_Ligne=ab.Ref_Ligne and ab.Statut='V' where ab.Ref_Ligne is null";
		
		
		PreparedStatement psColisage = con.prepareStatement(reqColisage);
		psNewColis = con.prepareStatement(reqNewColis, Statement.RETURN_GENERATED_KEYS);
		psNewContenu = con.prepareStatement(reqNewContenu);
		psSupColis = con.prepareStatement(reqSupColis);
		psSupContenu = con.prepareStatement(reqSupContenu); 
		
		PreparedStatement psQteLigne = con.prepareStatement(reqQteLigne);
		PreparedStatement psContInfColisage = con.prepareStatement(reqContInfColisage);
		PreparedStatement psContenuLigne = con.prepareStatement(reqContenuLigne);
		psMajQteCont = con.prepareStatement(reqMajQteCont);
		psMajPoidsColis = con.prepareStatement(reqMajPoidsColis);
		psExContenu = con.prepareStatement(reqExContenu);
		psCalcPoidsColis = con.prepareStatement(reqCalcPoidsColis);
		
	
		Statement sttArticlesBL = con.createStatement();
		ResultSet rsAB = sttArticlesBL.executeQuery(reqArticlesBL);
		
		while (rsAB.next()) {
			String typeLigne = rsAB.getString("Type_Ligne");
			int refLigne = rsAB.getInt("Ref_Ligne");
			double qteLigne = rsAB.getDouble("Quantite");
			String reference = rsAB.getString("Reference");
			
			if (typeLigne.equalsIgnoreCase("S")) {
				// rcupration poids et colisage de l'article
				psColisage.setString(1, reference);
				ResultSet rsCol = psColisage.executeQuery();
				rsCol.next();				
				double colisage = rsCol.getDouble("Colisage");
				double poids = rsCol.getDouble("Poids_Brut");				
				rsCol.close();
				
				if (colisage>0) {
					// rcupration de la quantit colise de la ligne
					psQteLigne.setInt(1, refLigne);
					ResultSet rsQL = psQteLigne.executeQuery();
					rsQL.next();
					double qteLigneColisee = rsQL.getDouble("QteLigne");
					rsQL.close();

					if (qteLigne>qteLigneColisee) {
						// la quantit dans le BL est suprieure  la quantit colise

						double qteARajouter = qteLigne - qteLigneColisee;

						// ajout de colis pleins tant que qteARajouter >= colisage
						while (qteARajouter>=colisage) {						

							qteARajouter -= colisage;				
							int colisId = nouveauColis(colisage * poids);
							nouveauContenu(colisId, refLigne, colisage, poids);						
						}

						// completion des colis dont qte < colisage								
						psContInfColisage.setInt(1, refLigne);
						psContInfColisage.setDouble(2, colisage);
						ResultSet rsCIC = psContInfColisage.executeQuery();
						while (qteARajouter>=0.01 && rsCIC.next()) {

							qteARajouter += rsCIC.getDouble("Quantite");
							int colisId = rsCIC.getInt("Colis_Id");
							double qteColis = (qteARajouter>=colisage?colisage:qteARajouter);
							qteARajouter -= qteColis;

							majQteContenu(qteColis, colisId, refLigne);
						}

						rsCIC.close();

						// ajout d'un colis s'il reste un surplus
						if (qteARajouter>=0.01) {

							int colisId = nouveauColis(qteARajouter * poids);
							nouveauContenu(colisId, refLigne, qteARajouter, poids);
							qteARajouter = 0;
						}
					}
					else if (qteLigne<qteLigneColisee) {
						// la quantit dans le BL est infrieure  la quantit colise

						double qteARetirer = qteLigneColisee - qteLigne;

						// on retire d'abord dans les colis dont qte < colisage					

						psContenuLigne.setInt(1, refLigne);
						ResultSet rsCL = psContenuLigne.executeQuery();
						while (qteARetirer>=0.01 && rsCL.next()) {

							int colisId = rsCL.getInt("Colis_Id");					
							double qteCont = rsCL.getDouble("Quantite");

							if (qteCont<=qteARetirer) {						

								// suppression du contenu	
								supContenu(colisId, refLigne);

								qteARetirer -= qteCont;
							}
							else {

								// mise  jour de la quantit du contenu							
								majQteContenu(qteCont-qteARetirer, colisId, refLigne);

								qteARetirer = 0;
							}
						}

						rsCL.close();
					}				
				}			
			}
		}
		
		rsAB.close();
		sttArticlesBL.close();
		
		// suppression des contenus et colis dont les rfrences ne sont plus dans le BL
		Statement sttRefSupBL = con.createStatement();
		ResultSet rsRFB = sttRefSupBL.executeQuery(reqRefSupBL);
		
		while (rsRFB.next()) {
			supContenu(rsRFB.getInt("Colis_Id"), rsRFB.getInt("Ref_Ligne"));
		}
		
		rsRFB.close();
		sttRefSupBL.close();
		
		s.closeConnection(con, null);
		}
		catch (Exception e) {
        	e.printStackTrace();
		}
		return true;						
	
	} // fin service
	
	
	private int nouveauColis(double poidsColis) throws SQLException {

		psNewColis.setDouble(1, poidsColis);
		psNewColis.executeUpdate();
		ResultSet rsId = psNewColis.getGeneratedKeys();
		rsId.next();
		
		return rsId.getInt(1);
	}
	
	private void nouveauContenu(int colisId, int refLigne, double quantite, double poids) throws SQLException {
		
		psNewContenu.setInt(1, colisId);
		psNewContenu.setInt(2, refLigne);
		psNewContenu.setDouble(3, quantite);
		psNewContenu.setDouble(4, poids);
		psNewContenu.executeUpdate();
	}
	
	private void supContenu(int colisId, int refLigne) throws SQLException {
		
		psSupContenu.setInt(1, colisId);
		psSupContenu.setInt(2, refLigne);
		psSupContenu.executeUpdate();
		
		// suppression du colis si plus de contenu
		if (!existeContenu(colisId)) {
			supColis(colisId);
		}
	}

	private void supColis(int colisId) throws SQLException {
		
		psSupColis.setInt(1, colisId);
		psSupColis.executeUpdate();
	}

	private boolean existeContenu(int colisId) throws SQLException {
		
		psExContenu.setInt(1, colisId);
		ResultSet rsEC = psExContenu.executeQuery();
		
		return rsEC.next();
	}
	
	private void majQteContenu(double qte, int colisId, int refLigne) throws SQLException {
		
		psMajQteCont.setDouble(1, qte);
		psMajQteCont.setInt(2, colisId);
		psMajQteCont.setInt(3, refLigne);
		psMajQteCont.executeUpdate();
		
		// calcul poids du colis
		psCalcPoidsColis.setInt(1, colisId);
		ResultSet rsPC = psCalcPoidsColis.executeQuery();
		rsPC.next();
		double poidsColis = rsPC.getDouble("Poids_Colis");
		rsPC.close();
		
		// mise  jour du poids du colis
		psMajPoidsColis.setDouble(1, poidsColis);
		psMajPoidsColis.setInt(2, colisId);
		psMajPoidsColis.executeUpdate();		
	}
	

} // fin ColisageBL




