/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

package org.opensi.facturation.actions.abonnement;


import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

import org.experlog.openeas.api.Action;
import org.experlog.openeas.api.ServletRequest;
import org.experlog.openeas.api.Session;
import org.opensi.facturation.CalcDateEcheance;
import org.opensi.util.tools.DateTime;


public class generationEcheance extends Action {


	private DateTime DateDebut;
	private DateTime DateFin;
	private DateTime DateProchain;
	private DateTime DateGeneration;
	private long DateFinAbonnementLong;
	private String codePaysLiv;
	private boolean assujettiTVA;
	private double totalHT;
	private double MontantTTC;
	private int Abonnement_Id;
	private int nbPeriodeOfferte;
	double valeurTTC;
	double valeurHT;
 	double Remise;
 	double Escompte;
	double Frais_Port;
	double mRemiseFP;
	double pRemiseFP;
	double TauxTVAPort;
	String base;
	Connection con;
	PreparedStatement psCreerEcheance;
	PreparedStatement psExisteEcheance;


	public boolean serverSide() { return true; }

  public boolean service(Session s, ServletRequest r, Object info) throws Exception {

		//Rcupration des valeurs passes en paramtres
	  this.Abonnement_Id=Integer.parseInt(r.getParameter("Abonnement_Id"));
	  
		String reconduction = r.getParameter("type");
		if (!reconduction.equals("reconduction")){
			this.totalHT=Double.parseDouble(r.getParameter("totalHT"));
			this.MontantTTC=Double.parseDouble(r.getParameter("MontantTTC"));
		}

		
		if (reconduction.equals("avecRachat")){
			valeurHT = Double.parseDouble(r.getParameter("valeurHT"));
			valeurTTC = Double.parseDouble(r.getParameter("valeurTTC"));
		}

		//dclaration des variables du programme
		int nbEcheance=1;
		int nbEcheanceExistante = 0;
		boolean continu=true;
		base = s.getCookie().get("BaseDossier");
		int nbJour=0;
		long DateDebutLong;
		long DateFinLong;
		long DateGenerationLong;
		long DateEcheance;

		con = s.getConnection(null);

		//rcupration des valeurs de l'abonnement dans la base
		String infoAbo = "select * from "+base+".ABONNEMENT where Abonnement_Id="+Abonnement_Id;
		Statement stt1 = con.createStatement();
		ResultSet rset3 = stt1.executeQuery(infoAbo);
		rset3.next();
		int periodicite = rset3.getInt("Periodicite");
		int typePeriodiciteLocal = rset3.getInt("Type_periodicite");
		this.nbPeriodeOfferte = rset3.getInt("nbPeriodeOfferte");
		int delaisEcheance = rset3.getInt("Delais_reglement");
		this.DateDebut = new DateTime(rset3.getLong("Date_debut_abonnement"));
		this.Remise = rset3.getDouble("Remise");
		this.Escompte = rset3.getDouble("Escompte");
		this.Frais_Port=rset3.getDouble("Frais_Port");
		this.mRemiseFP = rset3.getDouble("MRemise_FP");
		this.pRemiseFP = rset3.getDouble("PRemise_FP");
		this.codePaysLiv = rset3.getString("Code_Pays_Liv");
		this.assujettiTVA = rset3.getString("Assujetti_TVA").equals("1");
		//rcuperation de la valeur de la date de fin d'abonnement
		DateTime DateFinAbonnementObject = new DateTime(rset3.getLong("Date_fin_abonnement"));
		this.DateFinAbonnementLong = 	DateFinAbonnementObject.getDateFullTime();

		int Type_facturation = rset3.getInt("Type_facturation");
		int delaisGeneration = rset3.getInt("Delai_gen_facture");
		String Type_reglement;
		switch(rset3.getInt("Type_reglement")){
			case 1:Type_reglement="N";break;
			case 2:Type_reglement="F";break;
			default:Type_reglement="L";break;
		}
		int Val_type_reglement = rset3.getInt("Val_type_reglement");
		int optionRachat = rset3.getInt("OptionRachat");
		//rachat pas utilis
		/*		if (optionRachat==1) {
			double valeur = rset3.getDouble("ValeurRachat");
			double pourcentage = rset3.getDouble("PourcentageRachat");
		}
		*/
		
		CalcDateEcheance DateEcheanceObject = new CalcDateEcheance(Type_reglement,delaisEcheance,Val_type_reglement);

			// prparation de la requte pour insrer une chance
			String reqCreerEcheance = "insert into "+ base +".ECHEANCE_ABONNEMENT (NumEcheance,Abonnement_Id,";
			reqCreerEcheance += "Date_Debut,Date_Fin,Date_generation,Total_HT,MontantTTC,Etat,Date_Echeance,nbJourEcheance,Type)";
			reqCreerEcheance += "values (?,?,?,?,?,?,?,'E',?,?,?)";
			psCreerEcheance = con.prepareStatement(reqCreerEcheance);
			
			String reqExisteEcheance = "select * from "+ base +".ECHEANCE_ABONNEMENT where Abonnement_Id=? and Date_Debut=? and Date_Fin=?";
			psExisteEcheance = con.prepareStatement(reqExisteEcheance);

		//si on est dans le cas d'une reconduction, on recupere le nombre d'echeance pour cet abonnement pour recrer les autres avec les numeros suivant
		//On recupere egalement le total de la derniere echeance pour l'appliquer aux nouvelle
		if (reconduction.equals("reconduction")){
			Statement stt = con.createStatement();
			String nbrEcheance = "select Max(NumEcheance) as nb from "+ base +".ECHEANCE_ABONNEMENT where Abonnement_Id="+Abonnement_Id;
			ResultSet rset;
			rset = stt.executeQuery(nbrEcheance);
			rset.next();
			nbEcheance = rset.getInt("nb");
			nbEcheanceExistante = rset.getInt("nb");
			rset.close();
			calculTotal(nbJour,periodicite,typePeriodiciteLocal);
			nbEcheance++;
		}

		while (continu)
		{
			if (nbEcheance>nbEcheanceExistante+1)
				DateDebut=DateProchain;
			//calcul de la date de la prochaine echeance en ajoutant la periodicite
			DateProchain=this.calcul_date(DateDebut,periodicite,typePeriodiciteLocal);
			//calcul de la date de fin de l'echeance courante en enlevant 1 jour;
			DateFin=this.calcul_date(DateProchain,-1,1);
			//transformation des dates en bigInt pour insertion dans la base
			DateDebutLong = DateDebut.getDateFullTime();
			DateFinLong = DateFin.getDateFullTime();
			//calcul de la date d'echeance du reglement grace  la classe CalcDateEchance et calcul de la date de generation
			//on prend pour date de facture le date de debut ou la date de fin en foncion du type de facturation
			if (Type_facturation==1){
				DateEcheance=DateEcheanceObject.getEcheance(DateDebutLong);
				DateGeneration=this.calcul_date(DateDebut,-delaisGeneration,1);
			}
			else{
				DateEcheance=DateEcheanceObject.getEcheance(DateFinLong);
				DateGeneration=this.calcul_date(DateProchain,-delaisGeneration,1);
			}
			DateGenerationLong = DateGeneration.getDateFullTime();
			//verification de la fin des echeances pour arret de la boucle
			if (DateFinLong>DateFinAbonnementLong) {
				continu = false;
				nbJour=getNbJoursDerniereEcheance(DateDebut,DateFinAbonnementLong);
				DateFinLong=DateFinAbonnementLong;
				calculTotal(nbJour,periodicite,typePeriodiciteLocal);
			}
			else if (DateFinLong==DateFinAbonnementLong){continu = false;}


			ajouterEcheance(nbEcheance,DateDebutLong,DateFinLong,DateGenerationLong,DateEcheance,nbJour,false);
			nbEcheance++;
		}
		if (optionRachat==1) {
			DateFin=this.calcul_date(DateFin,1,1);
			DateFinLong=DateFin.getDateFullTime();
			DateGeneration=this.calcul_date(DateFin,-delaisGeneration,1);
			DateGenerationLong = DateGeneration.getDateFullTime();
			DateEcheance=DateEcheanceObject.getEcheance(DateFinLong);
			ajouterEcheance(nbEcheance,DateFinLong,DateFinLong,DateGenerationLong,DateEcheance,nbJour,true);
		}
		//execute l'insertion
		psCreerEcheance.executeBatch();

		s.closeConnection(con,null);
		return true;
}


	//fonction qui calcul une date de fin  partir d'une date de dbut et d'une periodicit (valeur + type)
	private DateTime calcul_date(DateTime date,int duree,int typeDuree) {

		int jour = date.getDay();
		int mois = date.getMonth();
		int annee = date.getYear();
		int moisOrigine=mois;
		int typeDureeLocal = typeDuree;
		int dureeLocal = duree;

		if (typeDureeLocal==1 || typeDureeLocal==2)
		{
			if (typeDureeLocal==2)
			{
				dureeLocal = dureeLocal*7;
			}
			jour = jour + dureeLocal;
			//pour le cas ou on utilise la fonction pour soustraire une date
			if (jour<=0)
			{
				mois = mois-1; // variable mois2 => variable pour appeler Parametre_abonnement_nbJourParMois
				if (mois==0)	// pour le cas ou le mois trouv est le premier mois on repasse a 12
				{
					mois=12;
					annee= annee-1;
				}
				if (jour==0)
					jour=nb_jour_par_mois(mois,annee);
				else
					jour=nb_jour_par_mois(mois,annee)+jour;
			}

			while (jour>nb_jour_par_mois(mois,annee))	{

						switch(mois) {
							case 4:case 6:case 9:case 11:
								jour -= 30;
								break;
							case 2:	  						
								jour -= (DateTime.isBissextile(annee)?29:28);
								break;
							default:
								jour -= 31;
						}
						mois=mois+1;
						if (mois==13){
							annee=annee+1;
							mois = mois -12;
						}
					}
			}
			else if (typeDureeLocal==3){
				mois=mois + dureeLocal;

				while (mois>12){
					annee=annee+1;
					mois = mois - 12;

				}
					int moisBis = mois-1; // variable mois2 => variable pour appeler Parametre_abonnement_nbJourParMois dans le cas ou le nombre de jour est egal au nombre de jour max d'un mois
					if (moisBis==0) 	// pour le cas ou le mois trouv est le premier mois on repasse a 12
						moisBis=12;

					else if ((moisBis==2) && (moisOrigine==3))
						moisBis=mois;

					if (jour==nb_jour_par_mois(moisBis,annee))
						jour =nb_jour_par_mois(mois,annee);
			}
			else
			{
				annee=annee + dureeLocal;
			}


			DateTime dateRetour = new DateTime(jour,mois,annee);
			return dateRetour;
		}

	//retourne le nombre de jour pour un mois
	private int nb_jour_par_mois(int mois,int annee) {
		int nbJour=-1;
		switch(mois)
		{
			case 1:case 3:case 5:case 7: case 8:case 10:case 12:
				nbJour = 31;break;
			case 4:case 6:case 9:case 11:
				nbJour = 30;break;
			case 2:
	  		if (DateTime.isBissextile(annee))
					nbJour=29;
				else
			 		nbJour=28;
				break;
			default: 
				break;
		}
			return nbJour;

	}

	
	//fonction qui calcule le nombre de jour de la derniere echeance d'un abonnement
	private int getNbJoursDerniereEcheance(DateTime dateDebut,long dateFinAbonnementLong)
	{
		int nbJours = 1;
		DateTime dateFin = new DateTime(dateFinAbonnementLong);
		DateTime dateTemp=dateDebut;
		while (!(dateTemp.getDay()==dateFin.getDay() && dateTemp.getMonth()==dateFin.getMonth() && dateTemp.getYear()==dateFin.getYear()))	{
			nbJours++;
			dateTemp=calcul_date(dateTemp,1,1);
		}
		return nbJours;
	}


	
	private void calculTotal(	int nbJour,int periodicite,int typePeriodicite) throws SQLException {

		int perio = periodicite;
		switch (typePeriodicite){
			case 2:perio = periodicite*7;break;
			case 3:perio = periodicite*30;break;
			case 4:perio = periodicite*360;break;
		}
		
		
		double tva=-1;
		String getTaux = "select Taux_TVA from "+ base +".TAUX_TVA where Normal=1";
		if (this.codePaysLiv.equals("FR")) {
			getTaux += " and Code_Pays='FR'";
		} else {
			String zoneUE = "select Zone_UE from PAYS where Code_Pays='"+ this.codePaysLiv +"' and Zone_UE=1";
			Statement stt6 = this.con.createStatement();
			ResultSet rset6 = stt6.executeQuery(zoneUE);
			if (rset6.next()) {
				if (!assujettiTVA) {						
					String taxeArrivee = "select Code_Pays from "+ base +".OPTION_TAXATION where Code_Pays='" + this.codePaysLiv +"' and Taxe_Arrivee=1";
					Statement stt7 = this.con.createStatement();
					ResultSet rset7 = stt7.executeQuery(taxeArrivee);
					if (rset7.next()) {
						getTaux += " and Code_Pays='" + this.codePaysLiv + "'";
					} else {
						getTaux += " and Code_Pays='FR'";
					}
				} else {
					tva = 0;
				}
			} else {
				tva = 0;
			}
		}
		
		if (tva != 0) {
			Statement stt6 = this.con.createStatement();
			ResultSet rset6 = stt6.executeQuery(getTaux);
			if (rset6.next()) {
				tva = rset6.getDouble("Taux_TVA");
			}
		}
		
		this.TauxTVAPort=tva;


		String Art = "select * from "+base+".LIGNE_ABONNEMENT where Abonnement_Id="+Abonnement_Id;
		Statement stt5 = con.createStatement();
		ResultSet rset5 = stt5.executeQuery(Art);
		double totalHTTemp=0;
		double montant_tva=0;

		while (rset5.next()){
			double prix = rset5.getDouble("Prix");
			double tauxTVA = rset5.getDouble("Taux_TVA");
			double ristourne = rset5.getDouble("Ristourne");
			double quantite = rset5.getDouble("Quantite");

			double reduction = (1-(ristourne/100));
			double totalHTArticle = prix*quantite*reduction;
			if (nbJour>0)
				totalHTTemp+=totalHTArticle/perio*nbJour;
			else
				totalHTTemp+=totalHTArticle;

			montant_tva+=totalHTTemp*(tauxTVA/100);
		}

		double fraisPortRemises = this.Frais_Port;
		if (this.mRemiseFP!=0) {
			fraisPortRemises -= this.mRemiseFP;
			if (this.mRemiseFP<0) { this.mRemiseFP=0; }
		} else {
			fraisPortRemises = fraisPortRemises * (1 - this.pRemiseFP/100);
		}
		double total_ht = totalHTTemp * (1 - this.Remise/100) + fraisPortRemises;
		montant_tva = montant_tva * (1 - this.Remise/100) + fraisPortRemises * (this.TauxTVAPort/100);
		double montant_ttc = total_ht + montant_tva;

		if (total_ht<this.totalHT || nbJour==0)
			this.totalHT=total_ht;
		if (montant_ttc<this.MontantTTC || nbJour==0)
			this.MontantTTC=montant_ttc;
	}


	private void ajouterEcheance(int nbEcheance,long dateDebut,long dateFin, long dateGeneration, long dateEcheance, int nbJours, boolean rachat) throws SQLException {

		// vrifier que l'chance n'existe pas dj -> cas des reconductions tacites alors que la fin de la priode en cours n'est pas atteinte
		psExisteEcheance.setInt(1, this.Abonnement_Id);
		psExisteEcheance.setLong(2, dateDebut);
		psExisteEcheance.setLong(3, dateFin);
		ResultSet rset = psExisteEcheance.executeQuery();
		if (!rset.next()) {
			psCreerEcheance.setInt(1, nbEcheance);
			psCreerEcheance.setInt(2, this.Abonnement_Id);
			psCreerEcheance.setLong(3, dateDebut);
			psCreerEcheance.setLong(4, dateFin);
			psCreerEcheance.setLong(5, dateGeneration);
			if (nbEcheance <= this.nbPeriodeOfferte && !rachat){
				psCreerEcheance.setDouble(6, 0);
				psCreerEcheance.setDouble(7, 0);
			}
			else if (rachat){
				psCreerEcheance.setDouble(6, valeurHT);
				psCreerEcheance.setDouble(7, valeurTTC);
			}
			else {
				psCreerEcheance.setDouble(6, totalHT);
				psCreerEcheance.setDouble(7, MontantTTC);
			}
			psCreerEcheance.setLong(8, dateEcheance);
			psCreerEcheance.setInt(9, nbJours);
			if (rachat) psCreerEcheance.setString(10, "R");
			else psCreerEcheance.setString(10, "N");
	
			psCreerEcheance.addBatch();
		}
	}

} // fin generationEcheance
