/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/


package org.opensi.dbm.exercice;


import java.sql.*;

import org.opensi.api.*;

import org.opensi.data.exercice.Ecriture;
import org.opensi.data.exercice.Operation;


public class DBM_Ecriture implements DBM_Object {

	private Connection con;
	private String baseExo;


	public DBM_Ecriture(Connection con, String baseExo) {
	
		this.con = con;
		this.baseExo = baseExo;
	}
	
	
	public void insert(Ecriture ecriture) throws SQLException {
	
		PreparedStatement psNewEcr = con.prepareStatement("insert into "+ baseExo +".ECRITURE (Code_Journal, Date_Ecriture, Numero) values (?,?,?)", Statement.RETURN_GENERATED_KEYS);
			
		psNewEcr.setString(1, ecriture.getCodeJournal());
		psNewEcr.setLong(2, ecriture.getDateEcriture());
		psNewEcr.setInt(3, ecriture.getNumero());			
		psNewEcr.executeUpdate();

		ResultSet rsID = psNewEcr.getGeneratedKeys();
		rsID.next();
		ecriture.setEcritureId(rsID.getInt(1));
		rsID.close();
	}
	
	
	public void update(Ecriture ecriture) throws SQLException {
	
		PreparedStatement psUpEcr = con.prepareStatement("update "+ baseExo +".ECRITURE set Code_Journal=?, Date_Ecriture=?, Numero=? where Ecriture_Id=?");
				
		psUpEcr.setString(1, ecriture.getCodeJournal());
		psUpEcr.setLong(2, ecriture.getDateEcriture());
		psUpEcr.setInt(3, ecriture.getNumero());
		psUpEcr.setInt(4, ecriture.getEcritureId());
		psUpEcr.executeUpdate();
	}
	
	
	public void delete(int ecritureId) throws SQLException {
		
		PreparedStatement psSupEcr = con.prepareStatement("delete from "+ baseExo +".ECRITURE where Ecriture_Id=?");
			
		psSupEcr.setInt(1, ecritureId);
		psSupEcr.executeUpdate();
	}
	
	
	public Ecriture load(int ecritureId) throws SQLException {
	
		Ecriture ecriture = null;
		
		PreparedStatement psEcr = con.prepareStatement("select * from "+ baseExo +".ECRITURE where Ecriture_Id=?");

		psEcr.setInt(1, ecritureId);

		ResultSet rsE = psEcr.executeQuery();

		if (rsE.next()) {

			ecriture = new Ecriture();
			
			ecriture.setCodeJournal(rsE.getString("Code_Journal"));
			ecriture.setDateEcriture(rsE.getLong("Date_Ecriture"));
			ecriture.setEcritureId(ecritureId);
			ecriture.setNumero(rsE.getInt("Numero"));
		}
		rsE.close();

		return ecriture;
	}
	
	
	//  supprimer - obsolte
	public Ecriture loadWithOp(int ecritureId) throws SQLException {

		Ecriture ecriture = load(ecritureId);
		
		PreparedStatement psOps = con.prepareStatement("select Op_Id from "+ baseExo +".OPERATION where Ecriture_Id=? order by Num_Ligne");

		psOps.setInt(1, ecritureId);
		ResultSet rsO = psOps.executeQuery();
			
		DBM_Operation dbmOperation = new DBM_Operation(con, baseExo);

		while (rsO.next()) {

			Operation op = dbmOperation.load(rsO.getInt("Op_Id"));				
			ecriture.addOperation(op);
		}
		rsO.close();

		return ecriture;
	}
	
	
	public void validerPeriode(long periode) throws SQLException {
	
		PreparedStatement psVP = con.prepareStatement("update "+ baseExo +".ECRITURE set Etat='V' where Date_Ecriture=?");
		psVP.setLong(1, periode);
		psVP.executeUpdate();
		psVP.close();
	}
	
	
	public void setNumero(int ecritureId, int numero) throws SQLException {
		
		PreparedStatement psSetNum = con.prepareStatement("update "+ baseExo +".ECRITURE set Numero=? where Ecriture_Id=?");
		psSetNum.setInt(1, numero);
		psSetNum.setInt(2, ecritureId);
		psSetNum.executeUpdate();
		psSetNum.close();		
	}


} // fin DBM_Ecriture
