/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/


package org.opensi.data.exercice;


import org.opensi.util.tools.Arrondi;
import org.opensi.util.tools.DateTime;


public class Operation implements org.opensi.api.DataOSI {

  private long dateOp = 0;
  private int numLigne = 0;
  private String numeroCompte = "";
	private double montantD = 0;
	private double montantC = 0;
  private String libelle = "";
  private String numPiece = "";
  private String contrepartie = "";
	private long dateEcheance = 0;
	private String lettre = "";
  private int opId = 0;
	private int pointage = 0;
	private String commentaire = "";
	private int modeRegId = 0;
	private int ecritureId = 0;
	private int utilM = 0;
	private int utilC = 0;
	private long dateLettrage = 0;
	private long dateC = 0;
	private long dateM = 0;

	private Arrondi rd = new Arrondi(2);


  public Operation() {}


	public String getContrepartie()	{ return contrepartie; }
	public long getDateEcheance()	{ return dateEcheance; }
	public long getDateOp() {	return dateOp; }
	public String getLettre() { return lettre; }
	public String getLibelle() { return libelle; }
	public double getMontantD() { return rd.round(montantD); }
	public double getMontantC() { return rd.round(montantC); }
	public String getNumeroCompte()	{	return numeroCompte; }
	public int getNumLigne() { return numLigne;	}
	public String getNumPiece()	{	return numPiece; }
	public int getOpId() { return opId; }	
	public int getPointage() { return pointage; }	
	public String getCommentaire() { return commentaire; }	
	public int getModeRegId() { return modeRegId; }	
	public int getEcritureId() { return ecritureId; }


	public void setOpId(int OpId) { this.opId = OpId;	}
	public void setContrepartie(String contrepartie) { this.contrepartie = contrepartie; }
	public void setDateEcheance(long dateEcheance) { this.dateEcheance = dateEcheance; }
	public void setDateOp(long dateOp) { this.dateOp = normaliseDate(dateOp); }
	public void setLettre(String lettre) { this.lettre = lettre; }
	public void setLibelle(String libelle) { this.libelle = libelle; }
	public void setMontantD(double montantD) { this.montantD = rd.round(montantD); }
	public void setMontantC(double montantC) { this.montantC = rd.round(montantC); }
	public void setNumeroCompte(String numeroCompte) { this.numeroCompte = numeroCompte; }
	public void setNumLigne(int numLigne)	{ this.numLigne = numLigne; }
	public void setNumPiece(String numPiece) { this.numPiece = numPiece; }	
	public void setPointage(int pointage) { this.pointage = pointage; }
	public void setCommentaire(String commentaire) { this.commentaire = commentaire; }
	public void setModeRegId(int modeRegId) { this.modeRegId = modeRegId; }
	public void setEcritureId(int ecritureId) { this.ecritureId = ecritureId; }
	public void setDateLettrage(long dateLettrage) { this.dateLettrage = dateLettrage; }
	public void setDateC(long dateC) { this.dateC = dateC; }
	public void setDateM(long dateM) { this.dateM = dateM; }
	public void setUtilC(int utilC) { this.utilC = utilC; }
	public void setUtilM(int utilM) { this.utilM = utilM; }


	public void extourner() {
		
		double montantDTemp = this.montantD;
		this.montantD = rd.round(this.montantC);
		this.montantC = rd.round(montantDTemp);
	}


	public boolean isValid() {
    if (dateOp==0) {// || ecritureId==0) {
			printOperation();
      return false;
    }
    else if (numeroCompte==null || numeroCompte.equals("")) {
			printOperation();
      return false;
    }
    else if (montantD==0 && montantC==0) {
			printOperation();
      return false;
    }
		
    return true;
  }
	

  private long normaliseDate(long date) {
		
		return new DateTime(date).getDateInMillis();
	}	


	// pour debugger
	public void printOperation() {

		System.out.println("Numero compte =\t"+ this.numeroCompte);
		System.out.println("Libelle =\t"+ this.libelle);
		System.out.println("Montant_D =\t"+ this.montantD);
		System.out.println("Montant_C =\t"+ this.montantC);
	}


} // fin Operation
