/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/


package org.opensi.data.dossier;

import java.util.HashMap;

import org.opensi.data.dossier.Adresse;
import org.opensi.data.dossier.Contact;


public class BonLivraison implements org.opensi.api.DataOSI {
	
	
	private int bonId;
	private int numero;
	private String numEntier;
	private long dateLiv;
	private long dateC;
	private long dateM;
	private int utilC;
	private int utilM;
	private String commentairesFin;
	private String commentairesInt;
	private String commentairesHid;
	private String mentions;
	private int nbColis;
	private double fraisSup;
	private String etat;
	private String fournisseurId;
	private int comFournisseurId;
	private long dateDEB;
	private long dateEditionLot;
	private boolean editionBP;
	private Adresse adresseLiv;
	private Contact contactLiv;
	private int modeExpedition;
	private String statutExpedition;
	private boolean facture;
	private double totalHT;
	private double totalTTC;
	private HashMap<Integer, LigneBonLivraison> lignesBonLivraison;

	public BonLivraison(int bonId,
						int numero,
						String numEntier,
						long dateLiv,
						long dateC,
						long dateM,
						int utilC,
						int utilM,
						String commentairesFin,
						String commentairesInt,
						String commentairesHid,
						String mentions,
						int nbColis,
						double fraisSup,
						String etat,
						String fournisseurId,
						int comFournisseurId,
						long dateDEB,
						long dateEditionLot,
						boolean editionBP,
						Adresse adresseLiv,
						Contact contactLiv,
						int modeExpedition,
						boolean facture,
						double totalHT,
						double totalTTC) {
		
		this.bonId = bonId;
		this.numero = numero;
		this.numEntier = numEntier;
		this.dateLiv = dateLiv;
		this.dateC = dateC;
		this.dateM = dateM;
		this.utilC = utilC;
		this.utilM = utilM;
		this.commentairesFin = commentairesFin;
		this.commentairesInt = commentairesInt;
		this.commentairesHid = commentairesHid;
		this.mentions = mentions;
		this.nbColis = nbColis;
		this.fraisSup = fraisSup;
		this.etat = etat;
		this.fournisseurId = fournisseurId;
		this.comFournisseurId = comFournisseurId;
		this.dateDEB = dateDEB;
		this.dateEditionLot = dateEditionLot;
		this.editionBP = editionBP;
		this.adresseLiv = adresseLiv;
		this.contactLiv = contactLiv;
		this.modeExpedition = modeExpedition;
		this.facture = facture;
		this.totalHT = totalHT;
		this.totalTTC = totalTTC;
	}
	
	
	public boolean isValid() {
	
		return true;
	}
	
	
	public void addLigne(int ligneId, LigneBonLivraison ligneBonLivraison) { this.lignesBonLivraison.put(ligneId, ligneBonLivraison); }
	
	public int getBonId() { return bonId; }
	public int getNumero() { return numero; }
	public String getNumEntier() { return numEntier; }
	public long getDateLiv() { return dateLiv; }
	public long getDateC() { return dateC; }
	public long getDateM() { return dateM; }
	public int getUtilC() { return utilC; }
	public int getUtilM() { return utilM; }
	public String getCommentairesFin() { return commentairesFin; }
	public String getCommentairesInt() { return commentairesInt; }
	public String getCommentairesHid() { return commentairesHid; }
	public String getMentions() { return mentions; }
	public int getNbColis() { return nbColis; }
	public double getFraisSup() { return fraisSup; }
	public String getEtat() { return etat; }
	public String getFournisseurId() { return fournisseurId; }
	public int getComFournisseurId() { return comFournisseurId; }
	public long getDateDEB() { return dateDEB; }
	public long getDateEditionLot() { return dateEditionLot; }
	public boolean getEditionBP() { return editionBP; }
	public Adresse getAdresseLiv() { return adresseLiv; }
	public Contact getContactLiv() { return contactLiv; }
	public int getModeExpedition() { return modeExpedition; }
	public String getStatutExpedition() { return statutExpedition; }
	public boolean getFacture() {return facture; }
	public double getTotalHT() { return totalHT; }
	public double getTotalTTC() { return totalTTC; }
	public HashMap<Integer, LigneBonLivraison> getLignesBonLivraison() { return lignesBonLivraison; }
	

} // fin BonLivraison
