/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 *   Import de donnes comptables Quadra
 */

package org.opensi.compta.actions.transferts;


import java.io.BufferedReader;
import java.io.FileReader;

import org.opensi.util.tools.DateTime;

import org.opensi.data.exercice.Ecriture;
import org.opensi.data.exercice.Operation;
import org.opensi.data.dossier.Compte;

import org.opensi.api.SessionOSI;


public class ImportQuadra extends ImportCompta {


	public ImportQuadra(SessionOSI sosi, String base, String fichierImport, String journal) {

		super(sosi, base, fichierImport, journal);
	}


	public void importer() throws Exception {


		Ecriture currentEcr = null;
		int currentSum = 0;
		int currentLine = 0;

		FileReader fr = new FileReader(fichier);

		BufferedReader br = new BufferedReader(fr);


		while (br.ready()) {

			String line = br.readLine();
			cc.incLine();
			currentLine++;

			if (line.startsWith("C")) {
				String type = line.substring(217, 218);
				String intitule = line.substring(9, 39);
				String numero = line.substring(1, 9);
				String collectif = line.substring(98, 106).trim();

				cc.checkIntituleCompte(intitule);

				if (cc.checkTypeCompte(type)) {
					cc.checkNumeroCompte(numero, type);
				}
			
				Compte compte = new Compte();
				compte.setNumeroCompte(numero);
				compte.setIntitule(intitule);
				compte.setTypeCompte(type);
				if (!collectif.isEmpty()) {
					compte.setCollectif(collectif);
				}
				if (!type.equalsIgnoreCase("G") && !collectif.startsWith("411") && !collectif.startsWith("401")) {
					compte.setTypeCompte("A");
				}

				comptes.put(numero.toLowerCase(), compte);
			}

			else if (line.startsWith("M")) {

				if (currentSum==0) {

					// String codeJournal = line.substring(9, 12).trim();
					String codeJournal = line.substring(110, 113).trim();
					long dateEcriture = DateTime.parseDate(line.substring(16, 20), "MMyy");
					// souci des a nouveaux
					if (dateEcriture<debutExercice) {
						dateEcriture = periodeDebutExercice;
					}

					cc.checkCodeJournal(codeJournal);
					cc.checkPeriode(dateEcriture);

					currentEcr = new Ecriture();
					currentEcr.setCodeJournal(codeJournal);
					currentEcr.setDateEcriture(dateEcriture);

					ecritures.addEcriture(currentEcr);
				}


				long dateOp = DateTime.parseDate(line.substring(14, 20),"ddMMyy");
				String libelle = line.substring(21, 41).trim();
				String numeroCompte = line.substring(1, 9);
				int montantD = 0;
				int montantC = 0;
				String numPiece = line.substring(148, 158).trim();
				long dateEcheance = 0;

				if (!line.substring(63, 69).equals("000000")) {
					dateEcheance = DateTime.parseDate(line.substring(63, 69),"ddMMyy");
				}
				String lettre = line.substring(69, 74).trim();

				if (line.substring(41, 43).equalsIgnoreCase("C+") || line.substring(41, 43).equalsIgnoreCase("D-")) {
					montantC = Integer.parseInt(line.substring(43, 55).trim());
					cc.checkMontantOp(montantC);
				}
				else {
					montantD = Integer.parseInt(line.substring(43, 55).trim());
					cc.checkMontantOp(montantD);
				}

				currentSum += montantD - montantC;


				cc.checkDateOp(dateOp);
				cc.checkLibelleOp(libelle);
				cc.checkNumeroCompte(numeroCompte);
				
				Operation op = new Operation();
				op.setDateOp(dateOp);
				op.setLibelle(libelle);
				op.setNumeroCompte(numeroCompte);
				op.setMontantD((double) montantD/100);
				op.setMontantC((double) montantC/100);
				op.setNumPiece(numPiece);
				op.setDateEcheance(dateEcheance);
				op.setLettre(lettre);
			
				currentEcr.addOperation(op);
			}
		}

		br.close();
	}


} // fin ImportQuadra



