/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/
  
/**
 *  Cre le tableau en Ooo
 */

package org.opensi.compta.actions.tableauDeBord;

import java.io.File;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;

import org.experlog.openeas.api.Action;
import org.experlog.openeas.api.ServletRequest;
import org.experlog.openeas.api.Session;
import org.opensi.util.openoffice.CreateurOpenOffice;
import org.opensi.util.openoffice.OooCellule;
import org.opensi.util.openoffice.OooLigne;
import org.opensi.util.openoffice.OooStyleCellule;
import org.opensi.util.tools.DateTime;


public class exportTableauVersOoo extends Action {

	String chemin;
	String nomFichier;
	int nbMois, decalage;
	int dureeExo;
	int anneeDebut;
	String baseDossier;
	
	String listeParam;
	String[] touteLaListe;
	String[] listeCompte;
	String[] listeValeur;
	String[] listeDate;
	int nbLignes;
	
	ResultSet resultatReq;
	Connection con;
	Vector<OooLigne> lesLignes;
	CreateurOpenOffice zeus;
	String titre;
	
	OooStyleCellule titreStyle, caseStyle, titreNombreStyle;
	
  public boolean serverSide() { return true; }

  public boolean service(Session s, ServletRequest r, Object info) throws Exception {
	
		chemin = s.getAppConfiguration().get("opensi.absdir") ;
		con = s.getConnection(null);
		
		baseDossier=s.getCookie().get("BaseDossier");
		
		listeParam=r.getParameter("Liste");
		String choix=r.getParameter("Choix");
		nomFichier=r.getParameter("fichierSxc");
		anneeDebut=Integer.parseInt(r.getParameter("AnneeDebut"));
		nbMois=Integer.parseInt(r.getParameter("nbMois"));
		dureeExo=Integer.parseInt(r.getParameter("dureeExo"));
		decalage=Integer.parseInt(r.getParameter("decalage"));
		
		zeus=new CreateurOpenOffice(chemin+"/openoffice");

		if (!listeParam.equals("")) {
			separerLaListe();		
		}
		
		requete(r, choix.charAt(0));
		genererOoo();	
		
		return true;	
	}
	
	
	

	
	public void requete( ServletRequest r, char choix) throws Exception	{
	
		String base=r.getParameter("BaseBD");

		String requete="select c.Intitule as lib, SUM(o.Montant_D) as debit, SUM(o.Montant_C) as credit, c.Numero_Compte as numero";
		requete+=" from "+baseDossier+".COMPTE c, "+base+".OPERATION o";
		requete+=" where c.Numero_Compte=o.Numero_Compte and (";

	
	
	conditionsComptes condition=new conditionsComptes();
	
	// voyons voir dans quel cas nous sommes...
	switch (choix)
	{
		case 'P':
				titre="Charges de personnel";
				requete+=" "+condition.chargesDePersonnel("c.")+" ";
				break;		
			case 'E':
				titre="Charges externes";
			requete+=" "+condition.chargesExternes("c.")+" ";
				break;
		
			case 'F':
				titre="Charges financires";
				requete+=" "+condition.chargesFinancieres("c.")+" ";
				break;

			case 'A':
				titre="Amortissements";
				requete+=" "+condition.amortissements("c.")+" ";
				break;

			case 'I':
				titre="Impts et autres taxes";
				requete+=" "+condition.impotsEtTaxes("c.")+" ";
				break;
		default: 
			//TODO: Implement 'default' statement
			break;
	}

	
	requete+=" ) group by c.Numero_Compte";
	
	
	
		Statement stt1 = con.createStatement();
		resultatReq=stt1.executeQuery(requete);
	}
	
	
	
	
	
	
	/* *************** GENERATION Ooo ************************ */
	
	public void genererOoo() throws SQLException {


		creerLesStyles();
		creerLignes();
		genererEntete();
		
		for(int q=0; q<lesLignes.size();q++)
		{

			zeus.ajouterLigne(lesLignes.elementAt(q));
		}

		
		zeus.changerLargeurColonne(0,6.0f);
		
		
		File fichier=zeus.genererDocument(nomFichier);
		fichier.deleteOnExit();
		
	}
	
	
	
	/**
	* Ecris les deux lignes d'entte
	**/
	public void genererEntete()
	{
	
	
	
		OooLigne ligneEnTete=new OooLigne(zeus.getStyleLigneParDefaut());
		OooCellule truc;

		//*************** 1re ligne ******************
		for (int h=0; h<2; h++)
		{
			//espacement, au dessus du tableau de gauche
			truc=new OooCellule("", zeus.getStyleCelluleParDefaut());
			ligneEnTete.ajouterCellule(truc);
		}
		

		for (int g=0; g<nbMois;g++)
		{
			//espacement
			truc=new OooCellule("", zeus.getStyleCelluleParDefaut());
			ligneEnTete.ajouterCellule(truc);
			
			int mois12=((g+decalage)%12)+1;
			
			truc=new OooCellule(leMois(mois12), titreStyle);
			truc.setFusion(1, 3);
			ligneEnTete.ajouterCellule(truc);
	
		}
		zeus.ajouterLigne(ligneEnTete);

		// ********** 2me ligne ***************
		ligneEnTete=new OooLigne(zeus.getStyleLigneParDefaut());

		//tableau de gauche:
		truc=new OooCellule(titre, titreStyle);
		truc.setFusion(1, 2);
		ligneEnTete.ajouterCellule(truc);
		for (int g=0; g<nbMois;g++)
		{
			//espacement
			truc=new OooCellule("", zeus.getStyleCelluleParDefaut());
			ligneEnTete.ajouterCellule(truc);

			truc=new OooCellule("Prev", titreStyle);
			ligneEnTete.ajouterCellule(truc);
			
			truc=new OooCellule("Actu", titreStyle);
			ligneEnTete.ajouterCellule(truc);
			
			truc=new OooCellule("Retenu", titreStyle);
			ligneEnTete.ajouterCellule(truc);
			
	
		}

		zeus.ajouterLigne(ligneEnTete);

	}
	
	
	
	
	
	public void creerLignes() throws SQLException	{
		
		

			/* ***************** Les lignes de soldes *************** */
			lesLignes = new Vector<OooLigne>();
			resultatReq.beforeFirst();
			OooCellule celLib, celSolde, celMoisCourant;
			int sommeSolde=0;
			String compte;
			
			int[] totalRetenuMois=new int[nbMois];
			int[] totalActuMois=new int[nbMois];
			int[] totalPrevMois=new int[nbMois];
			for (int b=0; b<nbMois;b++){totalRetenuMois[b]=0;totalActuMois[b]=0;totalPrevMois[b]=0;}
			
			
			while (resultatReq.next()) 	{

				OooLigne ligneCourante=new OooLigne(zeus.getStyleLigneParDefaut());


				celLib =new OooCellule(resultatReq.getString("lib") ,caseStyle);
				ligneCourante.ajouterCellule(celLib);
				long solde=(long)(resultatReq.getDouble("debit")-resultatReq.getDouble("credit"));
				celSolde=new OooCellule(solde ,caseStyle);
				ligneCourante.ajouterCellule(celSolde);
				
				sommeSolde+=solde;
				int soldeMoisRef=(int)(solde/nbMois);
				int soldeMois=soldeMoisRef;
				int soldeActu=0;
				boolean actu;
				compte=resultatReq.getString("numero");
				
				for (int i=1; i<=nbMois; i++)
				{

					
					//espace
					ligneCourante.ajouterCellule(new OooCellule("",zeus.getStyleCelluleParDefaut()));

					//prev
					celMoisCourant=new OooCellule(soldeMois,caseStyle);
					totalPrevMois[i-1]+=soldeMois;
					
					ligneCourante.ajouterCellule(celMoisCourant);
					
					
					//Pour vois si il y a une valeur dans actu
					int mois=((i+decalage)%12);
					int anneeAdd=i/12;
					soldeMois=soldeMoisRef;
					soldeActu=0;
					actu=false;
					
					Integer buz=soldeActuExiste(compte,mois, (anneeDebut+anneeAdd));
					if (buz!=null) {
						soldeMois=buz.intValue();
						soldeActu=soldeMois;
						actu=true;
						totalActuMois[i-1]+=soldeActu;
					}
				
					//actu
					if(actu)celMoisCourant=new OooCellule(soldeActu,caseStyle);
					else celMoisCourant=new OooCellule("",caseStyle);
					ligneCourante.ajouterCellule(celMoisCourant);
					
					//retenu
					celMoisCourant=new OooCellule(soldeMois,caseStyle);
					ligneCourante.ajouterCellule(celMoisCourant);
					totalRetenuMois[i-1]+=soldeMois;
				}
				
				lesLignes.addElement(ligneCourante);
			
				
			}	
			
			/* ***************** deux lignes ditables *********************** */
			
			for(int o=0; o<2; o++)
			{
					OooLigne ligneCourante=new OooLigne(zeus.getStyleLigneParDefaut());
						celLib =new OooCellule("" ,caseStyle);
						ligneCourante.ajouterCellule(celLib);


						celSolde=new OooCellule("" ,caseStyle);
						ligneCourante.ajouterCellule(celSolde);

						for (int i=1; i<=nbMois; i++)
						{
							//espace
							ligneCourante.ajouterCellule(new OooCellule("",zeus.getStyleCelluleParDefaut()));

							//prev
							celMoisCourant=new OooCellule(0,caseStyle);
							ligneCourante.ajouterCellule(celMoisCourant);

					
							//actu
							celMoisCourant=new OooCellule("",caseStyle);
							ligneCourante.ajouterCellule(celMoisCourant);

							//retenu
							celMoisCourant=new OooCellule(0,caseStyle);
							ligneCourante.ajouterCellule(celMoisCourant);

					}
					lesLignes.addElement(ligneCourante);
			}
			
			/* ******************* ligne de total ****************** */
		
			OooLigne ligneCourante=new OooLigne(zeus.getStyleLigneParDefaut());

				celLib =new OooCellule("Total "+titre ,titreStyle);
				ligneCourante.ajouterCellule(celLib);
			
				celSolde=new OooCellule(sommeSolde ,titreNombreStyle);
				ligneCourante.ajouterCellule(celSolde);
				
				
				for (int i=1; i<=nbMois; i++)
				{
					//espace
					ligneCourante.ajouterCellule(new OooCellule("",zeus.getStyleCelluleParDefaut()));
					
					//prev
					celMoisCourant=new OooCellule(totalPrevMois[i-1],titreNombreStyle);
					ligneCourante.ajouterCellule(celMoisCourant);
					
					
					
					//actu
					celMoisCourant=new OooCellule(totalActuMois[i-1],titreNombreStyle);
					ligneCourante.ajouterCellule(celMoisCourant);
					
					//retenu
					celMoisCourant=new OooCellule(totalRetenuMois[i-1],titreNombreStyle);
					ligneCourante.ajouterCellule(celMoisCourant);
			
			}
			lesLignes.addElement(ligneCourante);
		
	}
	
	
	public void creerLesStyles()
	{
		
		titreStyle=zeus.creerNewStyleCellule();
		titreStyle.setGras(true); 
		titreStyle.setCouleurFond("#FCD9AF");
		titreStyle.setBordure(true);
		titreStyle.setAlignement(OooStyleCellule.H_CENTRE,OooStyleCellule.V_MILIEU);
		titreStyle.setFormatNombre(OooStyleCellule.FORMAT_NOMBRE_ENTIER);
		
		titreNombreStyle=zeus.creerNewStyleCellule();
		titreNombreStyle.setGras(true); 
		titreNombreStyle.setCouleurFond("#FCD9AF");
		titreNombreStyle.setBordure(true);
		titreNombreStyle.setFormatNombre(OooStyleCellule.FORMAT_NOMBRE_ENTIER);
		
		caseStyle=zeus.creerNewStyleCellule();
		caseStyle.setBordure(true);
		caseStyle.setFormatNombre(OooStyleCellule.FORMAT_NOMBRE_ENTIER);
		
	}
	
	
	
	/**
	* Cre  partir de la liste donne en paramtre HTTP trois tableaux contenant les compte, les date et les libells
	**/ 
	public void separerLaListe()
	{
		
				
				//on enlve la premire ','
				listeParam=listeParam.substring(1);
				 
				touteLaListe=listeParam.split(",",0);
			
				nbLignes=touteLaListe.length/3;

				listeCompte=new String[nbLignes];
				listeValeur=new String[nbLignes];
				listeDate=new String[nbLignes];

				for (int i=0; i<nbLignes; i++)
				{

					listeCompte[i]=touteLaListe[i*3];
					listeDate[i]=touteLaListe[i*3+1];
					listeValeur[i]=touteLaListe[i*3+2];
					
				}
	
	}

	
	
	
	/**
	* Retourne la valeur du solde actuel si ce dernier existe, null sinon
	**/
	public Integer soldeActuExiste(String numCompte, int mois, int annee)
	{
		
		DateTime courant;
		Integer result=null;
		
		boolean continuer=true;
		int m=0;

		
		while (continuer && m<nbLignes)
		{
			
			if (listeCompte[m].equalsIgnoreCase(numCompte)) 
			
			{ courant=new DateTime(Long.parseLong(listeDate[m]));
				if (mois==courant.getMonth() && annee==courant.getYear()) 
				
				{ //trouv
					result=new Integer(listeValeur[m]);
					continuer=false; 
				} 
			}

			m++;
		}
	
		return result;
	
	}

	
	public String leMois(int lemois)
	{
		String resultat="";
		
		switch (lemois)
		{
			case 1: resultat="Janvier";break;
			case 2: resultat="Fvrier";break;
			case 3: resultat="Mars";break;
			case 4: resultat="Avril";break;
			case 5: resultat="Mai";break;
			case 6: resultat="Juin";break;
			case 7: resultat="Juillet";break;
			case 8: resultat="Aout";break;
			case 9: resultat="Septembre";break;
			case 10: resultat="Octobre";break;
			case 11: resultat="Novembre";break;
			case 12: resultat="Dcembre";break;
			default: resultat="";
		
		}
		
		return resultat;
	}


	
	
}



		
			
			










