package org.opensi.compta.actions.rapprochementBancaire;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

public class CollectLigneRappro {
	private int  rapproId=0;
	private long dateRappro;//date dbut
	private long dateCloture;//date clture
	private String compte;
	private long dateReleve;//date fin	
	private ArrayList<String> listop = new ArrayList<String>();
	private Connection con;
	private String base;
	private String baseDossier;
	private double solde=0;
	private double soldenonppointe=0;
	private double totcredit=0;
	private double totdebit=0;
	private double soldeAN=0;
	private String typeRappro="";
	private String codeJournal;
	
    public CollectLigneRappro(int Rappro_Id, Connection con, String base, String  baseDossier) {
    	this.rapproId = Rappro_Id;
    	this.con=con;
		this.base=base;
		this.baseDossier=baseDossier;
	}
    public String getType_Rappro() {
    	return typeRappro;
    }
    public void setType_Rappro(String type_Rappro) {
    	typeRappro = type_Rappro;
    }
    public String getCode_journal() {
    	return codeJournal;
    }
    public void setCode_journal(String code_journal) {
    	codeJournal = code_journal;
    }
    public long getdateCloture() {
		return dateCloture;
	}
	public void setdateCloture(long dateCloture) {
		this.dateCloture = dateCloture;
	}
	public long getDateRappro() {
		return dateRappro;
	}
	public void setDateRappro(long dateRappro) {
		this.dateRappro = dateRappro;
	}
	
	public long getDateReleve() {
		return dateReleve;
	}
	public void setDateReleve(long dateReleve) {
		this.dateReleve = dateReleve;
	}
	public double getSolde() {
		return solde;
	}
	public void setSolde(double solde) {
		this.solde = solde;
	}
	public double getTotcredit() {
		return totcredit;
	}
	public void setTotcredit(double totcredit) {
		this.totcredit = totcredit;
	}
	public double getTotdebit() {
		return totdebit;
	}
	public void setTotdebit(double totdebit) {
		this.totdebit = totdebit;
	}
	public double getSoldenonppointe() {
		return soldenonppointe;
	}
	public void setSoldenonppointe(double soldenonppointe) {
		this.soldenonppointe = soldenonppointe;
	}
	public double getSoldeAN() {
		return soldeAN;
	}
	public void setSoldeAN(double soldeAN) {
		this.soldeAN = soldeAN;
	}
	//creer les lignes dans la table LIGNE_RAPPROCHEMENT lors de la clture d'un rapprochement
    public void CreateLignesRapproCompte(Connection con, String nombase) {	
	 PreparedStatement pstmt = null;
	 PreparedStatement pstmt2 = null;
	 PreparedStatement pstmt3 = null;
	 PreparedStatement pstmt4 = null;
	 try {
		 String INSERT_LIGNES_RAPPRO =
		 "INSERT INTO " + baseDossier +".LIGNE_RAPPROCHEMENT ( Op_Id,Rappro_Id,Pointage, Nom_Base) select distinct o.Op_Id, ?,o.Pointage, ? from  " + nombase +".OPERATION o, "+ nombase +".ECRITURE e,"+ baseDossier +".JOURNAL j WHERE e.Ecriture_Id=o.Ecriture_Id and e.Code_Journal=j.Code_Journal and j.Type_Journal <>'AN' and Date_Op BETWEEN ? and ? and Numero_Compte= ?";
		 
		 pstmt = con.prepareStatement(INSERT_LIGNES_RAPPRO);   	 
		 pstmt.setLong(1, rapproId);
		 pstmt.setString(2, nombase);
		 pstmt.setLong(3, dateRappro);
		 pstmt.setLong(4, dateCloture);
		 pstmt.setString(5, compte);
		 pstmt.executeUpdate();
		 
		 String DATES_RAPPRO_PRECEDENT =
	    	 "select max(Rappro_Id) from  "+ baseDossier +".RAPPROCHEMENT where Numero_Compte=? and Date_Rappro < ?";
	     pstmt2 = con.prepareStatement(DATES_RAPPRO_PRECEDENT);
	     pstmt2.setString(1, compte);   
	     pstmt2.setLong(2, dateRappro);
	     
	     ResultSet rs2 = pstmt2.executeQuery();
		     if (rs2.next()){
		    	 String LISTE_OP_A_AJOUTER =					
		    		 "INSERT INTO " +  baseDossier +".LIGNE_RAPPROCHEMENT ( Op_Id,Rappro_Id,Pointage, Nom_Base) select distinct o.Op_Id, ? ,o.Pointage, ? from  " + nombase +".OPERATION o, "+ baseDossier +".LIGNE_RAPPROCHEMENT lr WHERE o.Op_Id=lr.Op_Id AND lr.Nom_Base='"+nombase+"' and lr.Rappro_Id=? and lr.Pointage=0 ";
		    	 pstmt3 = con.prepareStatement(LISTE_OP_A_AJOUTER);  		    	
		    	 pstmt3.setLong(1, rapproId); 
		    	 pstmt3.setString(2, nombase);
				 pstmt3.setLong(3, rs2.getLong(1));
				 pstmt3.executeUpdate();
	        }
		     //liste des operations qui ont t rajoutes dans les priodes prcedentes
		     String LISTE_OP_AJOUTEES =
		    	 "INSERT INTO " +  baseDossier +".LIGNE_RAPPROCHEMENT ( Op_Id,Rappro_Id,Pointage, Nom_Base) select o.Op_Id, ? ,o.Pointage, ? from "  + nombase +".OPERATION o LEFT JOIN "+ baseDossier +".LIGNE_RAPPROCHEMENT lr ON o.Op_Id=lr.Op_Id AND lr.Nom_Base='"+nombase+"', "+ nombase +".ECRITURE e,"+ baseDossier +".JOURNAL j WHERE lr.Op_Id IS NULL  AND e.Ecriture_Id=o.Ecriture_Id and e.Code_Journal=j.Code_Journal and j.Type_Journal <>'AN' and  Numero_Compte=? and o.Date_Op < ?";
		     pstmt4 = con.prepareStatement(LISTE_OP_AJOUTEES);
		     pstmt4.setLong(1, rapproId);
		     pstmt4.setString(2, nombase);
		     pstmt4.setString(3, compte);
		     pstmt4.setLong(4, dateRappro);
		     pstmt4.executeUpdate();
		    
		  rs2.close();
	 }
	 
	 catch (SQLException sqle) {
	    	
	    	sqle.printStackTrace();
	    }
    }
    public void CreateLignesRapproJournaux(Connection con, String nombase) {
    	
   	 PreparedStatement pstmt = null;
   	 PreparedStatement pstmt2 = null;
   	 PreparedStatement pstmt3 = null; 
   	 PreparedStatement pstmt4 = null; 
   	 																													
	   	 try {
		   	 String INSERT_LIGNES_RAPPRO =
		   	 "INSERT INTO " +  baseDossier  +".LIGNE_RAPPROCHEMENT ( Op_Id,Rappro_Id,Pointage,Nom_Base) select distinct o.Op_Id, ?,o.Pointage, ? from  " + nombase +".OPERATION o, " + nombase +".ECRITURE e where o.Ecriture_Id=e.Ecriture_Id and o.Date_Op BETWEEN ? and ? and e.Code_Journal= ?";
		     pstmt = con.prepareStatement(INSERT_LIGNES_RAPPRO);   	 
		   	 pstmt.setLong(1, rapproId); 
		   	 pstmt.setString(2, nombase);
		   	 pstmt.setLong(3, dateRappro);
		   	 pstmt.setLong(4, dateCloture);
		   	 pstmt.setString(5, codeJournal);	
		   	 pstmt.executeUpdate();
			 String DATES_RAPPRO_PRECEDENT =
		    	 "select max(Rappro_Id) from  "+ baseDossier +".RAPPROCHEMENT where Code_Journal=? and Date_Rappro < ?";
		     pstmt2 = con.prepareStatement(DATES_RAPPRO_PRECEDENT);
		     pstmt2.setString(1, codeJournal);   
		     pstmt2.setLong(2, dateRappro);
		     
		     ResultSet rs2 = pstmt2.executeQuery();
			     if (rs2.next()){
			    	 String LISTE_OP_A_AJOUTER =					
			    		 "INSERT INTO " +  baseDossier  +".LIGNE_RAPPROCHEMENT ( Op_Id,Rappro_Id,Pointage,Nom_Base) select distinct o.Op_Id, ? ,o.Pointage, ? from  " + nombase +".OPERATION o, "+ baseDossier +".LIGNE_RAPPROCHEMENT lr WHERE o.Op_Id=lr.Op_Id and lr.Rappro_Id=? and lr.Pointage=0 ";
			    	 pstmt3 = con.prepareStatement(LISTE_OP_A_AJOUTER);  
			    	 pstmt3.setLong(1, rapproId);
			    	 pstmt3.setString(2, nombase);
					 pstmt3.setLong(3, rs2.getLong(1));
					 pstmt3.executeUpdate();
					
						  
					
			        }
			     rs2.close();
			     //liste des operations qui ont t rajoutes dans les priodes prcedentes
			     String LISTE_OP_AJOUTEES =
			    	 "INSERT INTO " +  baseDossier +".LIGNE_RAPPROCHEMENT ( Op_Id,Rappro_Id,Pointage, Nom_Base) select o.Op_Id, ? ,o.Pointage, ? from " + nombase +".OPERATION o LEFT JOIN "+ baseDossier +".LIGNE_RAPPROCHEMENT lr ON o.Op_Id=lr.Op_Id AND lr.Nom_Base='"+base+"', "+ nombase +".ECRITURE e WHERE lr.Op_Id IS NULL  AND e.Ecriture_Id=o.Ecriture_Id and e.Code_journal=? and o.Date_Op < ?";
			     pstmt4 = con.prepareStatement(LISTE_OP_AJOUTEES);
			     pstmt4.setLong(1, rapproId); 
			   	 pstmt4.setString(2, nombase);
			   	 pstmt4.setString(3, codeJournal);
			   	 pstmt4.setLong(4, dateRappro);			  

			     pstmt4.executeUpdate();
			  		    
	   	 }
	   	 
	   	 catch (SQLException sqle) {	   	    
	   	    	sqle.printStackTrace();
	   	    }
       }
	 public void DeleteLignesRappro(Connection con, String base) {
		 PreparedStatement pstmt = null;
		 try {
			 String DELETE_LIGNES_RAPPRO =
			 "DELETE FROM " + baseDossier  +".LIGNE_RAPPROCHEMENT where Rappro_Id=?";			
		     pstmt = con.prepareStatement(DELETE_LIGNES_RAPPRO);   	 
			 pstmt.setLong(1, rapproId); 
			 pstmt.executeUpdate();		  
		 }
		 
		 catch (SQLException sqle) {		    
		    	sqle.printStackTrace();
		    }
	 	}
	 
	 public ArrayList<String> getlisteOpcompte() {
		 PreparedStatement pstmt = null;
		 PreparedStatement pstmt2 = null;
		 PreparedStatement pstmt3 = null;
		 PreparedStatement pstmt4 = null;
		 listop.clear();
		 double totdebit=0.0;
		 double totcredit=0.0;
		 try {
			
			 if (dateCloture==0){
		
				String LISTE_OP =					
					  "SELECT distinct o.Op_Id, o.Montant_D, o.Montant_C from " + base +".OPERATION o, "+ base +".ECRITURE e,"+ baseDossier +".JOURNAL j WHERE e.Ecriture_Id=o.Ecriture_Id and e.Code_Journal=j.Code_Journal and j.Type_Journal <>'AN' and  Numero_Compte=? and o.Date_Op BETWEEN ? and ?";
					
				 pstmt = con.prepareStatement(LISTE_OP);    				 
			     pstmt.setString(1, compte);				
			     pstmt.setLong(2, dateRappro);			 
			     pstmt.setLong(3, dateReleve);					   
			     ResultSet rs = pstmt.executeQuery();			   
				     while (rs.next()) {	
				    	 String op = rs.getString(1);	
				    	 double debit = rs.getDouble(2);
				    	 double credit= rs.getDouble(3);
				    	 totdebit += debit;
				    	 totcredit += credit;
				    	 listop.add(op);
				    
				    } 				
			     String DATES_RAPPRO_PRECEDENT =
			    	 "select max(Date_rappro) as dra , Max(Date_Releve) as dr from  "+ baseDossier +".RAPPROCHEMENT where Numero_Compte=? and Date_Rappro < ?";
			     pstmt2 = con.prepareStatement(DATES_RAPPRO_PRECEDENT);
			     pstmt2.setString(1, compte);   
			     pstmt2.setLong(2, dateRappro);
			     
			     ResultSet rs2 = pstmt2.executeQuery();
				     if (rs2.next()){
				    	 String LISTE_OP_A_AJOUTER =					
						        "SELECT distinct lr.Op_Id from " + baseDossier +".LIGNE_RAPPROCHEMENT lr, "+ baseDossier +".RAPPROCHEMENT r WHERE r.Rappro_Id=lr.Rappro_id and Numero_Compte=? and lr.Pointage=0 and r.Date_Rappro BETWEEN ? and ? and lr.Nom_Base=? and lr.Op_Id not in (select distinct Op_Id from " + baseDossier +".LIGNE_RAPPROCHEMENT where Pointage=1 and Nom_Base=?)";
				    	 pstmt3 = con.prepareStatement(LISTE_OP_A_AJOUTER);  
				    	 pstmt3.setString(1, compte);   
						 pstmt3.setLong(2, rs2.getLong(1));
						 pstmt3.setLong(3, rs2.getLong(2));	
						 pstmt3.setString(4, base);							
						 pstmt3.setString(5, base);							
						 ResultSet rs3 = pstmt3.executeQuery();
							    while (rs3.next()) {	
							    	 String op = rs3.getString(1);			    	 
							    	 listop.add(op);							    
							     }								  
						 rs3.close();
				        }
				     //liste des operations qui ont t rajoutes dans les priodes prcedentes
				     String LISTE_OP_AJOUTEES =
				    	 "select o.Op_Id, o.Montant_D, o.Montant_C from " + base +".OPERATION o LEFT JOIN "+ baseDossier +".LIGNE_RAPPROCHEMENT lr ON o.Op_Id=lr.Op_Id AND lr.Nom_Base='"+base+"', "+ base +".ECRITURE e,"+ baseDossier +".JOURNAL j WHERE lr.Op_Id IS NULL  AND e.Ecriture_Id=o.Ecriture_Id and e.Code_Journal=j.Code_Journal and j.Type_Journal <>'AN' and  Numero_Compte=? and o.Date_Op < ?";
				     pstmt4 = con.prepareStatement(LISTE_OP_AJOUTEES);
				     pstmt4.setString(1, compte);   
				     pstmt4.setLong(2, dateRappro);
				    
				     ResultSet rs4 = pstmt4.executeQuery();
					     if (rs4.next()){
					    	 String op = rs4.getString(1);		
					    	 listop.add(op); 
					     }
				  rs.close();
				  rs2.close();
				  rs4.close();
				 }
			 //liste des operations d'un rapprochement clotur
			 else {
					 String LISTE_OP =					
						        "SELECT distinct Op_Id from " + baseDossier +".LIGNE_RAPPROCHEMENT WHERE Rappro_Id=? and Nom_Base=?";
				     pstmt = con.prepareStatement(LISTE_OP);      		 
				     pstmt.setInt(1, rapproId);  
				     pstmt.setString(2, base); 
				     ResultSet rs = pstmt.executeQuery();
					     while (rs.next()) {	
					    	 String op = rs.getString(1);		    	 
					    	 listop.add(op);
					     }					 				    	
					 }
			
		 }		 
		 catch (SQLException sqle) {
			 sqle.printStackTrace();
		    }
		return listop;
		}
	
	 public ArrayList<String> getlisteOpjournaux() {
		 PreparedStatement pstmt = null;
		 PreparedStatement pstmt2 = null;
		 PreparedStatement pstmt3 = null;
		 PreparedStatement pstmt4 = null;
		 listop.clear();
	
		 try {		
			 //rapprochement en cours
			 if (dateCloture==0){			
				 String LISTE_OP ="";
					 LISTE_OP =					
					        "SELECT distinct Op_Id from " + base +".OPERATION o, " + base +".ECRITURE e  WHERE e.Ecriture_Id=o.Ecriture_Id and e.Code_journal=? and Date_Op BETWEEN ? and ?";					 
				 pstmt = con.prepareStatement(LISTE_OP);    				
			     pstmt.setString(1, codeJournal); 				     
			     pstmt.setLong(2, dateRappro);			    
			     pstmt.setLong(3, dateReleve);					     
			     ResultSet rs = pstmt.executeQuery();
				     while (rs.next()) {
				    	 
				    	 String op = rs.getString(1);			    	 
				    	 listop.add(op);				    	
				     }
				
			     String DATES_RAPPRO_PRECEDENT = "select max(Date_rappro) as dra , Max(Date_Releve) as dr from    "+ baseDossier +".RAPPROCHEMENT where Code_Journal=? and Date_Rappro < ? ";
			   
			   
			     pstmt2 = con.prepareStatement(DATES_RAPPRO_PRECEDENT);
			     pstmt2.setString(1, codeJournal);  			     
			     pstmt2.setLong(2, dateRappro);
			     ResultSet rs2 = pstmt2.executeQuery();
				        if (rs2.next()){				         
					    	 String LISTE_OP_A_AJOUTER =					
							        "SELECT distinct lr.Op_Id from " + baseDossier +".LIGNE_RAPPROCHEMENT lr,   "+ baseDossier +".RAPPROCHEMENT r WHERE r.Rappro_Id=lr.Rappro_id and Code_Journal=? and lr.Pointage=0 and r.Date_Rappro BETWEEN ? and ? and lr.Nom_Base=?";					    
					    	 pstmt3 = con.prepareStatement(LISTE_OP_A_AJOUTER);  
					    	 pstmt3.setString(1, codeJournal);   
							 pstmt3.setLong(2, rs2.getLong(1));
							 pstmt3.setLong(3, rs2.getLong(2));	
							 pstmt3.setString(4, base);
							 ResultSet rs3 = pstmt3.executeQuery();
							 while (rs3.next()) {	
							    	 String op = rs3.getString(1);			    	 
							    	 listop.add(op);							    
				            }
//							liste des operations qui ont t rajoutes dans les priodes prcedentes
						     String LISTE_OP_AJOUTEES =
						    	 "select o.Op_Id from " + base +".OPERATION o LEFT JOIN "+ baseDossier +".LIGNE_RAPPROCHEMENT lr ON o.Op_Id=lr.Op_Id AND lr.Nom_Base='"+base+"', "+ base +".ECRITURE e WHERE lr.Op_Id IS NULL  AND e.Ecriture_Id=o.Ecriture_Id and e.Code_journal=? and o.Date_Op < ?";
						     pstmt4 = con.prepareStatement(LISTE_OP_AJOUTEES);
						     pstmt4.setString(1, codeJournal); 				     
						     pstmt4.setLong(2, dateRappro);		
						   
						     ResultSet rs4 = pstmt4.executeQuery();
							     if (rs4.next()){
							    	 String op = rs4.getString(1);		
							    	 listop.add(op); 
							     }
				  rs.close();
				  rs2.close();
				  rs4.close();
				 
				 }
			 }
			 //liste des operations d'un rapprochement clotur
			 else {
					 String LISTE_OP =					
						        "SELECT distinct Op_Id from " + baseDossier +".LIGNE_RAPPROCHEMENT WHERE Rappro_Id=? and Nom_Base=?";
				     pstmt = con.prepareStatement(LISTE_OP);      		 
				     pstmt.setInt(1, rapproId); 
				     pstmt.setString(2, base);
				     ResultSet rs = pstmt.executeQuery();
					     while (rs.next()) {	
					    	 String op = rs.getString(1);		    	 
					    	 listop.add(op);
					    	
					     }					
			}
		 }		 
		 catch (SQLException sqle) {
			 sqle.printStackTrace();
		    }
		return listop;
	 }
	 public double getsoldesOpInitial(long dateRappro) {
		  PreparedStatement pstmt = null;
	      double soldeinitial=0;
	      try {								 			 
				String SOLDES_OP="";
				ResultSet rs3;
				if (typeRappro.equals("J")){
					SOLDES_OP =	
					  "SELECT SUM(Montant_D-Montant_C) as solde, SUM(Montant_C) as totcredit, SUM(Montant_D) as totdebit from " + base +".OPERATION o, " + base +".ECRITURE e  WHERE e.Ecriture_Id=o.Ecriture_Id and e.Code_journal=? and Date_Op < ?";
					pstmt = con.prepareStatement(SOLDES_OP); 
					pstmt.setString(1, codeJournal);
					pstmt.setLong(2, dateRappro);								 
					rs3 = pstmt.executeQuery();			     
					while (rs3.next()) {	
						 soldeinitial = rs3.getDouble(1);							    	
					}
				}
				if (typeRappro.equals("C")){							 
					 SOLDES_OP =							 
						 "SELECT SUM(Montant_D-Montant_C) as solde, SUM(Montant_C) as totcredit, SUM(Montant_D) as totdebit  from " + base +".OPERATION o," + base +".ECRITURE e," + baseDossier +".JOURNAL j WHERE e.Ecriture_Id=o.Ecriture_Id and e.Code_Journal=j.Code_Journal and j.Type_Journal<>'AN' and Numero_Compte=? and Date_Op < ?";
					 pstmt = con.prepareStatement(SOLDES_OP); 				
					 pstmt.setString(1, compte);	
					 pstmt.setLong(2, dateRappro);	
					 rs3 = pstmt.executeQuery();			     
					 while (rs3.next()) {	
						 soldeinitial = rs3.getDouble(1);
							    	
					 }							 
				}
		 		}
			catch (SQLException sqle) {
				 sqle.printStackTrace();
			    }		
			 return soldeinitial;
	 }
	 public void calculSoldesOp(String list) {
		 PreparedStatement pstmt = null;
		 PreparedStatement pstmt2 = null;
		 PreparedStatement pstmt3 = null;
		 if (list.equals("")){
			 list="''";
		 }	    
		 try {			
			 String SOLDES_OP="";
			 ResultSet rs3;
			 if (typeRappro.equals("J")){
				SOLDES_OP =	
					 "SELECT SUM(Montant_D-Montant_C) as solde, SUM(Montant_C) as totcredit, SUM(Montant_D) as totdebit from "+ base +".OPERATION o, " + base +".ECRITURE e," + baseDossier +".JOURNAL j where e.Ecriture_Id=o.Ecriture_Id and e.Code_Journal=j.Code_Journal and o.Numero_Compte in (select Contrepartie from " + baseDossier +".JOURNAL where Code_Journal=?) and j.Type_Journal<>'AN' and Date_Op <= ?";
				pstmt3 = con.prepareStatement(SOLDES_OP); 				
				pstmt3.setString(1, codeJournal);
				pstmt3.setLong(2, dateReleve);					   
				rs3 = pstmt3.executeQuery();			     
				while (rs3.next()) {	
					solde = rs3.getDouble(1);
				}
			 }
			if (typeRappro.equals("C")){
				 //si mode compte on ne comptabilise pas le solde d' nouveau
				SOLDES_OP =							 
					 "SELECT SUM(Montant_D-Montant_C) as solde, SUM(Montant_C) as totcredit, SUM(Montant_D) as totdebit from "+ base +".OPERATION o," + base +".ECRITURE e," + baseDossier +".JOURNAL j where e.Ecriture_Id=o.Ecriture_Id and e.Code_Journal=j.Code_Journal and j.Type_Journal<>'AN' and Numero_Compte=? and Date_Op <= ?";
				pstmt3 = con.prepareStatement(SOLDES_OP); 				
				pstmt3.setString(1, compte);	
				pstmt3.setLong(2, dateReleve);	
				rs3 = pstmt3.executeQuery();			     
				while (rs3.next()) {	
					solde = rs3.getDouble(1);
			    }				
		   }
			
			if (!list.equals("")){
				 String MONTANT_OP =							 
					"SELECT SUM(Montant_C-Montant_D) as solde, SUM(Montant_C) as totcredit, SUM(Montant_D) as totdebit from "+ base +".OPERATION where Op_Id in ("+list+")";					 
				 pstmt = con.prepareStatement(MONTANT_OP); 
				 ResultSet rs = pstmt.executeQuery();			     
				 while (rs.next()) {	
				   	 totcredit = rs.getDouble(2);				
					 totdebit = rs.getDouble(3);
				}
				String SOLDES_OP_NON_POINTEE =							 
					"SELECT SUM(Montant_D-Montant_C) as solde from " + base +".OPERATION WHERE Op_Id IN ("+list+") and Pointage=0";
				pstmt2 = con.prepareStatement(SOLDES_OP_NON_POINTEE);    
				ResultSet rs2 = pstmt2.executeQuery();			     
				while (rs2.next()) {	
					  soldenonppointe = rs2.getDouble(1);			    	 					    	 					    	 
	              
				}	
				
			 }
			 else{
					totcredit =0;
					totdebit =0;
				 }			
		 }
			 catch (SQLException sqle) {
				 sqle.printStackTrace();
			    }
		
			}
	 public void calculSoldeAN(String compte) {
		 PreparedStatement pstmt = null;	

		 try {			
			 //si c'est en mode journal, on prend le compte de contrepartie, sinon le compte en mode compte
			String SOLDE_AN =							 
				"select SUM(Montant_D-Montant_C) as solde from " + base +".OPERATION o, " + base +".ECRITURE e," + baseDossier +".JOURNAL j where e.Ecriture_Id=o.Ecriture_Id and e.Code_Journal=j.Code_Journal and j.Type_Journal='AN' and o.Numero_Compte=?";
			pstmt = con.prepareStatement(SOLDE_AN); 			
			pstmt.setString(1, compte);								
			ResultSet  rs = pstmt.executeQuery();			     
			while (rs.next()) {	
				soldeAN = rs.getDouble(1);
			}
		 }
		 catch (SQLException sqle) {
			 sqle.printStackTrace();
	     }	
	}
	public String getCompte() {
		return compte;
	}
	public void setCompte(String compte) {
		this.compte = compte;
	}

	
}
