/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/
  
/**
 *  Gnration du graphique de trsorerie
 */

package org.opensi.compta.actions.graphics;

import java.awt.Color;
import java.awt.Paint;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Calendar;

import org.experlog.openeas.api.Action;
import org.experlog.openeas.api.ServletRequest;
import org.experlog.openeas.api.Session;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.SymbolicAxis;
import org.jfree.chart.axis.SymbolicTickUnit;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;


public class Tresorerie extends Action {


  public boolean serverSide() { return true; }

  public boolean service(Session s, ServletRequest r, Object info) throws Exception {

		
		String nomFichier = r.getParameter("fichierPng");
		
		String base = s.getCookie().get("BaseExo");
		String baseDossier = s.getCookie().get("BaseDossier");


		Connection con = s.getConnection(null);


		PreparedStatement ps = con.prepareStatement("select sum(Montant_D)-sum(Montant_C) as Solde from "+ base +".OPERATION where Date_Op<=? and Numero_Compte like '5%'");


		ResultSet rset;	


		String etiquettes[] = new String[61];

		int i;

		for (i=0;i<61;i++) {
			etiquettes[i] = "";
		}

		etiquettes[0] = "J-30";
		etiquettes[30] = "J";
		etiquettes[45] = "J+15";
		etiquettes[60] = "J+30";


		XYSeries dataSeries = new XYSeries("N");

		Calendar calendar = Calendar.getInstance();

		calendar.setTimeInMillis(System.currentTimeMillis());

		calendar.add(Calendar.DATE, -30);
		calendar.set(Calendar.HOUR, 0);
		calendar.set(Calendar.MINUTE, 0);
		calendar.set(Calendar.SECOND, 0);
		calendar.set(Calendar.MILLISECOND, 0);	

		long j30 = calendar.getTimeInMillis();

		int solde = 0;
		int solde30 = 0;

		for (i=0;i<31;i++) {				

			ps.clearParameters();
			ps.setLong(1, calendar.getTimeInMillis());
			rset = ps.executeQuery();
			rset.next();

			solde = rset.getInt("Solde");

			if (i==0) solde30 = solde;

			dataSeries.add(i,solde);

			calendar.add(Calendar.DATE, 1);

		}

		int SoldeJ = solde;

		ps = con.prepareStatement("select sum(Total_Credit)-sum(Total_Debit) as Solde from "+ base +".SOLDE_COMPTE where Numero_Compte like ? and Numero_Compte<>'41100000' group by Numero_Compte");

		double autresDettes = getCredit(ps, "41%")+
													getCredit(ps, "452%")+
													getCredit(ps, "453%")+
													getCredit(ps, "454%")+
													getCredit(ps, "46%")+
													getCredit(ps, "47%")+
													getCredit(ps, "50%")-
													getCredit(ps, "41199999%")-
													getCredit(ps, "4191%")-
													getCredit(ps, "476%")-
													getCredit(ps, "477%");

		autresDettes += getCredit411(con, base, baseDossier);

		dataSeries.add(45, SoldeJ-(int)autresDettes);	



		Statement stt = con.createStatement();

		String clients30 = "select sum(Montant_D) as tranche from "+base+".OPERATION o, "+baseDossier+".COMPTE c, "+base+".SOLDE_COMPTE s where o.Lettre='' and o.Numero_Compte=c.Numero_Compte"
											+ " and s.Numero_Compte=c.Numero_Compte and s.Solde<>0 and c.Type_Compte='C' and o.Date_Op<="+j30;

		String fournisseurs30 = "select sum(Montant_C) as tranche from "+base+".OPERATION o, "+baseDossier+".COMPTE c, "+base+".SOLDE_COMPTE s where o.Lettre='' and o.Numero_Compte=c.Numero_Compte"
											+ " and s.Numero_Compte=c.Numero_Compte and s.Solde<>0 and c.Type_Compte='F' and o.Date_Op<="+j30;


		String nonAffFournisseurs = "select sum(Montant_D) as nonaff from "+base+".OPERATION o, "+baseDossier+".COMPTE c, "+base+".SOLDE_COMPTE s"
															+ " where o.Lettre='' and s.Numero_Compte=c.Numero_Compte and o.Numero_Compte=c.Numero_Compte and s.Solde<>0 and c.Type_Compte='F'";


		String nonAffClients = "select sum(Montant_C) as nonaff from "+base+".OPERATION o, "+baseDossier+".COMPTE c, "+base+".SOLDE_COMPTE s"
															+ " where o.Lettre='' and s.Numero_Compte=c.Numero_Compte and o.Numero_Compte=c.Numero_Compte and s.Solde<>0 and c.Type_Compte='C'";


		rset = stt.executeQuery(clients30);	
		rset.next();
		double soldeClients30 = rset.getDouble("tranche");


		rset = stt.executeQuery(fournisseurs30);
		rset.next();
		double soldeFournisseurs30 = rset.getDouble("tranche");


		rset = stt.executeQuery(nonAffClients);
		rset.next();
		double soldeNonAffClients = rset.getDouble("nonaff");

		soldeClients30 = soldeNonAffClients>soldeClients30?0:soldeClients30-soldeNonAffClients;


		rset = stt.executeQuery(nonAffFournisseurs);
		rset.next();
		double soldeNonAffFournisseurs = rset.getDouble("nonaff");

		soldeFournisseurs30 = soldeNonAffFournisseurs>soldeFournisseurs30?0:soldeFournisseurs30-soldeNonAffFournisseurs;


		dataSeries.add(60, SoldeJ-(int)autresDettes-(int)soldeFournisseurs30+(int)soldeClients30);


		s.closeConnection(con, null);


		r.addParameter("JM30", ""+ solde30);
		r.addParameter("J", ""+ SoldeJ);
		r.addParameter("JP15", ""+ (SoldeJ-(int)autresDettes));
		r.addParameter("JP30", ""+ (SoldeJ-(int)autresDettes-(int)soldeFournisseurs30+(int)soldeClients30));


		r.addParameter("AutresDettes", ""+ autresDettes);
		r.addParameter("Fournisseurs30", ""+ soldeFournisseurs30);
		r.addParameter("Clients30", ""+ soldeClients30);


		XYSeriesCollection xyDataset = new XYSeriesCollection(dataSeries);


		NumberAxis timeAxis = new SymbolicAxis("", etiquettes);
		NumberAxis valueAxis = new NumberAxis("Solde de trsorerie");
		timeAxis.setAutoRangeIncludesZero(false);
		valueAxis.setAutoRangeIncludesZero(false);


		// Cration des symboles pour l'axe horizontal

		SymbolicTickUnit tickUnit = new SymbolicTickUnit(1, etiquettes);
		timeAxis.setTickUnit(tickUnit);
		timeAxis.setRange(0, etiquettes.length-1);


		XYPlot plot = new XYPlot(xyDataset, timeAxis, valueAxis, new StandardXYItemRenderer());

		JFreeChart chart = new JFreeChart("Trsorerie", JFreeChart.DEFAULT_TITLE_FONT, plot, false);
		Paint couleur_fond = new Color(255,255,255,0); //transparent
		chart.setBackgroundPaint(couleur_fond);
			
		try {
		
			String chemin = s.getAppConfiguration().get("opensi.absdir") +"/graph/";
			File file = new File(chemin + nomFichier);
		
			ChartUtilities.saveChartAsPNG(file, chart, 550, 350, null, true, 9);		
		
			file.deleteOnExit();		
		}
		catch(SecurityException se) {
    	s.trace("Impossible d'enregistrer le fichier  supprimer");
    	se.printStackTrace();
    }		
		catch (Exception e) {
			e.printStackTrace();
		}
			
			
		return true;			
	}
	
	
	public double getCredit(PreparedStatement ps, String like) throws SQLException {
		
		ps.setString(1, like);
		
		ResultSet rset = ps.executeQuery();
		
		double val = 0;
		
		while(rset.next()) {
			
			double solde = rset.getDouble("Solde");
			
			val += solde>0?solde:0;
		}
		
		rset.close();
		
		return val;		
	}
	
	
	public double getCredit411(Connection con, String base, String baseDossier) throws SQLException {		
		
		Statement stt = con.createStatement();	
		
		ResultSet rset = stt.executeQuery("select sum(s.Total_Credit)-sum(s.Total_Debit) as Solde from "+ base +".SOLDE_COMPTE s, "+ baseDossier +".COMPTE c where c.Type_Compte='C' group by c.Numero_Compte");
		
		double val = 0;
		
		while(rset.next()) {
			
			double solde = rset.getDouble("Solde");
			
			val += solde>0?solde:0;
		}
		
		rset.close();
		stt.close();
		
		return val;		
	}	


} // fin Tresorerie











