/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Gnration d'un avoir au format standard
 */

package org.opensi.compta.actions.etats;


import java.awt.Color;
import java.sql.Date;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;

import org.opensi.util.pdf.MultiPagesDocument;
import org.opensi.util.pdf.PdfWidths;
import org.opensi.util.pdf.TableBuilder;

import com.lowagie.text.DocumentException;
import com.lowagie.text.Font;
import com.lowagie.text.Image;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;


public class PdfPlanComptableGeneral extends MultiPagesDocument {


	// dfinition des polices

private static final Font fontTitre = new Font(Font.HELVETICA , 16, Font.BOLD, Color.WHITE);
private static final Font fontCadre1Petit = new Font(Font.HELVETICA, 8, Font.NORMAL);
private static final Font fontEnteteColonne = new Font(Font.HELVETICA, 9, Font.BOLD);
private static final Font fontLine = new Font(Font.HELVETICA , 8, Font.NORMAL);


private DecimalFormat numFormat = new DecimalFormat("0.00");
private DecimalFormat numFormat4 = new DecimalFormat("0.00##");
private DecimalFormat numFormatCap = new DecimalFormat("0.##");
private SimpleDateFormat formatDate = new SimpleDateFormat("dd/MM/yyyy");


private float[] widthsCols;
private int nbCols;


int compclasse=0;
private DataPlanComptableGeneral lignesdata;





  public PdfPlanComptableGeneral(DataPlanComptableGeneral lignesdata, String tempdir) throws Exception {

		super(tempdir);
		this.lignesdata=lignesdata;
		DecimalFormatSymbols dfs = new DecimalFormatSymbols();
		dfs.setDecimalSeparator('.');
		dfs.setGroupingSeparator(' ');
		
		numFormat.setDecimalFormatSymbols(dfs);
		numFormat.setNegativeSuffix("");
		numFormat.setNegativePrefix("-");
		numFormat.setPositiveSuffix(" ");
		numFormat.setGroupingUsed(true);
		numFormat.setGroupingSize(3);		
		
		numFormat4.setDecimalFormatSymbols(dfs);
		numFormat4.setGroupingUsed(true);
		numFormat4.setGroupingSize(3);
		
		numFormatCap.setDecimalFormatSymbols(dfs);
		numFormatCap.setGroupingUsed(true);
		numFormatCap.setGroupingSize(3);		

//		colonne (poid,taille en %)=> nombre de colonnes du tableau de datas
		PdfWidths pw = new PdfWidths();		
		pw.addColonneVariableMin(4, 20);
		pw.addColonneVariableMin(4,20);
		pw.addColonneVariableMin(4,20);
		pw.addColonneVariableMin(4,20);
		pw.addColonneVariableMin(4,20);
		
		nbCols = pw.getNbCols();
		widthsCols = pw.getWidthsCols();
	
	}


	
	/* implmentation des fonctions de MultiPagesDocument */
	
	public PdfPTable firstHeader() throws DocumentException {
		
		TableBuilder tb = new TableBuilder();		
		//tb.add(makeEntete());
		tb.add(makeSpace(20));
		tb.add(makeTitre());
		tb.add(makeSpace(5));
		tb.add(makeEntetesColonnes());		
		
		return tb.getTable();	
	}
	
	
	public PdfPTable middleHeader(int lastLine) throws DocumentException {
		
		TableBuilder tb = new TableBuilder();
		
		tb.add(makeEntetesColonnes());	
		
		
		
		return tb.getTable();
	}
	
	
	public PdfPTable lastFooter() throws DocumentException {
		
		TableBuilder tb = new TableBuilder();
		
		
		return tb.getTable();
	}	
	
	
	public PdfPTable middleFooter(int nbLinesPage, int lastLine) throws DocumentException {
		TableBuilder tb = new TableBuilder();
		tb.add(emptyLine(10));
		tb.add(makeFooter());
		return tb.getTable();		
	}
	
	
	public PdfPTable bodyLine(int numLine) throws DocumentException {
	
		
		LignePlanGeneral lp = lignesdata.lignes.get(numLine);
		String classe;		 
		classe=String.valueOf(lp.numClasse).substring(0,1);
	    int numclasse=new Integer(classe);	    
	    
	    boolean titre =false;
	    titre=(numclasse==compclasse+1);
	    
	    compclasse=numclasse;
		return makeLinePlanG(lp,titre);
	}
	
	
	public PdfPTable emptyLine(float emptyHeight) throws DocumentException {
		
		PdfPTable pptSpace = new PdfPTable(nbCols);
		pptSpace.setWidthPercentage(100);
		pptSpace.setWidths(widthsCols);
		
		PdfPCell cell = new PdfPCell(pptSpace.getDefaultCell());
		cell.setBorder(PdfPCell.NO_BORDER);
		cell.setPaddingBottom(0);
		cell.setPaddingTop(0);
		cell.setFixedHeight(emptyHeight);		
		cell.setPhrase(new Phrase(""));		
	
		for (int i=0; i<nbCols; i++) {
			pptSpace.addCell(cell);
		}
	
		return pptSpace;
	}
	
	
	public int nbLines() {
	
		return lignesdata.getNbLignes();
	}
	
	
	private PdfPTable makeFooter() {
		
		PdfPTable pptInfos = new PdfPTable(2);
		
		PdfPCell cell;
			cell = new PdfPCell(pptInfos.getDefaultCell());
			cell.setBorder(PdfPCell.NO_BORDER);
			cell.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);

		
			
		String dateCourante = formatDate.format(new Date(System.currentTimeMillis()));
		cell.setPhrase(new Phrase("Date : " + dateCourante, fontCadre1Petit));
		cell.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
		pptInfos.addCell(cell);
		
		cell.setPhrase(new Phrase("Page "+currentPage+" / "+totalPages, fontCadre1Petit));
		cell.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
		pptInfos.addCell(cell);
		
		return pptInfos;	
	}

	/* mthodes internes */

	private PdfPTable makeSpace(int space) {
	
		PdfPTable pptSpace = new PdfPTable(1);
		PdfPCell cell = new PdfPCell(pptSpace.getDefaultCell());
		cell.setBorder(PdfPCell.NO_BORDER);
		cell.setFixedHeight(space);
		cell.setPhrase(new Phrase(""));
	
		pptSpace.addCell(cell);
	
		return pptSpace;
	}
	
	private PdfPTable makeTitre() {
	
		PdfPTable pptTitre = new PdfPTable(1);
		pptTitre.setWidthPercentage(100);
		
		PdfPCell cell = new PdfPCell(pptTitre.getDefaultCell());		
		cell.setBorder(PdfPCell.NO_BORDER);
		cell.setBackgroundColor(new Color(175,175,175));
		cell.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
		cell.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
		cell.setFixedHeight(30);
		cell.setPaddingBottom(5);
		cell.setPhrase(new Phrase("PLAN COMPTABLE GENERAL", fontTitre));
		
		pptTitre.addCell(cell);
		
		return pptTitre;	
	}
	

	
	
	private PdfPTable makeEntetesColonnes() throws DocumentException {
	
		PdfPTable pptCols = new PdfPTable(nbCols);
		pptCols.setWidthPercentage(100);
		pptCols.setWidths(widthsCols);
		
		PdfPCell cell = new PdfPCell(pptCols.getDefaultCell());		
		
		cell.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
		cell.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
		cell.setPaddingBottom(4);
		cell.setMinimumHeight(40);
		
		cell.setPhrase(new Phrase("Num\u00E9ro", fontEnteteColonne));
		pptCols.addCell(cell);
		
		cell.setPhrase(new Phrase("Intitul\u00E9", fontEnteteColonne));
		pptCols.addCell(cell);
		
		
		return pptCols;
	}	
	
	
	private PdfPTable makeLinePlanG(LignePlanGeneral lp, boolean titreclasse) throws DocumentException {
	
		PdfPTable pptLine = new PdfPTable(nbCols);
		pptLine.setWidthPercentage(100);
		pptLine.setWidths(widthsCols);
		

		PdfPCell cell = new PdfPCell(pptLine.getDefaultCell());
		//cell.setBorder(PdfPCell.BOTTOM+PdfPCell.TOP+PdfPCell.LEFT+PdfPCell.RIGHT);	
		cell.setBorder(PdfPCell.NO_BORDER);
		cell.setPaddingLeft(5);
		cell.setColspan(5);
		
		
		
		if (titreclasse){
			cell.setPhrase(new Phrase("", fontLine));
			cell.setColspan(5);
			cell.setBorder(PdfPCell.NO_BORDER);
			cell.setFixedHeight(30);
			pptLine.addCell(cell);	
			
			
			cell.setPaddingTop(20);
			cell.setBorder(PdfPCell.BOX);
			cell.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
			if (String.valueOf(lp.code).substring(0,1).equals("1")){
				cell.setPhrase(new Phrase("COMPTE DE CAPITAUX", fontLine));
			}
			if (String.valueOf(lp.code).substring(0,1).equals("2")){
				cell.setPhrase(new Phrase("COMPTE D'IMMOBILISATIONS", fontLine));								
			}
			if (String.valueOf(lp.code).substring(0,1).equals("3")){
				cell.setPhrase(new Phrase("COMPTE DE STOCKS ET D'EN-COURS", fontLine));		
			}
			if (String.valueOf(lp.code).substring(0,1).equals("4")){
				cell.setPhrase(new Phrase("COMPTE DE TIERS", fontLine));	
			}
			if (String.valueOf(lp.code).substring(0,1).equals("5")){
				cell.setPhrase(new Phrase("COMPTE FINANCIERS", fontLine));
			}
			if (String.valueOf(lp.code).substring(0,1).equals("6")){
				cell.setPhrase(new Phrase("COMPTE DE CHARGES", fontLine));
			}
			if (String.valueOf(lp.code).substring(0,1).equals("7")){
				cell.setPhrase(new Phrase("COMPTE DE PRODUITS", fontLine));
			}
			if (String.valueOf(lp.code).substring(0,1).equals("8")){
				cell.setPhrase(new Phrase("COMPTE SPECIAUX", fontLine));	
			}		
			cell.setPaddingBottom(20);
			pptLine.addCell(cell);	
			cell.setPhrase(new Phrase("", fontLine));
			cell.setColspan(5);
			cell.setFixedHeight(10);
			cell.setBorder(PdfPCell.NO_BORDER);
			pptLine.addCell(cell);
		}
		
		cell.setColspan(1);
		cell.setBorder(PdfPCell.NO_BORDER);
		cell.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
		cell.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
		
		if (lp.getNiveau()==2){
			
			cell.setPhrase(new Phrase("", fontLine));
			cell.setColspan(5);
			cell.setBorder(PdfPCell.NO_BORDER);
			pptLine.addCell(cell);
			cell.setColspan(1);
			cell.setFixedHeight(20);
			cell.setBackgroundColor(new Color(175,175,175));	
			cell.setPhrase(new Phrase(String.valueOf(lp.numClasse), fontLine));
			pptLine.addCell(cell);	
			cell.setColspan(4);
			cell.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
			cell.setPhrase(new Phrase(lp.libClasse, fontLine));					
			pptLine.addCell(cell);
			
			cell.setColspan(1);
		}
		if (lp.getNiveau()==3){
			cell.setPhrase(new Phrase(""));
			pptLine.addCell(cell);
			cell.setPhrase(new Phrase(String.valueOf(lp.numClasse), fontLine));
			pptLine.addCell(cell);		
			cell.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
			cell.setPhrase(new Phrase(lp.libClasse, fontLine));
			pptLine.addCell(cell);
			cell.setPhrase(new Phrase(""));
			pptLine.addCell(cell);
			cell.setPhrase(new Phrase(""));
			pptLine.addCell(cell);
		}
		if (lp.getNiveau()==4){
			cell.setPhrase(new Phrase(""));
			pptLine.addCell(cell);
			cell.setPhrase(new Phrase(""));
			pptLine.addCell(cell);
			cell.setPhrase(new Phrase(String.valueOf(lp.numClasse), fontLine));
			pptLine.addCell(cell);		
			cell.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
			cell.setPhrase(new Phrase(lp.libClasse, fontLine));
			pptLine.addCell(cell);
		}
		if (lp.getNiveau()==5){
			cell.setPhrase(new Phrase(""));
			pptLine.addCell(cell);
			cell.setPhrase(new Phrase(""));
			pptLine.addCell(cell);
			cell.setPhrase(new Phrase(String.valueOf(lp.numClasse), fontLine));
			pptLine.addCell(cell);		
			cell.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
			cell.setPhrase(new Phrase(lp.libClasse, fontLine));
			pptLine.addCell(cell);
			cell.setPhrase(new Phrase(""));
			pptLine.addCell(cell);
		}
		
		return pptLine;	
	}



	@Override
	public Image imageFond() {
		// TODO Auto-generated method stub
		return null;
	}



	@Override
	public int nbEx() {
		// TODO Auto-generated method stub
		return 1;
	}
		

	
	

} 
