/******************************************************************************/
/* OpenSI : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Edition du grand livre.
 */

package org.opensi.compta.actions.etats;

import java.awt.Color;
import java.io.File;
import java.io.FileOutputStream;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;

import org.experlog.openeas.api.Action;
import org.experlog.openeas.api.ServletRequest;
import org.experlog.openeas.api.Session;
import org.opensi.util.tools.DateTime;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Font;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfPageEvent;
import com.lowagie.text.pdf.PdfWriter;


public class GenPdfGrandLivre extends Action {


	class MyPageEvent implements PdfPageEvent {

	private String dateCourante;

	private String dossierId;
	private String raisonSociale;
	private String adresse;
	private String compAdresse;
	private String codePostal;
	private String ville;
	private String monnaie;

	private String finExerciceStr;
	private String debutExerciceStr;

	private String finPeriodeStr;
	private String debutPeriodeStr;

		public MyPageEvent(String dossierId) throws SQLException {

			this.dossierId = dossierId;

			String reqLeDossier = "select s.Denomination, s.Adresse_1, s.Adresse_2, s.Code_Postal, s.Ville, d.Intitule as Devise from "+ baseDossier +".SOCIETE s join DEVISE d on s.Monnaie_Tenue=d.Devise_Id";

			Statement stt = con.createStatement();
			ResultSet rset = stt.executeQuery(reqLeDossier);

			rset.next();

			this.raisonSociale = rset.getString("Denomination");
			this.adresse = rset.getString("Adresse_1");
			this.compAdresse = rset.getString("Adresse_2");
			this.codePostal = rset.getString("Code_Postal");
			this.ville = rset.getString("Ville");
			this.monnaie = rset.getString("Devise");

			rset.close();

			stt.close();

			SimpleDateFormat formatDate = new SimpleDateFormat("dd/MM/yyyy");
			this.dateCourante = formatDate.format(new Date(System.currentTimeMillis()));
			finExerciceStr = formatDate.format(new Date(Long.parseLong(finExercice)));
			debutExerciceStr = formatDate.format(new Date(Long.parseLong(debutExercice)));
			finPeriodeStr = formatDate.format(new Date(finPeriode));
			debutPeriodeStr = formatDate.format(new Date(debutPeriode));
		}

    public void onStartPage(PdfWriter writer, Document document) {

    	try {

				// Entete Gnrale


				PdfPTable bandeau = new PdfPTable(1);

				bandeau.setWidthPercentage(100);

				PdfPTable entete = new PdfPTable(3);

				PdfPCell cellEntete = new PdfPCell(entete.getDefaultCell());

				cellEntete.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
				cellEntete.setBorderWidth(0);
				cellEntete.setMinimumHeight(10);

				cellEntete.setPhrase(new Phrase("Dossier : " + this.dossierId, fontGen));
				entete.addCell(cellEntete);

				cellEntete.setPhrase(new Phrase(this.raisonSociale, fontGen));
				cellEntete.setColspan(2);
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
				entete.addCell(cellEntete);
				cellEntete.setColspan(1);

				cellEntete.setPhrase(new Phrase("Date : " + this.dateCourante, fontGen));
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
				entete.addCell(cellEntete);

				cellEntete.setPhrase(new Phrase(this.adresse, fontGen));
				cellEntete.setColspan(2);
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
				entete.addCell(cellEntete);

				if (exocomplet) {
					cellEntete.setPhrase(new Phrase("", fontGen));
				}
				else {
					cellEntete.setPhrase(new Phrase("Exercice du " + this.debutExerciceStr + " au " + this.finExerciceStr, fontGen));
				}
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
				entete.addCell(cellEntete);

				cellEntete.setPhrase(new Phrase(this.compAdresse, fontGen));
				cellEntete.setColspan(2);
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
				entete.addCell(cellEntete);
				cellEntete.setColspan(1);

				cellEntete.setPhrase(new Phrase("Page : "+ document.getPageNumber(), fontGen));
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
				entete.addCell(cellEntete);

				cellEntete.setPhrase(new Phrase(this.codePostal + " " + this.ville, fontGen));
				cellEntete.setColspan(2);
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
				entete.addCell(cellEntete);

				cellEntete.setPhrase(new Phrase("Grand Livre "+ titre +" en "+ this.monnaie , new Font(Font.HELVETICA, 16, Font.BOLD)));
				cellEntete.setColspan(3);
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
				entete.addCell(cellEntete);

				cellEntete.setPhrase(new Phrase(""));
				cellEntete.setFixedHeight(10);
				entete.addCell(cellEntete);

				if (exocomplet) {
					cellEntete.setPhrase(new Phrase("Exercice du " + this.debutExerciceStr + " au " + this.finExerciceStr, fontGen));
				}
				else {
					cellEntete.setPhrase(new Phrase("P\u00E9riode du " + this.debutPeriodeStr + " au " + this.finPeriodeStr, fontGen));
				}

				cellEntete.setMinimumHeight(0);
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
				entete.addCell(cellEntete);


				PdfPCell cellBandeau = new PdfPCell(entete);
				cellBandeau.setPadding(10);

				bandeau.addCell(cellBandeau);

				document.add(bandeau);

				// fin Entete Gnrale


				// Titres de colonnes

				PdfPTable titresColonnes = new PdfPTable(9);
				titresColonnes.setWidthPercentage(100);
				titresColonnes.setWidths(widths);
				PdfPCell cellTitre = new PdfPCell(titresColonnes.getDefaultCell());

				cellTitre.setFixedHeight(15);
				cellTitre.setBorder(PdfPCell.NO_BORDER);
				cellTitre.setPhrase(new Phrase(""));
				cellTitre.setColspan(10);
				titresColonnes.addCell(cellTitre);
				cellTitre.setColspan(1);

				cellTitre.setFixedHeight(20);
				cellTitre.setBackgroundColor(Color.LIGHT_GRAY);
				cellTitre.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);

				cellTitre.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
				cellTitre.setBorder(PdfPCell.BOX - PdfPCell.RIGHT);
				cellTitre.setPhrase(new Phrase("DATE", fontLine));
				titresColonnes.addCell(cellTitre);

				cellTitre.setBorder(PdfPCell.BOX - PdfPCell.RIGHT - PdfPCell.LEFT);
				cellTitre.setPhrase(new Phrase("CJ", fontLine));
				titresColonnes.addCell(cellTitre);

				cellTitre.setPhrase(new Phrase("", fontLine));
				titresColonnes.addCell(cellTitre);

				cellTitre.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
				cellTitre.setPhrase(new Phrase("LIBELLE", fontLine));
				titresColonnes.addCell(cellTitre);
				cellTitre.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);

				cellTitre.setBorder(PdfPCell.BOX - PdfPCell.LEFT);
				cellTitre.setPhrase(new Phrase("N\u00B0 PIECE", fontLine));
				titresColonnes.addCell(cellTitre);

				cellTitre.setBorder(PdfPCell.BOX);
				cellTitre.setPhrase(new Phrase("DEBIT", fontLine));
				titresColonnes.addCell(cellTitre);

				cellTitre.setPhrase(new Phrase("LT", fontLine));
				titresColonnes.addCell(cellTitre);

				cellTitre.setPhrase(new Phrase("CREDIT", fontLine));
				titresColonnes.addCell(cellTitre);

				cellTitre.setPhrase(new Phrase("SOLDE", fontLine));
				titresColonnes.addCell(cellTitre);

				document.add(titresColonnes);

				// fin Titres de colonnes

			}
			catch(DocumentException de) {	de.printStackTrace(); }

		}

		public void onEndPage(PdfWriter writer, Document document) {}
		public void onOpenDocument(PdfWriter writer, Document document) {}
    public void onCloseDocument(PdfWriter writer, Document document) {}
    public void onParagraph(PdfWriter writer, Document document, float paragraphPosition) {}
    public void onParagraphEnd(PdfWriter writer,Document document,float paragraphPosition) {}
    public void onChapter(PdfWriter writer,Document document,float paragraphPosition, Paragraph title) {}
    public void onChapterEnd(PdfWriter writer,Document document,float paragraphPosition) {}
    public void onSection(PdfWriter writer,Document document,float paragraphPosition, int depth, Paragraph title) {}
    public void onSectionEnd(PdfWriter writer,Document document,float paragraphPosition) {}
    public void onGenericTag(PdfWriter writer, Document document, Rectangle rect, String text) {}

	}


private static final Font fontGen = new Font(Font.HELVETICA , 10, Font.NORMAL);		// font pour lignes d'entete
private static final Font fontLine = new Font(Font.HELVETICA , 8, Font.NORMAL);		// font pour lignes de listing
private DecimalFormat numFormat = new DecimalFormat("0.00");

private int widths[] = {8,5,9,31,11,14,4,14,14}; // largeurs des colonnes du listing

private boolean exocomplet;
private long debutPeriode;
private long finPeriode;
private String base;
private String baseDossier;
private String cpteDebut;
private String cpteFin;
private String edCpte;
private String edEcriture;
private String titre;
private String edition;
private String debutExercice;
private String finExercice;

private Connection con;


  public boolean serverSide() { return true; }

  public boolean service(Session s, ServletRequest r, Object info) throws Exception {


		con = s.getConnection(null);


		DecimalFormatSymbols dfs = new DecimalFormatSymbols();
		dfs.setDecimalSeparator('.');
		dfs.setGroupingSeparator(' ');

		numFormat.setDecimalFormatSymbols(dfs);
		numFormat.setGroupingUsed(true);
		numFormat.setGroupingSize(3);


		String dossierId = s.getCookie().get("Dossier_Id");
		this.base = s.getCookie().get("BaseExo");
		this.baseDossier = s.getCookie().get("BaseDossier");
		this.debutExercice = r.getParameter("Debut_Exercice");
		this.finExercice = r.getParameter("Fin_Exercice");
		String dateDebut = r.getParameter("Date_Debut");
		String dateFin = r.getParameter("Date_Fin");
		String type = r.getParameter("Type");
		String periode = r.getParameter("Periode");
		this.edition = r.getParameter("Edition");
		this.cpteDebut = r.getParameter("Cpte_Debut");
		this.cpteFin = r.getParameter("Cpte_Fin");
		this.edCpte = r.getParameter("Ed_Cpte");
		this.edEcriture = r.getParameter("Ed_Ecriture");


		if (periode.equals("dd")) {
			debutPeriode = DateTime.parseDate(dateDebut, "dd/MM/yy");
			finPeriode = DateTime.parseDate(dateFin, "dd/MM/yy");
			exocomplet = false;
		}
		else {
			debutPeriode = Long.parseLong(debutExercice);
			finPeriode = Long.parseLong(finExercice);
			exocomplet = true;
		}


		Document document = new Document(PageSize.A4, 25, 25, 25, 25);

		String chemin = s.getAppConfiguration().get("opensi.absdir") +"/pdf/";

		String fichierPdf = r.getParameter("FichierPDF");

		PdfWriter writer = PdfWriter.getInstance(document, new FileOutputStream(chemin + fichierPdf));

		MyPageEvent event = new MyPageEvent(dossierId);

		writer.setPageEvent(event);


		switch (type.charAt(0)) {
			case 'G': this.titre="G\u00E9n\u00E9ral";	break;
			case 'F': this.titre="Fournisseurs";			break;
			case 'C': this.titre="Clients";						break;
			case 'A': this.titre="Auxiliaires";				break;
			case 'T': this.titre="Clients";						break;
			default:	this.titre="G\u00E9n\u00E9ral";
		}

		document.open();


		PdfPTable listing = new PdfPTable(9);
		listing.setWidthPercentage(100);
		listing.setWidths(widths);

		if (type.equalsIgnoreCase("T")) {
			putGrandLivre(listing, "C");
			document.add(listing);
			listing = new PdfPTable(9);
			listing.setWidthPercentage(100);
			listing.setWidths(widths);
			this.titre="Fournisseurs";
			document.newPage();
			putGrandLivre(listing, "F");
			document.add(listing);
			listing = new PdfPTable(9);
			listing.setWidthPercentage(100);
			listing.setWidths(widths);
			this.titre="Auxiliaires";
			document.newPage();
			putGrandLivre(listing, "A");
			document.add(listing);
			listing = new PdfPTable(9);
			listing.setWidthPercentage(100);
			listing.setWidths(widths);
			this.titre="G\u00E9n\u00E9ral";
			document.newPage();
			putGrandLivre(listing, "G");
			document.add(listing);
		}
		else {
			putGrandLivre(listing, type);
			document.add(listing);
		}


		document.close();

		s.closeConnection(con, null);


		try {
			File filePdf = new File(chemin, fichierPdf);
			filePdf.deleteOnExit();
		}
		catch(SecurityException se) {
			s.trace("Impossible d'enregistrer le fichier  supprimer");
			se.printStackTrace();
		}


		return true;


	} // fin service


	private void putGrandLivre(PdfPTable listing, String typeLivre) throws Exception {

		ResultSet rset;  // operations
		ResultSet rset2; // journaux
		ResultSet rset3; // ecritures

		double soldeInter;
		double debitOp;
		double creditOp;

		boolean afficheCompte;

		String Numero;
		String Numero2;
		String Numero1;
		String index2 = "";
		String index1 = "";

		double solde2 = 0;
		double debit2 = 0;
		double credit2 = 0;

		double solde1 = 0;
		double debit1 = 0;
		double credit1 = 0;

		double solde = 0;
		double debit = 0;
		double credit = 0;

		double soldeCpte = 0;
		double debitCpte = 0;
		double creditCpte = 0;


		String reqComptes = "select Numero_Compte, Intitule, Centralisateur from "+ baseDossier +".COMPTE where Type_Compte='"+ typeLivre +"'";

		if (edition.equals("P")) {
			reqComptes += " and Numero_Compte<='"+ cpteFin +"' and Numero_Compte>='"+ cpteDebut +"'";
		}

		reqComptes += " order by Numero_Compte";


		String reqSoldesGen = "select sum(Montant_D) as Debit, sum(Montant_C) as Credit from "+ base +".OPERATION where Numero_Compte=?";
		String reqSoldesAux = "select sum(Montant_D) as Debit, sum(Montant_C) as Credit from "+ base +".OPERATION o,"+ baseDossier +".COMPTE c where c.Collectif=? and o.Numero_Compte=c.Numero_Compte";
		String reqOperations = "select Num_Piece, Date_Op, Code_Journal, Contrepartie, Libelle, Lettre, Montant_D, Montant_C from "+	base +".ECRITURE e,"+ base +".OPERATION o where o.Ecriture_Id=e.Ecriture_Id and o.Numero_Compte=?";


		if (!exocomplet) {
			String suiteReq = (Long.parseLong(debutExercice)==debutPeriode
												?" and Date_Op<="+ finPeriode
												:" and Date_Op<="+ finPeriode +" and Date_Op>="+ debutPeriode);

			reqSoldesGen += suiteReq;
			reqSoldesAux += suiteReq;
			reqOperations += suiteReq;
		}

		if (edEcriture.equalsIgnoreCase("N")) {
			reqOperations += " and Lettre=''";
		}
		else if (edEcriture.equalsIgnoreCase("S")) {
			reqOperations += " and Lettre<>''";
		}

		reqOperations += " order by Date_Op";


		PreparedStatement psSoldesGen = con.prepareStatement(reqSoldesGen);
		PreparedStatement psSoldesAux = con.prepareStatement(reqSoldesAux);
		PreparedStatement psOperations = con.prepareStatement(reqOperations);


		Statement stt = con.createStatement();
    rset = stt.executeQuery(reqComptes);

		while (rset.next()) {

			Numero = rset.getString("Numero_Compte");
			Numero2 = Numero.substring(0,2);
			Numero1 = Numero.substring(0,1);


			if (rset.getInt("Centralisateur")==1)
				{ psSoldesAux.setString(1, Numero); rset2 = psSoldesAux.executeQuery(); }
			else
				{	psSoldesGen.setString(1, Numero);	rset2 = psSoldesGen.executeQuery(); }


			while (rset2.next()) {

				debitCpte = rset2.getDouble("Debit");
				creditCpte = rset2.getDouble("Credit");
				soldeCpte = debitCpte - creditCpte;
			}
			rset2.close();


			if (!index2.equals("") && Numero2.compareTo(index2)!=0) {

				putLigneClasse(listing, index2, debit2, credit2, solde2);
				debit2 = 0;
				credit2 = 0;
				solde2 = 0;
			}

			if (!index1.equals("") && Numero1.compareTo(index1)!=0) {

				putLigneClasse1(listing, typeLivre, index1, debit1, credit1, solde1);
				debit1 = 0;
				credit1 = 0;
				solde1 = 0;
			}

			afficheCompte = edCpte.equalsIgnoreCase("T")?true:!(debitCpte-creditCpte<0.01 && debitCpte-creditCpte>-0.01);

			afficheCompte = afficheCompte && !(debitCpte<0.01 && creditCpte<0.01 && debitCpte>-0.01 && creditCpte>-0.01);

			if (afficheCompte) {

				putIntituleCompte(listing, rset.getString("Numero_Compte"), rset.getString("Intitule"));

				psOperations.setString(1, Numero);
				rset3 = psOperations.executeQuery();

				soldeInter = 0;

				while (rset3.next()) {

					creditOp = rset3.getDouble("Montant_C");
					debitOp = rset3.getDouble("Montant_D");
					soldeInter += debitOp - creditOp;

					if (soldeInter<0.01 && soldeInter>-0.01)
						soldeInter = 0;

					putLigneGrandLivre(listing, rset3.getLong("Date_Op"),rset3.getString("Code_Journal"),rset3.getString("Contrepartie"), rset3.getString("Libelle"),
					 rset3.getString("Num_Piece"), debitOp, rset3.getString("Lettre"), creditOp, soldeInter);
				}
				rset3.close();


				putTotalCompte(listing, rset.getString("Numero_Compte"), debitCpte, creditCpte, soldeCpte);


				solde2 += soldeCpte;
				debit2 += debitCpte;
				credit2 += creditCpte;

				solde1 += soldeCpte;
				debit1 += debitCpte;
				credit1 += creditCpte;

				if (!Numero1.equals("0")) {
					solde += soldeCpte;
					debit += debitCpte;
					credit += creditCpte;
				}

			}

			index2 = Numero2;
			index1 = Numero1;
		}

		putLigneClasse(listing, index2, debit2, credit2, solde2);
		putLigneClasse1(listing, typeLivre, index1, debit1, credit1, solde1);

		if (typeLivre.equalsIgnoreCase("G")) {
			putTotalGeneral(listing, debit, credit, solde);
		}

		rset.close();

		psSoldesAux.close();
		psSoldesGen.close();
		psOperations.close();

		stt.close();

	}


	/** Ajoute une ligne d'operation au listing */

	private void putLigneGrandLivre(PdfPTable listing, long dateOp, String codeJournal, String contrePartie, String libelle, String piece, double debit, String lettrage, double credit, double solde) {

		SimpleDateFormat formatDatePoint = new SimpleDateFormat("dd.MM.yy");

		PdfPCell cellListing = new PdfPCell(listing.getDefaultCell());

		cellListing.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
		cellListing.setBorder(PdfPCell.LEFT);
		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);

		cellListing.setPhrase(new Phrase(formatDatePoint.format(new Date(dateOp)), fontLine));
		listing.addCell(cellListing);

		cellListing.setBorder(PdfPCell.NO_BORDER);
		cellListing.setPhrase(new Phrase(codeJournal, fontLine));
		listing.addCell(cellListing);

		cellListing.setPhrase(new Phrase(contrePartie, fontLine));
		listing.addCell(cellListing);

		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
		cellListing.setPhrase(new Phrase(libelle, fontLine));
		listing.addCell(cellListing);

		cellListing.setBorder(PdfPCell.RIGHT);
		cellListing.setPhrase(new Phrase(piece, fontLine));
		listing.addCell(cellListing);

		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
		cellListing.setPaddingRight(5);
		cellListing.setPhrase(new Phrase(debit==0?"":numFormat.format(debit), fontLine));
		listing.addCell(cellListing);

		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
		cellListing.setPaddingRight(0);
		cellListing.setPhrase(new Phrase(lettrage, fontLine));
		listing.addCell(cellListing);

		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
		cellListing.setPaddingRight(5);
		cellListing.setPhrase(new Phrase(credit==0?"":numFormat.format(credit), fontLine));
		listing.addCell(cellListing);

		cellListing.setPhrase(new Phrase(numFormat.format(solde), fontLine));
		listing.addCell(cellListing);

	}

	/** Ajoute une ligne de total pour un journal au listing */

	private void putTotalGeneral(PdfPTable listing, double debit, double credit, double solde) {

		PdfPCell cellListing = new PdfPCell(listing.getDefaultCell());

		cellListing.setFixedHeight(20);
		cellListing.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
		cellListing.setBackgroundColor(Color.LIGHT_GRAY);
		cellListing.setBorder(PdfPCell.BOX - PdfPCell.RIGHT);
		cellListing.setPhrase(new Phrase("", fontLine));
		cellListing.setColspan(2);
		listing.addCell(cellListing);

		cellListing.setColspan(3);
		cellListing.setPhrase(new Phrase("TOTAL GENERAL", fontLine));
		cellListing.setBorder(PdfPCell.BOX - PdfPCell.LEFT);
		listing.addCell(cellListing);

		cellListing.setColspan(1);
		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
		cellListing.setBorder(PdfPCell.BOX);
		cellListing.setPaddingRight(5);
		cellListing.setPhrase(new Phrase(numFormat.format(debit), fontLine));
		listing.addCell(cellListing);
		cellListing.setPaddingRight(0);
		cellListing.setPhrase(new Phrase("", fontLine));
		listing.addCell(cellListing);
		cellListing.setPaddingRight(5);
		cellListing.setPhrase(new Phrase(numFormat.format(credit), fontLine));
		listing.addCell(cellListing);
		cellListing.setPhrase(new Phrase(numFormat.format(solde), fontLine));
		listing.addCell(cellListing);

	}

	private void putIntituleCompte(PdfPTable listing, String numCompte, String intitule) {

		PdfPCell cellListing = new PdfPCell(listing.getDefaultCell());

		cellListing.setFixedHeight(20);
		cellListing.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
		cellListing.setBorder(PdfPCell.BOX - PdfPCell.RIGHT-PdfPCell.BOTTOM);
		cellListing.setPhrase(new Phrase("", fontLine));
		cellListing.setColspan(2);
		listing.addCell(cellListing);

		cellListing.setColspan(3);
		cellListing.setPhrase(new Phrase(numCompte +" "+ intitule, fontLine));
		cellListing.setBorder(PdfPCell.TOP);
		listing.addCell(cellListing);

		cellListing.setColspan(1);
		cellListing.setPhrase(new Phrase("", fontLine));
		cellListing.setBorder(PdfPCell.BOX-PdfPCell.BOTTOM);
		listing.addCell(cellListing);
		listing.addCell(cellListing);
		listing.addCell(cellListing);
		listing.addCell(cellListing);

	}


	private void putTotalCompte(PdfPTable listing, String numCompte, double debit, double credit, double solde) {

		PdfPCell cellListing = new PdfPCell(listing.getDefaultCell());

		cellListing.setFixedHeight(20);
		cellListing.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
		cellListing.setBorder(PdfPCell.BOX - PdfPCell.RIGHT - PdfPCell.TOP);
		cellListing.setPhrase(new Phrase("", fontLine));
		cellListing.setColspan(2);
		listing.addCell(cellListing);

		cellListing.setColspan(3);
		cellListing.setPhrase(new Phrase("Total compte "+ numCompte, fontLine));
		cellListing.setBorder(PdfPCell.BOX - PdfPCell.LEFT - PdfPCell.TOP);
		listing.addCell(cellListing);

		cellListing.setColspan(1);
		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
		cellListing.setBorder(PdfPCell.BOX - PdfPCell.TOP);
		cellListing.setPaddingRight(5);
		cellListing.setPhrase(new Phrase(numFormat.format(debit), fontLine));
		listing.addCell(cellListing);
		cellListing.setPaddingRight(0);
		cellListing.setPhrase(new Phrase("", fontLine));
		listing.addCell(cellListing);
		cellListing.setPaddingRight(5);
		cellListing.setPhrase(new Phrase(numFormat.format(credit), fontLine));
		listing.addCell(cellListing);
		cellListing.setPhrase(new Phrase(numFormat.format(solde), fontLine));
		listing.addCell(cellListing);

	}


	private void putLigneClasse(PdfPTable listing, String index, double debit, double credit, double solde) {

		if (!(debit<0.01 && credit<0.01 && debit>-0.01 && credit>-0.01)) {

			PdfPCell cellListing = new PdfPCell(listing.getDefaultCell());

			cellListing.setFixedHeight(20);
			cellListing.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
			cellListing.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
			cellListing.setBackgroundColor(new Color(220,220,220));
			cellListing.setBorder(PdfPCell.BOX - PdfPCell.RIGHT);
			cellListing.setPhrase(new Phrase("", fontLine));
			cellListing.setColspan(2);
			listing.addCell(cellListing);

			cellListing.setColspan(3);
			cellListing.setPhrase(new Phrase("Total classe " + index, fontLine));
			cellListing.setBorder(PdfPCell.BOX - PdfPCell.LEFT);
			listing.addCell(cellListing);

			cellListing.setColspan(1);
			cellListing.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
			cellListing.setBorder(PdfPCell.BOX);
			cellListing.setPaddingRight(5);
			cellListing.setPhrase(new Phrase(numFormat.format(debit), fontLine));
			listing.addCell(cellListing);
			cellListing.setPaddingRight(0);
			cellListing.setPhrase(new Phrase("", fontLine));
			listing.addCell(cellListing);
			cellListing.setPaddingRight(5);
			cellListing.setPhrase(new Phrase(numFormat.format(credit), fontLine));
			listing.addCell(cellListing);
			cellListing.setPhrase(new Phrase(numFormat.format(solde), fontLine));
			listing.addCell(cellListing);
		}
	}


	private void putLigneClasse1(PdfPTable listing, String typeLivre, String index, double debit, double credit, double solde) {

		PdfPCell cellListing = new PdfPCell(listing.getDefaultCell());

		cellListing.setFixedHeight(20);
		cellListing.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
		cellListing.setBackgroundColor(new Color(200,200,200));
		cellListing.setBorder(PdfPCell.BOX - PdfPCell.RIGHT);
		cellListing.setPhrase(new Phrase("", fontLine));
		cellListing.setColspan(2);
		listing.addCell(cellListing);

		cellListing.setColspan(3);

		if (typeLivre.equalsIgnoreCase("C")) {
			cellListing.setPhrase(new Phrase("TOTAL CLIENTS", fontLine));
		}
		else if (typeLivre.equalsIgnoreCase("F")) {
			cellListing.setPhrase(new Phrase("TOTAL FOURNISSEURS", fontLine));
		}
		else if (typeLivre.equalsIgnoreCase("A")) {
			cellListing.setPhrase(new Phrase("TOTAL AUXILIAIRES", fontLine));
		}
		else {
			cellListing.setPhrase(new Phrase("Total classe " + index, fontLine));
		}

		cellListing.setBorder(PdfPCell.BOX - PdfPCell.LEFT);
		listing.addCell(cellListing);

		cellListing.setColspan(1);
		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
		cellListing.setBorder(PdfPCell.BOX);
		cellListing.setPaddingRight(5);
		cellListing.setPhrase(new Phrase(numFormat.format(debit), fontLine));
		listing.addCell(cellListing);
		cellListing.setPaddingRight(0);
		cellListing.setPhrase(new Phrase("", fontLine));
		listing.addCell(cellListing);
		cellListing.setPaddingRight(5);
		cellListing.setPhrase(new Phrase(numFormat.format(credit), fontLine));
		listing.addCell(cellListing);
		cellListing.setPhrase(new Phrase(numFormat.format(solde), fontLine));
		listing.addCell(cellListing);
	}


} // fin GenPdfGrandLivre



