/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/


package org.opensi.bo;


import java.sql.*;

import java.util.HashMap;
import java.util.Iterator;

import org.opensi.dbm.exercice.DBM_PeriodeExercice;
import org.opensi.dbm.exercice.DBM_Ecriture;
import org.opensi.dbm.dossier.DBM_Exercice;
import org.opensi.dbm.dossier.DBM_ParamDossier;
import org.opensi.dbm.exercice.DBM_SoldeCompte;

import org.opensi.data.exercice.PeriodeExercice;
import org.opensi.data.exercice.Operation;
import org.opensi.data.exercice.Ecriture;
import org.opensi.data.dossier.Exercice;
import org.opensi.data.exercice.SoldeCompte;

import org.opensi.util.sql.ScriptSQL;
import org.opensi.util.tools.DateTime;


public class BO_Exercices {

	private Connection con;
	private String baseDossier;
	private String baseExo;


	public BO_Exercices(Connection con, String baseDossier, String baseExo) {
		
		this.con = con;
		this.baseDossier = baseDossier;
		this.baseExo = baseExo;
	}


	public boolean isExoPrecClos(int exerciceId) throws SQLException {
		
		DBM_Exercice dbmExercice = new DBM_Exercice(con, baseDossier);
		Exercice exercice = getExercicePrecedent(dbmExercice.load(exerciceId));
		
		return exercice==null || exercice.getCloture();
	}
	
	
	public boolean checkPeriodeInExo(long periode) throws SQLException {
		
		PreparedStatement psPIE = con.prepareStatement("select 1 from "+ baseExo +".PERIODE_EXERCICE where Periode=?");
		psPIE.setLong(1, periode);
		ResultSet rset = psPIE.executeQuery();		
		boolean verif = rset.next();		
		psPIE.close();
		
		return verif;
	}
	
	
	public boolean checkDateInExo(long date) throws SQLException {
		
		PreparedStatement psDIE = con.prepareStatement("select 1 from "+ baseDossier +".EXERCICE where Debut_Exercice<=? and Fin_Exercice>=?");
		psDIE.setLong(1, date);
		psDIE.setLong(2, date);
		ResultSet rset = psDIE.executeQuery();		
		boolean verif = rset.next();		
		psDIE.close();
		
		return verif;
	}
		
	
	public void cloturerPeriodeExercice(long periode) throws SQLException {
	
		DBM_PeriodeExercice dbmPeriodeExercice = new DBM_PeriodeExercice(con, baseExo);
		dbmPeriodeExercice.cloturer(periode);
		
		// passage des critures de la priode  l'tat valid
		DBM_Ecriture dbmEcriture = new DBM_Ecriture(con, baseExo);
		dbmEcriture.validerPeriode(periode);
		
		// renumrotation finale des critures
		PreparedStatement psEcrPeriode = con.prepareStatement("select Ecriture_Id, Code_Journal from "+ baseExo +".ECRITURE where Date_Ecriture=? order by Code_Journal, Numero");
		psEcrPeriode.setLong(1, periode);
		ResultSet rset = psEcrPeriode.executeQuery();
		
		int i = 1;
		String currentJournal = "";
		
		while (rset.next()) {
			if (!rset.getString("Code_Journal").equalsIgnoreCase(currentJournal)) {
				i = 1;
				currentJournal = rset.getString("Code_Journal");
			}
			dbmEcriture.setNumero(rset.getInt("Ecriture_Id"), i++);
		}
		psEcrPeriode.close();		
	}
	
	
	public void generateANTemp(Exercice exerciceN, Exercice exerciceN1) throws SQLException {
		
		DBM_ParamDossier dbmParamDossier = new DBM_ParamDossier(con, baseDossier);
		genererANouveaux(dbmParamDossier.getCodeJournalAN(), exerciceN, exerciceN1, true, true, true);
	}
	
	
	public void cloturerExercice(Exercice exerciceN, Exercice exerciceN1, String journalAN, boolean detailTiers, boolean detailAux, boolean aExtourner, String journalEX, long dateEX) throws SQLException {
		
		DBM_Exercice dbmExercice = new DBM_Exercice(con, baseDossier);	
		dbmExercice.setCloture(exerciceN1.getExerciceId());

		genererANouveaux(journalAN, exerciceN, exerciceN1, detailTiers, detailAux, false);

		if (aExtourner) {				
			PreparedStatement psEAE = con.prepareStatement("select Ecriture_Id from "+ baseExo +".ECRITURE where Date_Ecriture=? and Code_Journal=?");
			psEAE.setLong(1, dateEX);
			psEAE.setString(2, journalEX);
			ResultSet rsE = psEAE.executeQuery();

			DBM_Ecriture dbmEcriture = new DBM_Ecriture(con, baseExo);
			BO_Ecritures boEcrituresN = new BO_Ecritures(con, baseDossier, exerciceN.getNomBase());

			while (rsE.next()) {
				Ecriture ecriture = dbmEcriture.loadWithOp(rsE.getInt(1));
				ecriture.setEcritureId(0);					
				ecriture.setCodeJournal(journalEX);
				ecriture.setDateEcriture(exerciceN.getDebutExercice());

				HashMap<Integer, Operation> operations = ecriture.getOperations();
				Iterator i = operations.keySet().iterator();

				while (i.hasNext()) {
					Operation op = operations.get(i.next());        

					op.setOpId(0);
					op.extourner();
					op.setLettre("");
					op.setDateOp(exerciceN.getDebutExercice());
				}

				boEcrituresN.saveEcriture(ecriture);
			}
		}
	}
	
	
	public void createExercice(Exercice currentExercice, String dossierId, String databaseDirectory, String journalAN, long newFinExercice) throws SQLException, java.io.IOException {			
		
		PreparedStatement psMaxExo = con.prepareStatement("select max(Num_Exercice) from "+ baseDossier +".EXERCICE");
		
		ResultSet rsME = psMaxExo.executeQuery();
		rsME.next();
		
		int newNumExercice = rsME.getInt(1) + 1;
		
		long finDernierExercice = currentExercice.getFinExercice();

		DateTime dfep = new DateTime(finDernierExercice);
		dfep.setDay(dfep.getDay()+1);
		long newDebutExercice = dfep.getDateInMillis();
	
		int newDureeExercice = DateTime.gapInMonths(newDebutExercice, newFinExercice);	
	
		String newBaseExo = "CPTA_"+ newNumExercice +"_"+ dossierId;
	
		PreparedStatement psNewBase = con.prepareStatement("create database "+ newBaseExo);	
		psNewBase.execute();
		psNewBase.close();
		
		ScriptSQL ssql = new ScriptSQL(con);		
		
		ssql.execute(databaseDirectory +"SchemaExercice.sql", newBaseExo);

		Exercice exercice = new Exercice();
		
		exercice.setNumExercice(newNumExercice);
		exercice.setDebutExercice(newDebutExercice);
		exercice.setFinExercice(newFinExercice);
		exercice.setDureeExercice(newDureeExercice);
		exercice.setNomBase(newBaseExo);
		
		DBM_Exercice dbmExercice = new DBM_Exercice(con, baseDossier);
		dbmExercice.insert(exercice);		
		
		// insertion des soldes de compte dans le nouvel exercice

		DBM_SoldeCompte dbmSoldeCompte = new DBM_SoldeCompte(con, newBaseExo);
		
		PreparedStatement psComptes = con.prepareStatement("select Numero_Compte from "+ baseDossier +".COMPTE");
		
		ResultSet rsC = psComptes.executeQuery();
		
		SoldeCompte sc = new SoldeCompte();
		
		while (rsC.next()) {
			sc.setNumeroCompte(rsC.getString("Numero_Compte"));
			dbmSoldeCompte.insert(sc);
		}				
		
		psComptes.close();
		
		// insertion des priodes d'exercice dans le nouvel exercice		
		
		PeriodeExercice periodeExercice = new PeriodeExercice();
		DBM_PeriodeExercice dbmPeriodeExercice = new DBM_PeriodeExercice(con, newBaseExo);
		
		String []tPeriodes = new org.opensi.util.PeriodesExo(newDebutExercice, newFinExercice).getPeriodes().split(",");

		for (int i=0; i<tPeriodes.length; i++) {
			periodeExercice.setPeriode(Long.parseLong(tPeriodes[i]));
			dbmPeriodeExercice.insert(periodeExercice);
		}
		
		// gnration des  nouveaux
		
		genererANouveaux(journalAN, exercice, currentExercice, true, true, true);	
	}
	
	
	public void genererANouveaux(String codeJournalAN, Exercice exerciceN, Exercice exerciceN1, boolean detailTiers, boolean detailAux, boolean temp) throws SQLException {
	
		String baseN = exerciceN.getNomBase();
		String baseN1 = exerciceN1.getNomBase();

		long dateANouveau = exerciceN.getDebutExercice();

		BO_Ecritures boEcritures = new BO_Ecritures(con, baseDossier, baseN);

		// suppression des anciennes critures d'a nouveau	

		PreparedStatement psOldAN = con.prepareStatement("select e.Ecriture_Id from "+ baseN +".ECRITURE e,"+ baseDossier +".JOURNAL j where j.Type_Journal='AN' and e.Code_Journal=j.Code_Journal");

		ResultSet rsOAN = psOldAN.executeQuery();

		while (rsOAN.next()) {			
			boEcritures.deleteEcriture(rsOAN.getInt("Ecriture_Id"));
		}
		rsOAN.close();

		String libelleSAN = (temp?"S.A.N. Temporaire":"S.A.N.");

		Ecriture ean = new Ecriture();
		ean.setCodeJournal(codeJournalAN);
		ean.setDateEcriture(dateANouveau);

		// oprations d' nouveaux pour les comptes de classes 1  5

		Statement stt = con.createStatement();

		String reqComptes15 = "select s.Numero_Compte, s.Total_Credit, s.Total_Debit from "+ baseN1 +".SOLDE_COMPTE s, "+ baseDossier +".COMPTE c "
												+ "where c.Numero_Compte=s.Numero_Compte and s.Solde<>0 and c.Centralisateur=0 and c.Type_Compte='G' "
												+ "and (c.Numero_Compte like '1%' or c.Numero_Compte like '2%' or c.Numero_Compte like '3%' or c.Numero_Compte like '4%' or c.Numero_Compte like '5%')";

		ResultSet rset = stt.executeQuery(reqComptes15);

		while (rset.next()) {

			double totalCredit = rset.getDouble("Total_Credit");
			double totalDebit = rset.getDouble("Total_Debit");

			Operation op = new Operation();
			op.setNumeroCompte(rset.getString("Numero_Compte"));
			op.setDateOp(dateANouveau);
			op.setLibelle(libelleSAN);

			if (totalCredit>totalDebit) {
				op.setMontantC(totalCredit-totalDebit);
				op.setMontantD(0);
			}
			else {
				op.setMontantC(0);
				op.setMontantD(totalDebit-totalCredit);
			}

			ean.addOperation(op);
		}

		// oprations d' nouveaux pour les oprations non lettres ou les comptes dont le solde est diffrent de 0 de l'exercice prcdent pour les comptes de tiers et/ou auxiliaires
		// selon l'option gnral de dtail des comptes de tiers et auxiliaires, si pas de dtail on reporte simplement les soldes, sinon on dtaille les oprations non lettres
		// pour les comptes dont l'option de detail est coche

		if (detailTiers || detailAux) { 
			
			String inTC = (detailTiers && detailAux?"'A','C','F'":detailTiers?"'C','F'":"'A'");
			
			String reqOpTiers = "select o.* from "+ baseDossier +".COMPTE c,"+ baseN1 +".OPERATION o "
												+	"where o.Lettre='' and o.Numero_Compte=c.Numero_Compte and c.Type_Compte in ("+ inTC +") and c.Detail_Cloture=1";

			rset = stt.executeQuery(reqOpTiers);

			while (rset.next()) {

				Operation op = new Operation();
				op.setNumeroCompte(rset.getString("Numero_Compte"));
				op.setDateOp(rset.getLong("Date_Op"));
				op.setLibelle(rset.getString("Libelle"));
				op.setMontantC(rset.getDouble("Montant_C"));
				op.setMontantD(rset.getDouble("Montant_D"));
				op.setDateEcheance(rset.getLong("Date_Echeance"));
				op.setNumPiece(rset.getString("Num_Piece"));
				op.setContrepartie(rset.getString("Contrepartie"));

				ean.addOperation(op);
			}
		}			

		String reqSoldesTiers = "select c.Numero_Compte, s.Total_Debit, s.Total_Credit from "+ baseN1 +".SOLDE_COMPTE s, "+ baseDossier +".COMPTE c"
													+ " where s.Numero_Compte=c.Numero_Compte and s.Solde<>0 and ((c.Type_Compte in ('C','F')"+ (detailTiers?" and c.Detail_Cloture=0":"") +") or (c.Type_Compte='A'"+ (detailAux?" and c.Detail_Cloture=0":"") +"))";

		rset = stt.executeQuery(reqSoldesTiers);

		while (rset.next()) {

			double credit = rset.getDouble("Total_Credit");
			double debit = rset.getDouble("Total_Debit");

			Operation op = new Operation();
			op.setNumeroCompte(rset.getString("Numero_Compte"));
			op.setDateOp(dateANouveau);
			op.setLibelle(libelleSAN);

			if (credit>debit) {
				op.setMontantC(credit-debit);
				op.setMontantD(0);
			}
			else {
				op.setMontantD(debit-credit);
				op.setMontantC(0);
			}

			ean.addOperation(op);
		}

		// actualisation du compte de rsultat (12000000)

		double resultat = resultat67(baseN1);

		Operation op = new Operation();
		op.setNumeroCompte("12000000");
		op.setDateOp(dateANouveau);
		op.setLibelle(libelleSAN);		

		if (resultat>0) {
			op.setMontantD(resultat);
		}
		else if (resultat<0) {
			op.setMontantC(-resultat);
		}	

		if (resultat!=0) {
			ean.addOperation(op);
		}		

		boEcritures.saveEcriture(ean);
	}
	
	
	public Exercice getExercicePrecedent(Exercice exerciceN) throws SQLException {
	
		PreparedStatement psExo = con.prepareStatement("select Exercice_Id from "+ baseDossier +".EXERCICE where Num_Exercice=?");
		
		psExo.setInt(1, exerciceN.getNumExercice()-1);
		ResultSet rsE = psExo.executeQuery();
		
		if (rsE.next()) {
			DBM_Exercice dbmExercice = new DBM_Exercice(con, baseDossier);
			return dbmExercice.load(rsE.getInt("Exercice_Id"));
		}
		else {
			return null;
		}		
	}
	
	
	public Exercice getExerciceSuivant(Exercice exerciceN) throws SQLException {
	
		PreparedStatement psExo = con.prepareStatement("select Exercice_Id from "+ baseDossier +".EXERCICE where Num_Exercice=?");
		
		psExo.setInt(1, exerciceN.getNumExercice()+1);
		ResultSet rsE = psExo.executeQuery();
		
		if (rsE.next()) {
			DBM_Exercice dbmExercice = new DBM_Exercice(con, baseDossier);
			return dbmExercice.load(rsE.getInt("Exercice_Id"));
		}
		else {
			return null;
		}		
	}
	
	
	public double soldeClasse(int numeroClasse, String baseExo) throws SQLException {
	
		PreparedStatement psSoldeClasse = con.prepareStatement("select coalesce(sum(Total_Debit)-sum(Total_Credit), 0) from "+ baseExo +".SOLDE_COMPTE where Numero_Compte like ?");
		
		psSoldeClasse.setString(1, numeroClasse +"%");
		ResultSet rsSC = psSoldeClasse.executeQuery();
		
		rsSC.next();
		
		double solde = rsSC.getDouble(1);
		
		rsSC.close();
		psSoldeClasse.close();
		
		return solde;
	}
	
	
	public double resultat67(String baseExo) throws SQLException {
	
		return soldeClasse(6, baseExo) + soldeClasse(7, baseExo);
	}
	
	
	public double resultat12345(String baseExo) throws SQLException {
	
		return soldeClasse(1, baseExo) + soldeClasse(2, baseExo) + soldeClasse(3, baseExo) + soldeClasse(4, baseExo) + soldeClasse(5, baseExo);
	}



} // fin BO_Exercices
