/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

package org.opensi.actions.exercice;


import java.sql.*;

import org.opensi.api.*;

import org.opensi.dbm.dossier.DBM_Exercice;
import org.opensi.data.dossier.Exercice;

import org.opensi.bo.BO_Exercices;
import org.opensi.bo.BO_Journaux;


public class CreateExercice implements ActionOSI {
	
	
	public void processAction(SessionOSI sosi, Parameters param, LeevElement result, ActionError error) throws Exception {
	
		Connection con = sosi.getConnection();
		String baseDossier = sosi.getBaseDossier();
		String dossierId = sosi.getDossierId();
		String databaseDirectory = sosi.getDatabaseDirectory();
		
		PreparedStatement psLastExo = con.prepareStatement("select Exercice_Id, Nom_Base from "+ baseDossier +".EXERCICE order by Num_Exercice desc limit 1");
		ResultSet rset = psLastExo.executeQuery();
		rset.next();
		String baseExo = rset.getString("Nom_Base");
		int exerciceId = rset.getInt("Exercice_Id");
		psLastExo.close();
		
		String journalAN = param.getParameter("JournalAN");
		long finExercice = param.getDateParameter("Fin_Exercice");
		
		BO_Exercices boExercices = new BO_Exercices(con, baseDossier, baseExo);
		BO_Journaux boJournaux = new BO_Journaux(con, baseDossier);
		DBM_Exercice dbmExercice = new DBM_Exercice(con, baseDossier);	
		
		Exercice exercice = dbmExercice.load(exerciceId);
		Exercice exoSuiv = boExercices.getExerciceSuivant(exercice);
		
		if (!boJournaux.isJournalAN(journalAN)) {
			error.addError(1, "Impossible de cr\u00E9er l'exercice : le journal d'\u00E0 nouveau est invalide !");
		}
		else if (exoSuiv!=null) {
			error.addError(1, "Impossible de cr\u00E9er l'exercice : l'exercice suivant existe d\u00E9j\u00E0 !");
		}
		else if (finExercice<=exercice.getFinExercice()) {
			error.addError(1, "Impossible de cr\u00E9er l'exercice : la date de fin d'exercice doit \u00EAtre sup\u00E9rieure \u00E0 la date de d\u00E9but d'exercice !");
		}
		else {		
			boExercices.createExercice(exercice, dossierId, databaseDirectory, journalAN, finExercice);
		}
	}		


} // fin CreateExercice

