/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

package org.opensi.actions.ecritures;


import java.sql.*;

import org.opensi.api.*;

import org.opensi.bo.BO_Ecritures;
import org.opensi.bo.BO_Comptes;

import org.opensi.util.sql.SqlUtils;


public class ChangeCompteOp implements ActionOSI {
	
	
	public void processAction(SessionOSI sosi, Parameters param, LeevElement result, ActionError error) throws Exception {
	
		Connection con = sosi.getConnection();
		String baseExo = sosi.getBaseExo();
		String baseDossier = sosi.getBaseDossier();
		
		String compteSrc = param.getParameter("CompteSrc");
		String compteDest = param.getParameter("CompteDest");
		boolean transAll = param.getBooleanParameter("TransAll");
		
		BO_Ecritures boEcritures = new BO_Ecritures(con, baseDossier, baseExo);
		BO_Comptes boComptes = new BO_Comptes(con, baseDossier, baseExo);
		
		if (!boComptes.isAssignableCompte(compteSrc)) {
			error.addError(1, "Impossible  d'effectuer le transfert car le num\u00E9ro de compte source est invalide !");
		}
		else if (!boComptes.isAssignableCompte(compteDest)) {
			error.addError(1, "Impossible  d'effectuer le transfert car le num\u00E9ro de compte de destination est invalide !");
		}
		else {
		
			if (transAll) {

				if (boEcritures.opCompteBelongToAN(compteSrc)) {
					error.addError(1, "Impossible d'effectuer le transfert car les \u00E9critures ne doivent pas faire partie du journal d'\u00E0 nouveau !");
				}
				else {		
					// Changement du compte sur toutes les oprations du compte compteSrc
					int nbTrans = boEcritures.changeCompteOp(compteSrc, compteDest, null);
					result.addEntity("NbOpTrans", nbTrans);
				}
			}
			else {
				String listeOp = SqlUtils.normalizeCSList(param.getParameter("Liste_Op"));

				// verification de l'equilibre du lettrage des operations selectionnes
				String listeLettresNonEqui = boEcritures.getLettresNonEqui(listeOp);

				if (boEcritures.opBelongToAN(listeOp)) {
					error.addError(1, "Impossible d'effectuer le transfert car les \u00E9critures ne doivent pas faire partie du journal d'\u00E0 nouveau !");
				}
				else if (listeLettresNonEqui!=null) {
					error.addError(1, "Impossible d'effectuer le transfert car le lettrage n'est pas \u00E9quilibr\u00E9 sur les lettres "+ listeLettresNonEqui +" !");
				}	
				else {
					// Changement du compte sur une slection d'oprations du compte compteSrc			
					int nbTrans = boEcritures.changeCompteOp(compteSrc, compteDest, listeOp);
					result.addEntity("NbOpTrans", nbTrans);
				}
			}
		}
	}
	

} // fin ChangeCompteOp

