/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

package org.opensi.actions.comptes;


import java.sql.*;

import org.opensi.api.*;

import org.opensi.bo.BO_Comptes;

import org.opensi.dbm.dossier.DBM_TrancheCollectif;

import org.opensi.data.dossier.TrancheCollectif;


public class SaveTrancheCollectif implements ActionOSI {
	
	
	public void processAction(SessionOSI sosi, Parameters param, LeevElement result, ActionError error) throws Exception {
	
		Connection con = sosi.getConnection();
		String baseDossier = sosi.getBaseDossier();
		String baseExo = sosi.getBaseExo();
		
		int trancheId = Integer.parseInt(param.getParameter("Tranche_Id"));
		
		DBM_TrancheCollectif dbmTrancheCollectif = new DBM_TrancheCollectif(con, baseDossier);				
		
		TrancheCollectif trancheCollectif = dbmTrancheCollectif.load(trancheId);
		
		String ancMinCompte = "";
		String ancMaxCompte = "";
		if (trancheCollectif==null) { trancheCollectif = new TrancheCollectif(); }
		else {
			ancMinCompte = trancheCollectif.getMinCompte();
			ancMaxCompte = trancheCollectif.getMaxCompte();
		}
		
		trancheCollectif.setMinCompte(param.getParameter("Compte_Debut"));
		trancheCollectif.setMaxCompte(param.getParameter("Compte_Fin"));
	
		BO_Comptes boComptes = new BO_Comptes(con, baseDossier, baseExo);
		
		
		if (!boComptes.isCompteGeneral(trancheCollectif.getMinCompte())) {
			error.addError(1003, "Le compte de d\u00E9but doit \u00EAtre de type G\u00E9n\u00E9ral.");
		}
		else if (!boComptes.isCompteGeneral(trancheCollectif.getMaxCompte())) {
			error.addError(1003, "Le compte de fin doit \u00EAtre de type G\u00E9n\u00E9ral.");
		}
		else if (trancheCollectif.getMinCompte().compareTo(trancheCollectif.getMaxCompte())>0) {
			error.addError(1003, "Le compte de d\u00E9but doit \u00EAtre inf\u00E9rieur au compte de fin.");
		}
		else if (!ancMinCompte.equals("") && !boComptes.isReductionPlageValide(ancMinCompte, trancheCollectif.getMinCompte(), trancheId)) {
			error.addError(1003, "La partie r\u00E9duite de la plage ne doit pas laisser de compte centralisateur sans plage.");
		}
		else if (!ancMaxCompte.equals("") && !boComptes.isReductionPlageValide(trancheCollectif.getMaxCompte(), ancMaxCompte, trancheId)) {
			error.addError(1003, "La partie r\u00E9duite de la plage ne doit pas laisser de compte centralisateur sans plage.");
		}
		else if (!boComptes.isPlageValide(trancheCollectif.getMinCompte(),trancheCollectif.getMaxCompte())) {
			error.addError(1003, "La plage de valeurs ne doit pas contenir un num\u00E9ro de compte non centralisateur existant.");
		}
		else {
			boComptes.saveTrancheCollectif(trancheCollectif, sosi.getDossierId());
		}
	}
	

} // fin SaveTrancheCollectif

