/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

package org.opensi.actions.commandeclient;


import java.sql.Connection;
import java.util.HashMap;
import java.util.Iterator;

import org.opensi.api.ActionError;
import org.opensi.api.ActionOSI;
import org.opensi.api.LeevElement;
import org.opensi.api.Parameters;
import org.opensi.api.SessionOSI;
import org.opensi.bo.commandeclient.BOCommandeClient;
import org.opensi.data.dossier.CommandeClient;
import org.opensi.data.dossier.HistoriqueCommandeClient;
import org.opensi.data.dossier.LigneCommandeClient;
import org.opensi.dbm.dossier.DBM_CommandeClient;
import org.opensi.dbm.dossier.DBM_HistoriqueCommandeClient;
import org.opensi.facturation.StockManager;
import org.opensi.util.tools.DateTime;


public class DebloquerCommande implements ActionOSI {
	
	BOCommandeClient boComCli = null;
	
	public void processAction(SessionOSI sosi, Parameters param, LeevElement result, ActionError error) throws Exception {
	
		Connection con = sosi.getConnection();
		String baseDossier = sosi.getBaseDossier();
		int user = sosi.getUtilisateurId();
		
		boComCli = new BOCommandeClient(con,baseDossier);
		DBM_CommandeClient dbmComCli = new DBM_CommandeClient(con,baseDossier);

		
		long dateCourante = new DateTime().getTimeInMillis();
		int utilM = user;
		int commandeClientId = Integer.parseInt(param.getParameter("Commande_Id"));
	
		CommandeClient commandeClient = dbmComCli.load(commandeClientId);
		
		commandeClient.setUtilM(utilM);
		commandeClient.setDateM(dateCourante);
		commandeClient.setBloque(false);

		CommandeClient commandeClientBase = dbmComCli.load(commandeClient.getCommandeId());

		if (!commandeClientBase.getBloque()) {
			error.addError(1001, "Impossible de dbloquer une commande non bloqu\u00E9e !");
		}
		else if (boComCli.isCloturee(commandeClientBase)) {
			error.addError(1002, "Impossible de dbloquer la commande car celle-ci est cl\u00F4tur\u00E9e !");
		}
		if (error.isEmpty()) {
			if (commandeClient.getEtat().equals("T")) {
				DBM_HistoriqueCommandeClient dbmHistComCli = new DBM_HistoriqueCommandeClient(con, baseDossier);
				HistoriqueCommandeClient histComCli = new HistoriqueCommandeClient(0,new DateTime().getTimeInMillis(),"",commandeClient.getCommandeId(),user, 0);
				
				HashMap<String, String> diff = commandeClient.diff(commandeClientBase, con, baseDossier);
				Iterator<String> i = diff.keySet().iterator();
				
				while (i.hasNext()) {
					String difference = i.next();
					histComCli.setLibelle(diff.get(difference));
					dbmHistComCli.save(histComCli);
				}
				StockManager stock = new StockManager (con,baseDossier);
				HashMap<Integer, LigneCommandeClient> liste = commandeClient.getLignesCommandeClient();
				Iterator<Integer> it = liste.keySet().iterator();
				while (it.hasNext()) {
					LigneCommandeClient lcc = liste.get(it.next());
					double diffStock = boComCli.getLigneQuantiteRestantLivree(lcc.getLigneId());
					if (diffStock>0) {
						stock.incComClients(lcc.getReference(), diffStock,commandeClient.getNumero(),"Modification Commande D\u00E9bloqu\u00E9e");
					}
				}
			}
			dbmComCli.save(commandeClient);
		}
	}
} // fin UpdateCommande

