/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

package org.opensi.actions.commandeclient;


import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

import org.opensi.api.ActionError;
import org.opensi.api.ActionOSI;
import org.opensi.api.LeevElement;
import org.opensi.api.Parameters;
import org.opensi.api.SessionOSI;
import org.opensi.bo.commandeclient.BOCommandeClient;
import org.opensi.data.dossier.CommandeClient;
import org.opensi.data.dossier.HistoriqueCommandeClient;
import org.opensi.data.dossier.LigneCommandeClient;
import org.opensi.dbm.dossier.DBM_CommandeClient;
import org.opensi.dbm.dossier.DBM_HistoriqueCommandeClient;
import org.opensi.dbm.dossier.DBM_LigneCommandeClient;
import org.opensi.facturation.StockManager;
import org.opensi.util.tools.DateTime;



public class CreateLigneCommande implements ActionOSI {
	
	
	BOCommandeClient boComCli = null;
	
	public void processAction(SessionOSI sosi, Parameters param, LeevElement result, ActionError error) throws Exception {
	
		Connection con = sosi.getConnection();
		String baseDossier = sosi.getBaseDossier();
		int user = sosi.getUtilisateurId();

		long datePeremption = param.getParameter("Date_Peremption").equals("")?0:param.getDateParameter("Date_Peremption");
		int nbPieces = param.getParameter("Nb_Pieces").equals("")?0:param.getIntParameter("Nb_Pieces");
		int codeTVA = param.getIntParameter("Code_TVA");
		int commandeId = (param.getNullParameter("Commande_Id")!=null)?param.getIntParameter("Commande_Id"):0;
		if (commandeId!=0) {
			String typeLigne = param.getParameter("Type_Ligne");
			String reference = param.getParameter("Reference");
			String designation = param.getParameter("Designation");
			double quantite = param.getDoubleParameter("Quantite");
			double prix = param.getDoubleParameter("Prix");
			double ristourne = param.getDoubleParameter("Ristourne");
			double commission = param.getDoubleParameter("Commission");
			String libelle = param.getParameter("Libelle");
			String codeStats = param.getParameter("Code_Stats");
			String unite = param.getParameter("Unite");
			String numLot = param.getParameter("Num_Lot");
	
			boComCli = new BOCommandeClient(con,baseDossier);
			DBM_CommandeClient dbmComCli = new DBM_CommandeClient(con,baseDossier);
			DBM_LigneCommandeClient dbmLigneComCli = new DBM_LigneCommandeClient(con,baseDossier);
	
	
			double tauxTVA = 0;
			PreparedStatement psSelTauxTVA = con.prepareStatement("select Taux_TVA from "+ baseDossier +".TAUX_TVA where Code_TVA=?");
			psSelTauxTVA.setInt(1, codeTVA);
			ResultSet rset = psSelTauxTVA.executeQuery();
			while (rset.next()) {
				tauxTVA =rset.getDouble("Taux_TVA");
			}
			rset.close();
			CommandeClient commandeClient = dbmComCli.load(commandeId);
			int rank = boComCli.getNextRank(commandeClient);
			
			double prixAchat = 0;
			if (typeLigne.equals("S")) {
				PreparedStatement psPrixAchat = con.prepareStatement("select Valorisation as Prix_Achat from "+ baseDossier +".STOCK_ANOUVEAU where Article_Id=? order by Periode desc limit 1");
				psPrixAchat.setString(1,reference);
				rset = psPrixAchat.executeQuery();
				if (rset.next()) {
					prixAchat = rset.getDouble("Prix_Achat");
				}
				rset.close();
			}
	
			LigneCommandeClient ligneCommandeClient = new LigneCommandeClient();
			ligneCommandeClient.setRank(rank);
			ligneCommandeClient.setTypeLigne(typeLigne);
			ligneCommandeClient.setReference(reference);
			ligneCommandeClient.setDesignation(designation);
			ligneCommandeClient.setQuantite(quantite);
			ligneCommandeClient.setPrix(prix);
			ligneCommandeClient.setRistourne(ristourne);
			ligneCommandeClient.setCommission(commission);
			ligneCommandeClient.setTauxTVA(tauxTVA);
			ligneCommandeClient.setCodeTVA(codeTVA);
			ligneCommandeClient.setLibelle(libelle);
			ligneCommandeClient.setCodeStats(codeStats);
			ligneCommandeClient.setUnite(unite);
			ligneCommandeClient.setNbPieces(nbPieces);
			ligneCommandeClient.setNumLot(numLot);
			ligneCommandeClient.setDatePeremption(datePeremption);
			ligneCommandeClient.setPrixAchat(prixAchat);
					
			if (commandeClient.getBloque()) {
				error.addError(1001, "Impossible de cr\u00E9er la commande car celle-ci est bloqu\u00E9e !");
			}
			if (boComCli.isCloturee(commandeClient)) {
				error.addError(1002, "Impossible de modifier la commande car celle-ci est cl\u00F4tur\u00E9e !");
			}
			if (boComCli.hasDocumentEnCours(commandeClient.getCommandeId())) {
				error.addError(1003, "Impossible de modifier la commande car celle-ci est li\u00E9e \u00E0 des documents en cours !");
			}
			if (error.isEmpty()) {
				int ligneId = dbmLigneComCli.insert(commandeId, ligneCommandeClient);
	
				if (commandeClient.getEtat().equals("T")) {
					DBM_HistoriqueCommandeClient dbmHistComCli = new DBM_HistoriqueCommandeClient(con, baseDossier);
					HistoriqueCommandeClient histComCli = new HistoriqueCommandeClient(0,new DateTime().getTimeInMillis(),"Ajout de l\'article "+reference,commandeClient.getCommandeId(),user, ligneId);
					dbmHistComCli.save(histComCli);
					StockManager stock = new StockManager (con,baseDossier);
					if (ligneCommandeClient.getTypeLigne().equals("S")) {
						stock.incComClients(ligneCommandeClient.getReference(), ligneCommandeClient.getQuantite(),commandeClient.getNumero(),"Modification Commande");
					}
				}
				boComCli.majTotaux(commandeId);
				boComCli.majStatuts(commandeId, user);
				
				dbmComCli.majModifCommande(commandeId, user);
				result.addEntity("Ligne_Id", ligneId);
			}
		}
		else {
			System.out.println("problme com"+user+" : "+baseDossier);
		}
	}
} // fin CreateDossier

