/*
 * Decompiled with CFR 0.152.
 */
package org.experlog.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.log4j.Category;
import org.experlog.db.DatasourceProperty;
import org.experlog.util.Configuration;
import org.experlog.util.ESCategory;

public class AppConfiguration
implements Configuration {
    Properties conf_;
    public String driverClass_ = "org.experlog.db.DummyDriver";
    public String user_ = "";
    public String password_ = "";
    public String jdbcUrl_ = "jdbc:openeas:default";
    public String resultSet_ = "";
    public int maxConn_ = 0;
    public int minConn_ = 0;
    public boolean usecookies_ = false;
    public int cookietimeout_ = 2592000;
    public String[] cookielist_ = null;
    public String jdbcTestStmt_ = "select 1";
    public int txIsolation_ = -32767;
    public boolean gc_ = true;
    public int checkLevelObject_ = 0;
    public String dataSourceName_ = null;
    public String sqlEncodeSubst = null;
    public String sqlEncodeSeparator = null;
    public String name_ = "openeas";
    public String adminPasswd_ = null;
    public String baseDir_ = "";
    public String rootDir_ = "";
    public String currency_ = "USD";
    public int timeout_ = 3600;
    public boolean servletsOnly_ = false;
    public String offtmpl_ = null;
    public String cacheFile_ = null;
    public String uploaddir_ = null;
    public long lifeTime = 600000L;
    public long sleepTime = 600000L;
    public int maxClients_ = 999999;
    public String encodingValue_ = "ISO-8859-1";
    Locale locale_ = Locale.getDefault();
    Locale appLocale_ = Locale.getDefault();
    boolean useFormatLocale_ = false;
    public Hashtable contentType_ = null;
    public String mbeanserver = "openeas";
    public String delegatefile = "";
    public String conffilename = "";
    public Category logger;
    public Hashtable datasources = null;

    public AppConfiguration() {
    }

    public AppConfiguration(String name, Properties props, boolean onWindows, String conffile, String basedir) {
        this.logger = ESCategory.getCategory(name, "openeas.util");
        this.name_ = name;
        this.conf_ = props;
        this.conffilename = conffile;
        if (basedir != null) {
            this.baseDir_ = basedir + (basedir.endsWith(File.separator) ? "" : File.separator);
        }
        this.parseProperties(props);
        String s = props.getProperty("app.delegateconfig");
        if (s != null) {
            this.delegatefile = s;
            try {
                Properties p = new Properties();
                FileInputStream f = new FileInputStream(this.delegatefile);
                p.load(f);
                this.parseProperties(p);
                f.close();
            }
            catch (FileNotFoundException e) {
            }
            catch (IOException f) {
                // empty catch block
            }
        }
    }

    public void parseProperties(Properties props) {
        String s = props.getProperty("jdbc.Driver");
        if (s != null) {
            this.driverClass_ = s.trim();
        }
        if ((s = props.getProperty("jdbc.Url")) != null) {
            this.jdbcUrl_ = this.expandString(s.trim());
        }
        if ((s = props.getProperty("jdbc.User")) != null) {
            this.user_ = s.trim();
        }
        if ((s = props.getProperty("jdbc.Password")) != null) {
            this.password_ = s.trim();
        }
        if ((s = props.getProperty("jdbc.ResultSet")) != null) {
            this.resultSet_ = s.trim();
        }
        String jdbcMaxConn = props.getProperty("jdbc.MaxConn");
        String jdbcMinConn = props.getProperty("jdbc.MinConn");
        this.minConn_ = this.computeMin(jdbcMinConn);
        this.maxConn_ = this.computeMax(jdbcMinConn, jdbcMaxConn);
        s = props.getProperty("jdbc.JdbcTestStmt");
        if (s != null) {
            this.jdbcTestStmt_ = s.trim();
        }
        if ((s = props.getProperty("jdbc.GC")) != null) {
            this.gc_ = s.trim().equalsIgnoreCase("true");
        }
        if ((s = props.getProperty("jdbc.CheckLevelObject")) != null) {
            try {
                this.checkLevelObject_ = Integer.parseInt(s.trim());
            }
            catch (NumberFormatException e) {
                this.logger.error((Object)"WARNING: No jdbc.CheckLevelObject specified, default 0.");
                this.checkLevelObject_ = 0;
            }
        }
        this.txIsolation_ = this.decodeTxIsolation(props.getProperty("jdbc.TxIsolation"));
        s = props.getProperty("jdbc.DataSource");
        if (s != null) {
            this.dataSourceName_ = s.trim();
        }
        if ((s = props.getProperty("console.applicationoff")) != null) {
            this.offtmpl_ = this.makePath(s.trim());
        }
        if ((s = props.getProperty("shop.CacheFile")) != null) {
            this.cacheFile_ = this.makePath(s.trim());
        }
        this.adminPasswd_ = (s = props.getProperty("shop.AdminPassword")) == null ? new String("admin") : s.trim();
        s = props.getProperty("app.RootDir");
        if (s == null) {
            s = props.getProperty("shop.RootDir");
        }
        if (s != null) {
            this.rootDir_ = this.makePath(s.trim());
        }
        if ((s = props.getProperty("shop.Currency")) != null) {
            this.currency_ = s.trim();
        }
        if ((s = props.getProperty("app.Timeout")) == null) {
            s = props.getProperty("shop.Timeout");
        }
        if (s != null) {
            try {
                this.timeout_ = Integer.parseInt(s.trim());
            }
            catch (NumberFormatException e) {
                this.logger.error((Object)"WARNING: app.Timeout syntax error, default 3600 sec.");
                this.timeout_ = 3600;
            }
        }
        if ((s = props.getProperty("app.usecookies")) != null) {
            this.usecookies_ = s.trim().equalsIgnoreCase("true");
            s = props.getProperty("app.cookietimeout");
            if (s != null) {
                try {
                    this.cookietimeout_ = Integer.parseInt(s.trim());
                }
                catch (NumberFormatException e) {
                    this.logger.error((Object)"WARNING: app.cookietimeout syntax error, default is 30 days.");
                    this.cookietimeout_ = 2592000;
                }
            }
            if ((s = props.getProperty("app.httpcookies")) != null) {
                StringTokenizer st = new StringTokenizer(s, ",");
                this.cookielist_ = new String[20];
                for (int i = 0; i < 20; ++i) {
                    this.cookielist_[i] = st.hasMoreTokens() ? st.nextToken().trim() : null;
                }
            }
        }
        if ((s = props.getProperty("app.Locale")) == null) {
            s = props.getProperty("shop.Locale");
        }
        if (s != null) {
            this.setLocale(s);
            this.appLocale_ = this.locale_;
        }
        this.useFormatLocale_ = "true".equalsIgnoreCase(props.getProperty("app.UseLocaleInFormats"));
        s = props.getProperty("app.ServletsOnly");
        if (s != null) {
            this.servletsOnly_ = Boolean.valueOf(s.trim());
        }
        if ((s = props.getProperty("app.UploadDir")) != null) {
            this.uploaddir_ = s.trim();
        }
        if ((s = props.getProperty("console.mbeanserver")) != null) {
            this.mbeanserver = s.trim();
        }
        if ((s = props.getProperty("sqlencode.Substitutions")) != null) {
            this.sqlEncodeSubst = s.trim();
        }
        if ((s = props.getProperty("jdbc.sqlencode.Substitutions")) != null) {
            this.sqlEncodeSubst = s.trim();
        }
        if ((s = props.getProperty("sqlencode.Separator")) != null) {
            this.sqlEncodeSeparator = s.trim();
        }
        if ((s = props.getProperty("jdbc.sqlencode.Separator")) != null) {
            this.sqlEncodeSeparator = s.trim();
        }
        if ((s = props.getProperty("app.MaxClients")) == null) {
            s = props.getProperty("shop.MaxClients");
        }
        if (s != null) {
            this.maxClients_ = Integer.parseInt(s.trim());
        }
        if ((s = props.getProperty("urlencode.charset")) != null) {
            this.encodingValue_ = s.trim();
        }
        if ((s = props.getProperty("trace.level")) != null) {
            ESCategory.setLevel(s.trim(), this.name_);
        } else {
            ESCategory.setLevel("ERROR", this.name_);
        }
        s = props.getProperty("trace.file");
        if (s != null) {
            ESCategory.setOutput(this.makePath(s.trim()), this.name_);
        }
        if ((s = props.getProperty("jdbc.LifeTime")) != null) {
            this.lifeTime = Long.parseLong(s);
        }
        if ((s = props.getProperty("jdbc.SleepTime")) != null) {
            this.sleepTime = Long.parseLong(s);
        }
        if ((s = props.getProperty("datasource.list")) != null) {
            this.datasources = new Hashtable();
            StringTokenizer tok = new StringTokenizer(s.trim(), ",");
            while (tok.hasMoreTokens()) {
                boolean dsok = true;
                String datasourceName = tok.nextToken().trim();
                s = props.getProperty("datasource." + datasourceName + ".Driver");
                DatasourceProperty dsprop = new DatasourceProperty(this.name_ + "__" + datasourceName);
                if (s != null) {
                    dsprop.setDriver(s.trim());
                } else {
                    dsok = false;
                    this.logger.error((Object)("Driver for datasource " + datasourceName + " must be defined"));
                }
                s = props.getProperty("datasource." + datasourceName + ".Url");
                if (s != null) {
                    dsprop.setUrl(this.expandString(s.trim()));
                } else {
                    dsok = false;
                    this.logger.error((Object)("Url for datasource " + datasourceName + " must be defined"));
                }
                s = props.getProperty("datasource." + datasourceName + ".User");
                if (s != null) {
                    dsprop.setUser(s.trim());
                } else {
                    dsprop.setUser("");
                }
                s = props.getProperty("datasource." + datasourceName + ".Password");
                if (s != null) {
                    dsprop.setPassword(s.trim());
                } else {
                    dsprop.setPassword("");
                }
                s = props.getProperty("datasource." + datasourceName + ".ResultSet");
                if (s != null) {
                    dsprop.setResultSet(s.trim());
                } else {
                    dsprop.setResultSet("");
                }
                s = props.getProperty("datasource." + datasourceName + ".TxIsolation");
                dsprop.setTxIsolation(this.decodeTxIsolation(s));
                String dsmaxConn = props.getProperty("datasource." + datasourceName + ".MaxConn");
                String dsminConn = props.getProperty("datasource." + datasourceName + ".MinConn");
                s = props.getProperty("datasource." + datasourceName + ".sqlencode.Substitutions");
                if (s != null) {
                    dsprop.setSqlEncodeSubst(s.trim());
                }
                s = props.getProperty("datasource." + datasourceName + ".sqlencode.Separator");
                s = props.getProperty("datasource." + datasourceName + ".LifeTime");
                if (s != null) {
                    dsprop.setLifeTime(Long.parseLong(s));
                } else {
                    dsprop.setLifeTime(this.lifeTime);
                }
                s = props.getProperty("datasource." + datasourceName + ".SleepTime");
                if (s != null) {
                    dsprop.setSleepTime(Long.parseLong(s));
                } else {
                    dsprop.setSleepTime(this.sleepTime);
                }
                if (s != null) {
                    dsprop.setSqlEncodeSeparator(s.trim());
                }
                dsprop.setMinConn(this.computeMin(dsminConn));
                dsprop.setMaxConn(this.computeMax(dsminConn, dsmaxConn));
                if (!dsok) continue;
                this.datasources.put(this.name_ + "__" + datasourceName, dsprop);
            }
        }
        if ((s = props.getProperty("contenttype.list")) != null) {
            this.contentType_ = new Hashtable();
            StringTokenizer atok = new StringTokenizer(s.trim(), ",");
            while (atok.hasMoreTokens()) {
                String typeName = atok.nextToken().trim();
                String typeValue = props.getProperty("contenttype." + typeName + ".value");
                this.contentType_.put(typeName, typeValue);
            }
        }
    }

    private String expandString(String s) {
        int pos = s.indexOf("${WEBAPP_PATH}");
        if (pos >= 0) {
            StringBuffer b = new StringBuffer(pos > 0 ? s.substring(0, pos) : "");
            b.append(this.baseDir_.substring(0, this.baseDir_.length() - 1));
            if (s.length() > pos + 14) {
                b.append(s.substring(pos + 14));
            }
            return b.toString();
        }
        return s;
    }

    private String makePath(String s) {
        if (new File(s).isAbsolute()) {
            return s;
        }
        return this.baseDir_ + s;
    }

    private int computeMin(String minC) {
        int iminC = 0;
        if (minC == null) {
            return 1;
        }
        try {
            iminC = Integer.parseInt(minC.trim());
        }
        catch (NumberFormatException e) {
            this.logger.error((Object)"WARNING: No min of connection, not specified.");
        }
        return iminC;
    }

    private int computeMax(String minC, String maxC) {
        int iminC = 0;
        int imaxC = 0;
        if (maxC != null) {
            try {
                imaxC = Integer.parseInt(maxC.trim());
            }
            catch (NumberFormatException e) {
                this.logger.error((Object)"WARNING: No min of connection, not specified.");
            }
            return imaxC;
        }
        if (minC == null) {
            return 1;
        }
        try {
            iminC = Integer.parseInt(minC.trim());
        }
        catch (NumberFormatException e) {
            this.logger.error((Object)"WARNING: No min of connection, not specified.");
        }
        return iminC;
    }

    public String getSqlEncodeSubst(String datasourcename) {
        if (datasourcename == null) {
            return this.sqlEncodeSubst;
        }
        if (this.datasources != null) {
            for (DatasourceProperty dsprop : this.datasources.values()) {
                if (dsprop.getName().compareTo(this.name_ + "__" + datasourcename) != 0) continue;
                return dsprop.getSqlEncodeSubst();
            }
        }
        return null;
    }

    public String getSqlEncodeSeparator(String datasourcename) {
        if (datasourcename == null) {
            return this.sqlEncodeSeparator;
        }
        if (this.datasources != null) {
            for (DatasourceProperty dsprop : this.datasources.values()) {
                if (dsprop.getName().compareTo(this.name_ + "__" + datasourcename) != 0) continue;
                return dsprop.getSqlEncodeSeparator();
            }
        }
        return null;
    }

    public Hashtable getDatasources() {
        return this.datasources;
    }

    public String getJdbcDriverClass() {
        return this.driverClass_;
    }

    public String getDataSourceName() {
        return this.dataSourceName_;
    }

    public String getJdbcUser() {
        return this.user_;
    }

    public String getJdbcPassword() {
        return this.password_;
    }

    public String getJdbcUrl() {
        return this.jdbcUrl_;
    }

    public String getResultSet() {
        return this.resultSet_;
    }

    public int getMaxConn() {
        return this.maxConn_;
    }

    public int getMinConn() {
        return this.minConn_;
    }

    public String getJdbcTestStmt() {
        return this.jdbcTestStmt_;
    }

    public boolean isGC() {
        return this.gc_;
    }

    public int getCheckLevelObject() {
        return this.checkLevelObject_;
    }

    public String getDriverClass() {
        return this.driverClass_;
    }

    public String getMbeanserver() {
        return this.mbeanserver;
    }

    public String getDelegatefile() {
        return this.delegatefile;
    }

    public String getConffilename() {
        return this.conffilename;
    }

    public int getMaxClients() {
        return this.maxClients_;
    }

    public String getEncodingValue() {
        return this.encodingValue_;
    }

    public long getLifeTime() {
        return this.lifeTime;
    }

    public long getSleepTime() {
        return this.sleepTime;
    }

    public void setJdbcDriverClass(String driverclass) {
        this.driverClass_ = driverclass;
    }

    public void setDataSourceName(String datasourcename) {
        this.dataSourceName_ = datasourcename;
    }

    public void setJdbcUser(String user) {
        this.user_ = user;
    }

    public void setJdbcPassword(String password) {
        this.password_ = password;
    }

    public void setJdbcUrl(String jdbcurl) {
        this.jdbcUrl_ = jdbcurl;
    }

    public void setMaxConn(int maxconn) {
        this.maxConn_ = maxconn;
    }

    public void setMinConn(int minconn) {
        this.minConn_ = minconn;
    }

    public void setJdbcTestStmt(String jdbcteststmt) {
        this.jdbcTestStmt_ = jdbcteststmt;
    }

    public void setGC(boolean gc) {
        this.gc_ = gc;
    }

    public void setCheckLevelObject(int checklevelobject) {
        this.checkLevelObject_ = checklevelobject;
    }

    public void setDriverClass(String driverclass) {
        this.driverClass_ = driverclass;
    }

    public void setTimeout(int time) {
        this.timeout_ = time;
    }

    public void setDelegatefile(String dfile) {
        this.delegatefile = dfile;
        this.conf_.setProperty("app.delegateconfig", dfile);
    }

    public void setMaxClients(int mc) {
        this.maxClients_ = mc;
    }

    public void setEcondingValue(String encodingValue) {
        this.encodingValue_ = encodingValue;
    }

    public String getContentType(String atype) {
        String ct = (String)this.contentType_.get(atype);
        return ct == null ? "text/html" : ct;
    }

    public String getName() {
        return this.name_;
    }

    public String getAdminPassword(String id) {
        if (id == null) {
            return this.adminPasswd_;
        }
        try {
            return this.get("shop.AdminPassword." + id);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getRootDir() {
        return this.rootDir_;
    }

    public String getCurrency() {
        return this.currency_;
    }

    public Locale getLocale() {
        return this.locale_;
    }

    public Locale getFormatLocale() {
        return this.useFormatLocale_ ? this.locale_ : this.appLocale_;
    }

    public void setLocale(String s) {
        if (s == null) {
            return;
        }
        if ((s = s.trim()).length() < 1) {
            try {
                s = this.get("app.Locale");
                if (s == null) {
                    s = this.get("shop.Locale");
                }
            }
            catch (Exception e) {
                s = null;
            }
            if (s == null) {
                this.locale_ = Locale.getDefault();
                return;
            }
        }
        StringTokenizer st = new StringTokenizer(s, "_");
        String llang = "en";
        String lcntr = null;
        if (st.hasMoreTokens()) {
            llang = st.nextToken();
        }
        if (st.hasMoreTokens()) {
            lcntr = st.nextToken();
        }
        this.locale_ = st.hasMoreTokens() ? new Locale(llang, lcntr, st.nextToken()) : (lcntr != null ? new Locale(llang, lcntr) : new Locale(llang));
    }

    public int getTimeout() {
        return this.timeout_;
    }

    public boolean servletsOnly() {
        return this.servletsOnly_;
    }

    public boolean useCookies() {
        return this.usecookies_;
    }

    public int getCookieTimeout() {
        return this.cookietimeout_;
    }

    public boolean storeInCookie(String name) {
        if (this.cookielist_ == null) {
            return false;
        }
        for (int i = 0; i < 20 && this.cookielist_[i] != null; ++i) {
            if (!this.cookielist_[i].equals(name)) continue;
            return true;
        }
        return false;
    }

    public String get(String pname) throws SQLException {
        String s = this.conf_.getProperty(pname);
        return s == null ? null : s.trim();
    }

    public String get(String pname, String value) throws SQLException {
        String s = this.conf_.getProperty(pname, value);
        return s == null ? null : s.trim();
    }

    public double getDouble(String pname) throws IOException {
        String v;
        try {
            v = this.get(pname);
        }
        catch (Exception e) {
            v = null;
        }
        if (v == null) {
            throw new IOException("No such property: " + pname);
        }
        try {
            return Double.valueOf(v);
        }
        catch (NumberFormatException e) {
            throw new IOException("Double number format exception for " + pname + ": " + v);
        }
    }

    public void setOfftmpl(String off) {
        this.offtmpl_ = this.makePath(off);
    }

    public String getOfftmpl() {
        return this.offtmpl_;
    }

    public String getCacheFile() {
        return this.cacheFile_;
    }

    public static boolean isSecurePath(String path) {
        if (path == null) {
            return false;
        }
        return (path = path.replace(File.separatorChar, '/')).indexOf(42) < 0 && path.indexOf(63) < 0 && path.indexOf(126) < 0 && path.indexOf(91) < 0 && path.indexOf(93) < 0 && path.indexOf(39) < 0 && path.indexOf(96) < 0 && path.indexOf(36) < 0 && path.indexOf("..") < 0;
    }

    public static boolean isSecurePathStrong(String path, String updir) {
        if (AppConfiguration.isSecurePath(path)) {
            if (path.startsWith(updir)) {
                return true;
            }
            return !path.startsWith("/");
        }
        return false;
    }

    public String getUploadDir() {
        return this.uploaddir_ == null ? null : this.makePath(this.uploaddir_.trim());
    }

    public int getJdbcTxIsolation() {
        return this.txIsolation_;
    }

    private int decodeTxIsolation(String level) {
        if (level == null) {
            return -32767;
        }
        if ((level = level.trim().toUpperCase()).equals("NONE")) {
            return 0;
        }
        if (level.equals("READ_COMMITTED")) {
            return 2;
        }
        if (level.equals("READ_UNCOMMITTED")) {
            return 1;
        }
        if (level.equals("REPEATABLE_READ")) {
            return 4;
        }
        if (level.equals("SERIALIZABLE")) {
            return 8;
        }
        return -32767;
    }
}

