/*
 * Decompiled with CFR 0.152.
 */
package org.experlog.gencode;

import org.experlog.gencode.ExpOperand;

public class ExpEval {
    public double eval(ExpOperand formula) {
        if (formula == null) {
            return 0.0;
        }
        if (formula.isStringValue()) {
            return 1.0;
        }
        return this.eval2(formula);
    }

    double eval2(ExpOperand formula) {
        int operator = formula.getOperator();
        switch (operator) {
            case 1: {
                return formula.getNumericValue();
            }
            case 11: {
                return this.eval2(formula.singleTerm()) == 0.0 ? 1 : 0;
            }
            case 10: {
                double val = this.eval2(formula.leftTerm()) + this.eval2(formula.rightTerm());
                return val != 0.0 ? 1 : 0;
            }
            case 9: {
                double val = this.eval2(formula.leftTerm()) * this.eval2(formula.rightTerm());
                return val != 0.0 ? 1 : 0;
            }
            case 18: {
                return -this.eval2(formula.singleTerm());
            }
            case 4: {
                return Math.pow(this.eval2(formula.leftTerm()), this.eval2(formula.rightTerm()));
            }
            case 5: {
                return this.eval2(formula.leftTerm()) * this.eval2(formula.rightTerm());
            }
            case 6: {
                return this.eval2(formula.leftTerm()) / this.eval2(formula.rightTerm());
            }
            case 7: {
                return this.eval2(formula.leftTerm()) + this.eval2(formula.rightTerm());
            }
            case 8: {
                return this.eval2(formula.leftTerm()) - this.eval2(formula.rightTerm());
            }
            case 14: {
                return this.eval2(formula.leftTerm()) > this.eval2(formula.rightTerm()) ? 1.0 : 0.0;
            }
            case 16: {
                return this.eval2(formula.leftTerm()) >= this.eval2(formula.rightTerm()) ? 1.0 : 0.0;
            }
            case 15: {
                return this.eval2(formula.leftTerm()) < this.eval2(formula.rightTerm()) ? 1.0 : 0.0;
            }
            case 17: {
                return this.eval2(formula.leftTerm()) <= this.eval2(formula.rightTerm()) ? 1.0 : 0.0;
            }
            case 12: {
                if (formula.leftTerm().isStringValue() || formula.rightTerm().isStringValue()) {
                    String sval = formula.leftTerm().getStringValue();
                    return sval.equals(formula.rightTerm().getStringValue()) ? 1 : 0;
                }
                double val = this.eval2(formula.leftTerm());
                return val == this.eval2(formula.rightTerm()) ? 1 : 0;
            }
            case 13: {
                if (formula.leftTerm().isStringValue() || formula.rightTerm().isStringValue()) {
                    String sval = formula.leftTerm().getStringValue();
                    return !sval.equals(formula.rightTerm().getStringValue()) ? 1 : 0;
                }
                double val = this.eval2(formula.leftTerm());
                return val != this.eval2(formula.rightTerm()) ? 1 : 0;
            }
        }
        return 0.0;
    }
}

