package webmaj;

import java.io.File;
import java.io.FileWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Timestamp;

import org.opensi.webmanager.utils.ToolsMAJ;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class JobMaj implements Job {

	protected File aEcrire;
	protected FileWriter fichier;
	protected JobDataMap mapDeParams;
	protected String url_bd;
	protected String nom_bd;
	protected String login;
	protected String mdp;
	protected String site_id;
	protected String dossier_id;
	protected String url_serveur;
	protected String dossier_root;
	protected String nom_job;
	protected String timeout;
	protected String nbRaps;
	protected String tailleP;
	
	protected String type;
	protected String nomfichier;
	
	protected Connection connexion;
	
  public JobMaj() 
  {
  	aEcrire=new File("ServeurQuartz.log");//le fichier de log
  }
  public JobMaj(String nom) 
  {
  	aEcrire=new File(nom);//le fichier de log
  }	
  public void execute(JobExecutionContext context) throws JobExecutionException {
	  mapDeParams=context.getMergedJobDataMap();
		url_bd=mapDeParams.getString("url_bd");
		nom_bd=mapDeParams.getString("nom_bd");
		login=mapDeParams.getString("login");
		mdp=mapDeParams.getString("mdp");
		site_id=mapDeParams.getString("site_id");
		dossier_id=mapDeParams.getString("dossier_id");
		url_serveur=mapDeParams.getString("url_serveur");
		dossier_root=mapDeParams.getString("dossier_root");
		nom_job=mapDeParams.getString("nom_job");
		timeout=mapDeParams.getString("timeout");
		nbRaps=mapDeParams.getString("nb_rapports");
		tailleP=mapDeParams.getString("taille_paquets");
		
		ToolsMAJ.ecrireLog(aEcrire,type,"************************\n");
		ToolsMAJ.ecrireLog(aEcrire,type,"Debut de l'opration");


		ToolsMAJ.ecrireLog(aEcrire,type,"Debut rel");

		java.util.Date date =new java.util.Date();
		Timestamp stamp=new Timestamp(date.getTime());
		String dateDebut=""+stamp;

		ToolsMAJ.ecrireLog(aEcrire,type,"Job:"+nom_job+" execut :"+dateDebut+"\n");
		try {
			connexion = DriverManager.getConnection(url_bd,login,mdp);
		} catch (SQLException e) {
			ToolsMAJ.ecrireLog(aEcrire,type,"ERREUR:"+e);
		}	
	}
  
  public void fin() {
		ToolsMAJ.ecrireLog(aEcrire,type,"Je ferme la connexion");
		try {
			connexion.close();
		} catch (SQLException e) {
			ToolsMAJ.ecrireLog(aEcrire,type,"Fin rele"+e);
		}
		java.util.Date dateFin =new java.util.Date();
		Timestamp stampFin=new Timestamp(dateFin.getTime());
		String dateFini=""+stampFin;
		ToolsMAJ.ecrireLog(aEcrire,type,"Job:"+nom_job+" fini :"+dateFini+"\n");
		ToolsMAJ.ecrireLog(aEcrire,type,"Fin rele");
		ToolsMAJ.ecrireLog(aEcrire,type,"Mutex relach rel");
  }
}
