package org.opensi.webmanager.utils;

/**
 * Permet de rcuprer les informations du rapport retourn par le service
 */
public class TraitementRapport {

	/* ******* Constantes de russite ********** */

	Object[] rapport;

	/**
	 * Initialisation. Un rapport doit tre structur de la forme:</br> Un
	 * tableau d'Object reprsentant une liste d'item.</br> Chaque item tant un
	 * Object[3] avec dans l'ordre:</br> le code d'erreur ou de russite</br> la
	 * source </br> le commentaire
	 * 
	 * @param leRapport
	 *          le rapport brut
	 */
	public TraitementRapport(Object[] leRapport) {
		rapport = leRapport;
	}

	/**
	 * donne le nombre d'item dans le rapport
	 * 
	 * @return la taille du rapport
	 */
	public int getTaille() {
		return rapport.length;

	}

	/**
	 * Permet de savoir pour un item du rapport, si c'est un chec ou une
	 * russite.
	 * 
	 * @param num_de_ligne
	 *          numro de ligne du rapport concerne
	 * @return vrai si l'opration a russi, faux si elle a choue
	 */
	public boolean aReussi(int num_de_ligne) {
		Object[] contenu = (Object[]) rapport[num_de_ligne];
		int code = Integer.parseInt("" + contenu[0]);
		return (code < 100);

	}

	/**
	 * Donne la source de la ligne du rapport
	 * 
	 * @param num_de_ligne
	 *          numro de ligne du rapport
	 * @return l'objet  la source de la cration de cette ligne de rapport
	 */
	public String getSource(int num_de_ligne) {
		Object[] contenu = (Object[]) rapport[num_de_ligne];
		return "" + contenu[1];
	}

	/**
	 * Donne des dtails sur la russite ou l'echec
	 * 
	 * @param num_de_ligne
	 *          numro de ligne concerne
	 * @return le commentaire associ  cette ligne
	 */
	public String getCommentaire(int num_de_ligne) {
		Object[] contenu = (Object[]) rapport[num_de_ligne];
		return "" + contenu[2];
	}

	/**
	 * Donne un message humainement comprehensible
	 * 
	 * @param num_de_ligne
	 *          numro de ligne concerne
	 * @return le message
	 */
	public String getMessageUtilisateur(int num_de_ligne) {
		Object[] contenu = (Object[]) rapport[num_de_ligne];
		int code = Integer.parseInt("" + contenu[0]);
		String source = "" + contenu[1];

		switch (code) {
			/* les russites */
			case ConstantesRapport.CONNEXION_SERVEUR_BASE_OK:
				return "Connexion au serveur de la base de donne '" + source + "' russie";

			case ConstantesRapport.CONNEXION_BASE_OK:
				return "Connexion  la base de donne '" + source + "' russie";

			case ConstantesRapport.INSERT_OK:
				return "Insertion de '" + source + "' russie";

			case ConstantesRapport.UPDATE_OK:
				return "Modification de '" + source + "' russie";

			case ConstantesRapport.DELETE_OK:
				return "Suppression de '" + source + "' russie";

			case ConstantesRapport.SELECT_OK:
				return "Lecture de '" + source + "' russie";

				/* Les echecs */
			case ConstantesRapport.CONNEXION_SERVEUR_BASE_KO:
				return "Connexion au serveur de la base de donne '" + source + "' choue";

			case ConstantesRapport.CONNEXION_BASE_KO:
				return "Connexion  la base de donne '" + source + "' choue";

			case ConstantesRapport.INSERT_KO:
				return "Insertion de '" + source + "' choue";

			case ConstantesRapport.UPDATE_KO:
				return "Modification de '" + source + "' choue";

			case ConstantesRapport.DELETE_KO:
				return "Suppression de '" + source + "' choue";

			case ConstantesRapport.SELECT_KO:
				return "Lecture de '" + source + "' choue";

			default:
				return " russite ou echec, telle est la question:" + code;

		}

	}

	/**
	 * 
	 * @return
	 */
	public boolean yADesEchecs() {
		boolean result = true;

		for (int i = 0; i < getTaille(); i++) {
			result = result && aReussi(i);
		}

		return result;
	}

}
