package org.opensi.webmanager.utils;

import java.util.HashMap;
import java.util.Vector;


public class TraitementFamilles {

	private Vector<String> familleVersNumero;

	private HashMap<String, Famille> familles;

	/**
	 * 
	 * @param listeArticles
	 */
	public TraitementFamilles(Object[] listeArticles) {

		familleVersNumero = new Vector<String>();
		familles = new HashMap<String, Famille>();

		String familleTemp;
		String sousFamilleTemp;

		int indexFamilleEnCours = 0;
		for (int i = 0; i < listeArticles.length; i++) {
			Object[] unArticle = (Object[]) listeArticles[i];
			ArticleStruct unArticleStruct = new ArticleStruct(unArticle);

			familleTemp = unArticleStruct.getSqlString(unArticleStruct.FAMILLE,40);
			sousFamilleTemp = unArticleStruct.getSqlString(unArticleStruct.SOUS_FAMILLE,40);

			// Si la famille n'existe pas , on la cre
			if (!familleVersNumero.contains(familleTemp)) {
				indexFamilleEnCours++;
				familleVersNumero.add(familleTemp);
				Famille fam = new Famille(indexFamilleEnCours, familleTemp, sousFamilleTemp);
				familles.put(familleTemp, fam);

			}
			else {
				// Si la sous famille n'existe pas, on la cre
				Famille famTemp = familles.get(familleTemp);
				if (!famTemp.existSousFamille(sousFamilleTemp)) {
					famTemp.addSousFamille(sousFamilleTemp);
				}
			}

		}

	}

	/**
	 * 
	 * @return
	 */
	public int getNbFamilles() {
		return familles.size();
	}

	/**
	 * 
	 * @param i
	 * @return
	 */
	public Famille getFamilleAt(int i) {
		String nomFamille = "" + familleVersNumero.elementAt(i);
		return familles.get(nomFamille);
	}

}
