/*
 * Copyright 2001-2004 The Apache Software Foundation.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.opensi.webmanager.utils;

import java.util.HashMap;
import java.util.Vector;

import javax.xml.namespace.QName;
import javax.xml.rpc.ParameterMode;

import org.apache.axis.Constants;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;

/**
 * Facilite l'utilsation de SOAP
 */
public class SoapFacile {
	private String url;

	private Vector<HashMap<String, Object>> typeParametres;

	private Vector<Object> valeurParametre;

	private QName typeRetour;

	private Integer timeout;

	// ********* CONSTANTES ******************

	/**
	 * type de paramtre SOAP
	 */
	public static ParameterMode mode_in = ParameterMode.IN;

	/**
	 * type de paramtre SOAP
	 */
	public static ParameterMode mode_inout = ParameterMode.INOUT;

	/**
	 * type de paramtre SOAP
	 */
	public static ParameterMode mode_out = ParameterMode.OUT;

	// ************ FIN ***********************

	/**
	 * 
	 * @param url_site
	 * @param leTimeout
	 */
	public SoapFacile(String url_site, Integer leTimeout) {
		url = url_site;
		typeParametres = new Vector<HashMap<String, Object>>();
		valeurParametre = new Vector<Object>();
		typeRetour = Constants.XSD_STRING;
		timeout = leTimeout;
	}

	/**
	 * 
	 * @param leTypeRetour
	 */
	public void setTypeRetour(QName leTypeRetour) {
		typeRetour = leTypeRetour;
	}

	/**
	 * 
	 * @param leNom
	 * @param leType
	 * @param leMode
	 */
	public void ajouterTypeParametre(String leNom, QName leType, ParameterMode leMode) {
		HashMap<String, Object> param = new HashMap<String, Object>(3);

		param.put("nom", leNom);
		param.put("type", leType);
		param.put("mode", leMode);

		typeParametres.add(param);

	}

	/**
	 * 
	 * @param valeur
	 */
	public void ajouterValeurParametre(Object valeur) {
		valeurParametre.add(valeur);

	}

	/**
	 * 
	 * @param nomServeur
	 * @param nomMethode
	 * @throws java.lang.Exception
	 * @return
	 */
	public Object appelerMethode(String nomServeur, String nomMethode) throws Exception {
		Object[] listeParamValues = null;

		// Mise en forme des paramtres:

		if (valeurParametre.size() > 0) {
			listeParamValues = new Object[valeurParametre.size()];

			for (int i = 0; i < valeurParametre.size(); i++) {
				System.out.println(valeurParametre.elementAt(i));
				listeParamValues[i] = valeurParametre.elementAt(i);
			}
		}
		System.out.println(nomServeur+nomMethode);

		return appelerMethode_complet(nomServeur, nomMethode, typeParametres, listeParamValues);

	}

	private Object appelerMethode_complet(String nomServeur, String nomMethode, Vector<HashMap<String, Object>> params_type, Object[] params_value) throws Exception {
		// //System.out.println("[SoapFacile] -1-");

		Service service = new Service();
		Call call = (Call) service.createCall();

		call.setTargetEndpointAddress(new java.net.URL(url));
		call.setOperationName(new QName(nomServeur, nomMethode));

		// Les types de paramtres:
		if (params_type != null) {
			QName typeParam;
			ParameterMode mode;
			String nomParam;
			HashMap<String, Object> param_courant;

			for (int i = 0; i < params_type.size(); i++) {
				param_courant = params_type.elementAt(i);
				System.out.println(params_type.elementAt(i));

				typeParam = (QName) param_courant.get("type");
				mode = (ParameterMode) param_courant.get("mode");
				nomParam = (String) param_courant.get("nom");

				if (typeParam != null && mode != null && nomParam != null) {
					call.addParameter(nomParam, typeParam, mode);
					
				}

			}
		}
		call.setReturnType(typeRetour);
		call.setTimeout(timeout);

		System.out.println("debut nom methode : "+nomMethode+ "  nom serveur : "+nomServeur);
		Object resultat = call.invoke(params_value);
		System.out.println("fin nom methode : "+nomMethode+ "  nom serveur : "+nomServeur);

		return resultat;

	}

}
