/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

package org.opensi.webmanager.utils;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Timestamp;

import org.opensi.util.tools.FileManager;

/**
 * Permet la rdaction du rapport de mise a jour au format html
 */
public class RedactionRapport {

	private int max;

	private String nomFichier;

	private String cheminRoot;

	private String prefixe;

	private String dossId;

	private String site_id;

	private FileWriter fichier;

	/**
	 * 
	 * @param type
	 * @param nbRapportMax
	 * @param rootServeur
	 * @param dossierId
	 * @param idSite
	 * @throws java.io.IOException
	 */
	public RedactionRapport(int type, int nbRapportMax, String rootServeur, String dossierId, String idSite) throws IOException {
		max = nbRapportMax;
		cheminRoot = rootServeur;
		dossId = dossierId;
		site_id = idSite;

		prefixe = getPrefixe(type);

		java.util.Date date = new java.util.Date();
		Timestamp stamp = new Timestamp(date.getTime());
		String dateDebut = "" + stamp;

		dateDebut = dateDebut.replaceAll(" ", "_");
		dateDebut = dateDebut.replaceAll("\\.", "_");

		nomFichier = prefixe + dateDebut + ".html";

		FileManager.createDirectory(rootServeur + "/rapports/");
		FileManager.createDirectory(rootServeur + "/rapports/" + dossId + "/");
		FileManager.createDirectory(rootServeur + "/rapports/" + dossId + "/" + site_id + "/");

		File aEcrire = new File(rootServeur + "/rapports/" + dossId + "/" + site_id + "/" + nomFichier);
		aEcrire.createNewFile();

		fichier = new FileWriter(aEcrire);
		fichier.write("<head></head><body>");
		fichier.write("<style type=\"text/css\">");
		fichier.write(".echec {");
		fichier.write("color: #FF2222;}");
		fichier.write("</style>");
		fichier.write("<h3>Rapport de " + getTitre(type) + ":</h3>");

	}

	/**
	 * 
	 * @param ligne
	 * @param reussite
	 * @throws java.io.IOException
	 */
	public void ajouterLigne(String ligne, boolean reussite) throws IOException {
		if (reussite) {
			fichier.write("\n<br/>" + ligne);
		}
		else {
			fichier.write("\n<br/><font color=\"#FF2222\" >** ECHEC **: " + ligne + "</font>");
		}

	}

	/**
	 * 
	 * @throws java.io.IOException
	 */
	public void fermerFichier() throws IOException {
		fichier.write("\n</body>");
		fichier.close();

		effaceVieuxRapports();
	}

	/**
	 * 
	 * @return
	 */
	public String getNomFichier() {
		return nomFichier;
	}

	/**
	 */
	public void effaceVieuxRapports() {

		File dossierTest = new File(cheminRoot + "/rapports/" + dossId + "/" + site_id + "/");

		FiltreRapports filtre = new FiltreRapports(prefixe);

		File[] liste = dossierTest.listFiles(filtre);

		if (liste.length > max && liste.length > 0) {// Il faut supprimer le
			// plus vieux

			long dateVieuxFichier = liste[0].lastModified();
			File vieuxFichier = liste[0];

			for (int i = 1; i < liste.length; i++) {
				File unFichier = liste[i];
				if (unFichier.lastModified() < dateVieuxFichier) {
					dateVieuxFichier = unFichier.lastModified();
					vieuxFichier = unFichier;
				}
			}

			vieuxFichier.delete();

		}

	}

	/**
	 * 
	 * @param type
	 * @param rootServeur
	 * @param dossierId
	 * @param idSite
	 * @return
	 */
	public static String[] listeLesRapports(int type, String rootServeur, String dossierId, String idSite) {

		String prefixe = getPrefixe(type);
		String[] reponse = null;

		File dossierTest = new File(rootServeur + "/rapports/" + dossierId + "/" + idSite + "/");

		FiltreRapports filtre = new FiltreRapports(prefixe);
		File[] liste = dossierTest.listFiles(filtre);

		if (liste != null) {
			reponse = new String[liste.length];

			for (int i = 0; i < liste.length; i++) {
				reponse[i] = new String(liste[i].getName());
			}

		}

		return reponse;

	}

	private static String getPrefixe(int type) {
		if (type == ToolsMAJ.TYPE_UPLOAD_COMMANDES) {
			return "upload_commandes_";
		}
		else if (type == ToolsMAJ.TYPE_MAJ_PRIX) {
			return "maj_prix_";
		}
		else if (type == ToolsMAJ.TYPE_MAJ_STOCKS) {
			return "maj_stocks_";
		}
		else if (type == ToolsMAJ.TYPE_MAJ_ARTICLES) {
			return "maj_articles_";
		}
		else if (type == ToolsMAJ.TYPE_MAJ_INFO) {
			return "maj_infos_";
		}
		else if (type == ToolsMAJ.TYPE_UPLOAD_ART) {
			return "upload_articles_";
		}
		else if (type == ToolsMAJ.TYPE_MAJ_STATUT) {
			return "maj_statut_";
		}
		else {
			return "inconnu_";
		}
	}

	/**
	 * 
	 * @param type
	 * @return
	 */
	public String getTitre(int type) {

		if (type == ToolsMAJ.TYPE_UPLOAD_COMMANDES) {
			return "la rcupration des commandes";
		}
		else if (type == ToolsMAJ.TYPE_MAJ_PRIX) {
			return "la mise  jour des prix";
		}
		else if (type == ToolsMAJ.TYPE_MAJ_STOCKS) {
			return "la mise  jour des stocks";
		}
		else if (type == ToolsMAJ.TYPE_MAJ_ARTICLES) {
			return "la mise  jour des articles";
		}
		else if (type == ToolsMAJ.TYPE_MAJ_INFO) {
			return "la mise  jour des informations";
		}
		else if (type == ToolsMAJ.TYPE_UPLOAD_ART) {
			return "la rcupration des articles";
		}
		else if (type == ToolsMAJ.TYPE_MAJ_STATUT) {
			return "la mise  jour des statuts";
		}
		else {
			return "";
		}

	}

}
