package org.opensi.webmanager.utils;

/**
 * 
 * <B>ArticleStruct</B><br/> ref_article:string<br/> prix:double<br/>
 * quantite:int<br/> date_lim:string de type jj/mm/aaaa<br/> poids:double<br/>
 * fabricant:string<br/> famille:string<br/> sous_famille:string<br/>
 * description:HashMap (langue:string, texte:string)<br/> nom:HashMap
 * (langue:string, texte:string)<br/> liaison:<br/> taux_tva:double<br/>
 * 
 */
public class ArticleStruct extends Struct {
	// Constantes
	private final String VIDE = "";

	public final int REFERENCE = 0;
	public final int DESIGNATION = 1;
	public final int STOCK = 2;
	public final int FAMILLE = 3;
	public final int SOUS_FAMILLE = 4;
	public final int EN_LIGNE = 5;
	public final int DESCRIPTION = 6;
	public final int MARQUE = 7;
	public final int COLLECTION = 8;
	public final int POIDS = 9;
	public final int NOM_IMAGE = 10;
	public final int TVA = 11;
	public final int COULEUR = 12;
	public final int TAILLE = 13;
	public final int TARIF_1 = 14;
	public final int TARIF_2 = 15;
	public final int TARIF_3 = 16;
	public final int TARIF_4 = 17;
	public final int TARIF_5 = 18;
	public final int TARIF_1_TTC = 19;
	public final int TARIF_2_TTC = 20;
	public final int TARIF_3_TTC = 21;
	public final int TARIF_4_TTC = 22;
	public final int TARIF_5_TTC = 23;
	public final int PRIX_WEB = 24;
	public final int PRIX_ACHAT = 25;
	public final int ECO_TAXE = 26;
	public final int REFERENCE_OPENSI = 27;
	public final int REFERENCE_FABRICANT = 28;
	public final int LISTE_REFERENCE_FOURNISSEUR = 29;
	public final int NB_CHAMPS = 30;

	/**
	 * Construit un nouvel article
	 * 
	 * @param reference
	 *          reference de l'article
	 */
	public ArticleStruct() {
		super(30);
		
		setString(REFERENCE,VIDE);
		setString(DESIGNATION,VIDE);
		setDouble(STOCK,0.0);
		setString(FAMILLE,VIDE);
		setString(SOUS_FAMILLE,VIDE);
		setBoolean(EN_LIGNE,true);
		setString(DESCRIPTION,VIDE);
		setString(MARQUE,VIDE);
		setString(COLLECTION,VIDE);
		setDouble(POIDS,0.0);
		setString(NOM_IMAGE,VIDE);
		setDouble(TVA,0.0);
		setString(COULEUR,VIDE);
		setString(TAILLE,VIDE);
		setDouble(TARIF_1,0.0);
		setDouble(TARIF_2,0.0);
		setDouble(TARIF_3,0.0);
		setDouble(TARIF_4,0.0);
		setDouble(TARIF_5,0.0);
		setDouble(TARIF_1_TTC,0.0);
		setDouble(TARIF_2_TTC,0.0);
		setDouble(TARIF_3_TTC,0.0);
		setDouble(TARIF_4_TTC,0.0);
		setDouble(TARIF_5_TTC,0.0);
		setDouble(PRIX_WEB,0.0);		
		setDouble(PRIX_ACHAT,0.0);
		setDouble(ECO_TAXE,0.0);
		setString(REFERENCE_OPENSI,VIDE);
		setString(REFERENCE_FABRICANT,VIDE);

	}
	
	public ArticleStruct(Object[] listeBrut) {
		super(listeBrut);
	}

}
