package org.opensi.webmanager.utils;

/**
 * Structure reprsentant un article d'une commande.
 */
public class ArticleCommandeStruct extends Struct {
	// Constantes
	private final String VIDE = "";
	
	public final int REFERENCE = 0;
	public final int PRIX_U = 1;
	public final int QUANTITE = 2;
	public final int REMISE = 3;
	public final int DESIGNATION = 4;
	public final int TVA = 5;
	public final int COMMENTAIRE = 6;
	public final int DELAI_EXPE = 7;
	public final int NB_CHAMPS = 8;


	/**
	 * Construit un nouvel article
	 * 
	 * @param reference
	 *          rfrence de l'article
	 */

	public ArticleCommandeStruct() {
		super(8);
		setString(REFERENCE,VIDE);
		setDouble(PRIX_U,0.0);
		setDouble(QUANTITE,0.0);
		setDouble(REMISE,0.0);
		setString(DESIGNATION,VIDE);
		setDouble(TVA,19.6);
		setString(COMMENTAIRE,VIDE);
		setDouble(DELAI_EXPE,0.0);		
	}

	public ArticleCommandeStruct(Object[] listeBrut) {
		super(listeBrut);
	}

}