/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 *  Rcupre l'image ventuelle d'une famille, une sous-famille ou une marque
 */

package org.opensi.webmanager.init_vente;

import java.io.File;

import javax.imageio.stream.FileImageOutputStream;

import org.apache.axis.encoding.Base64;
import org.experlog.openeas.api.Action;
import org.experlog.openeas.api.ServletRequest;
import org.experlog.openeas.api.Session;
import org.opensi.util.tools.FileManager;
import org.opensi.webmanager.utils.AppelServices;
import org.opensi.webmanager.utils.ImageStruct;

/**
 * Lance la rcupration d'une image du site web.
 */
public class UploadImage extends Action {
	/**
	 * 
	 * @return
	 */
	public boolean serverSide() {	return true;}

	/**
	 * 
	 * @param s
	 * @param r
	 * @param info
	 * @throws java.lang.Exception
	 * @return
	 */
	public boolean service(Session s, ServletRequest r, Object info) throws Exception {

		System.out.println("(OpenSi)[UploadImage] DEBUT");

		String typeImage = r.getParameter("typeImage");
		String urlService = r.getParameter("urlService");
		String chemin = s.getAppConfiguration().get("opensi.absdir");
		String dossier = s.getCookie().get("Dossier_Id");

		boolean presenceImage = false;
		String nomImage = "";

		if (typeImage.equals("MARQUE")) {

			String marque = r.getParameter("marque");

			if (!(urlService == null || urlService.equals("") || marque == null || marque.equals(""))) {
				Object reponse = AppelServices.uploadImageMarque(urlService, marque);

				Object[] rep = (Object[]) reponse;

				// Je sais que c'est une images
				Object[] valeur = (Object[]) rep[1];

				if (valeur != null) {
					ImageStruct image = new ImageStruct(valeur);
					if (image.getTaille() > 0 && (!image.getNom().equals(""))) {

						byte[] imageBinaire = Base64.decode(image.getContenu());

						FileManager.createDirectory(chemin + "/photos_marques/");
						FileManager.createDirectory(chemin + "/photos_marques/" + dossier + "/");

						File fichier = new File(chemin + "/photos_marques/" + dossier + "/" + image.getNom());
						fichier.createNewFile();

						FileImageOutputStream output = new FileImageOutputStream(fichier);
						output.write(imageBinaire, 0, image.getTaille());
						output.close();

						presenceImage = true;
						nomImage = image.getNom();

					}
					else {
						System.out.println("(OpenSi)[UploadImage] taille<=0");
					}
				}
				else {
					System.out.println("(OpenSi)[UploadImage] valeur nulle");
				}

			}
		}
		else if (typeImage.equals("FAMILLE")) {

			System.out.println("(OpenSi)[UploadImage] 1");
			String famille = r.getParameter("famille");

			System.out.println("(OpenSi)[UploadImage] 2");
			if (!(urlService == null || urlService.equals("") || famille == null || famille.equals(""))) {
				Object reponse = AppelServices.uploadImageFamille(urlService, famille);
				System.out.println("(OpenSi)[UploadImage] 3");
				Object[] rep = (Object[]) reponse;

				// Je sais que c'est une images
				Object[] valeur = (Object[]) rep[1];
				System.out.println("(OpenSi)[UploadImage] 4");
				if (valeur != null) {
					ImageStruct image = new ImageStruct(valeur);
					System.out.println("(OpenSi)[UploadImage]");
					if (image.getTaille() > 0 && (!image.getNom().equals(""))) {
						System.out.println("(OpenSi)[UploadImage] 5");

						byte[] imageBinaire = Base64.decode(image.getContenu());

						FileManager.createDirectory(chemin + "/photos_familles/");
						FileManager.createDirectory(chemin + "/photos_familles/" + dossier + "/");

						System.out.println("(OpenSi)[UploadImage] 5");

						File fichier = new File(chemin + "/photos_familles/" + dossier + "/" + image.getNom());
						fichier.createNewFile();

						FileImageOutputStream output = new FileImageOutputStream(fichier);
						output.write(imageBinaire, 0, image.getTaille());
						output.close();

						System.out.println("(OpenSi)[UploadImage] 6");

						presenceImage = true;
						nomImage = image.getNom();

						System.out.println("(OpenSi)[UploadImage] 7");

					}
					System.out.println("(OpenSi)[UploadImage] 8");
				}
			}
		}
		else if (typeImage.equals("SOUS_FAMILLE")) {
			String famille = r.getParameter("famille");
			String sousfamille = r.getParameter("sousfamille");

			if (!(urlService == null || urlService.equals("") || famille == null || famille.equals("") || sousfamille == null || sousfamille
					.equals(""))) {

				Object reponse = AppelServices.uploadImageSousFamille(urlService, famille, sousfamille);

				Object[] rep = (Object[]) reponse;

				// Je sais que c'est une images
				Object[] valeur = (Object[]) rep[1];

				if (valeur != null) {
					ImageStruct image = new ImageStruct(valeur);

					if (image.getTaille() > 0 && (!image.getNom().equals(""))) {
						byte[] imageBinaire = Base64.decode(image.getContenu());

						FileManager.createDirectory(chemin + "/photos_familles/");
						FileManager.createDirectory(chemin + "/photos_familles/" + dossier + "/");
						FileManager.createDirectory(chemin + "/photos_familles/" + dossier + "/" + famille + "/");

						File fichier = new File(chemin + "/photos_familles/" + dossier + "/" + famille + "/" + image.getNom());
						fichier.createNewFile();

						FileImageOutputStream output = new FileImageOutputStream(fichier);
						output.write(imageBinaire, 0, image.getTaille());
						output.close();

						presenceImage = true;
						nomImage = image.getNom();

					}
				}
			}

		}

		r.addParameter("presenceImage", "" + presenceImage);
		r.addParameter("nomImage", nomImage);

		System.out.println("(OpenSi)[UploadImage] ------------------------- FIN ------------------------------");
		System.out.println("");

		return true;

	}

}
