/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 *  Requetes multiples d'insertion ou de suppression d'articles web.
 */

package org.opensi.webmanager.init_vente;

import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Types;

import org.experlog.openeas.api.Action;
import org.experlog.openeas.api.ServletRequest;
import org.experlog.openeas.api.Session;
import org.opensi.util.tools.FileManager;
import org.opensi.util.PhotosManager;

/**
 * Enregistre les articles temporaires dans la FICHE_ARTICLE
 */
public class EnregistrerArticlesTemp extends Action {
	private boolean reussi;

	/**
	 * 
	 * @return
	 */
	public boolean serverSide() {
		return true;
	}

	/**
	 * 
	 * @param s
	 * @param r
	 * @param info
	 * @throws java.lang.Exception
	 * @return
	 */
	public boolean service(Session s, ServletRequest r, Object info) throws Exception {
		reussi = true;
		String base = r.getParameter("base");
		String site_id = r.getParameter("site_id");
		String date_now = r.getParameter("Date_Now");
		String dossierRoot = s.getAppConfiguration().get("opensi.absdir");
		String dossierId = r.getParameter("dossierId");

		PhotosManager manager = new PhotosManager(dossierRoot, dossierId);

		FileManager.createDirectory(dossierRoot + "/photos_articles");
		FileManager.createDirectory(dossierRoot + "/photos_articles/" + dossierId);

		Connection con = s.getConnection(null);

		String reqListeID = "SELECT Article_Id,coalesce(Couleur_Id,NULL) as Couleur, coalesce(Taille_Id,NULL) as Taille, Nom_Image, Designation, coalesce(Marque_Id,NULL) as Marque, Famille_1, coalesce(Famille_2, NULL) as Famille_2, Prix_Vente, Prix_Achat, Poids, Description, Stock";
		reqListeID += " FROM " + base + ".FICHE_ARTICLE_TEMP WHERE Site_Id=" + site_id;

		String reqMultiple = "";

		reqMultiple = "INSERT INTO " + base + ".FICHE_ARTICLE";
		reqMultiple += "(Couleur_Id,Taille_Id,Article_Id,Designation,Marque_Id,Famille_1,Famille_2, Tarif_1,Prix_Achat,Poids_Brut, Descrip_1,Date_M, Date_C)";
		reqMultiple += "VALUES(?,?,?,?,?,?,?,?,?,?,?," + date_now + "," + date_now + ")";

		Statement state = con.createStatement();
		PreparedStatement ps = con.prepareStatement(reqMultiple);

		String insertStock = "";
		insertStock = "INSERT INTO " + base + ".STOCKS_ARTICLE";
		insertStock += "(Article_Id, Stock_Init)";
		insertStock += "VALUES(?,?)";

		PreparedStatement ps2 = con.prepareStatement(insertStock);

		String insertWeb = "";
		insertWeb = "INSERT INTO " + base + ".FICHE_ARTICLE_WEB";
		insertWeb += "(Article_Id, Article_Id_Site, Site_Id)";
		insertWeb += "VALUES(?,?," + site_id + ")";

		PreparedStatement ps3 = con.prepareStatement(insertWeb);

		ResultSet resultSet = state.executeQuery(reqListeID);
		int i=0;
		while (resultSet.next()) {

			if (resultSet.getString("Couleur").equals("NULL")) { ps.setNull(1, Types.INTEGER); }
			else { ps.setInt(1, resultSet.getInt("Couleur")); }
			if (resultSet.getString("Taille").equals("NULL")) { ps.setNull(2, Types.INTEGER); }
			else { ps.setInt(2, resultSet.getInt("Taille")); }
			ps.setString(3, resultSet.getString("Article_Id"));
			ps.setString(4, resultSet.getString("Designation"));
			if (resultSet.getString("Marque").equals("NULL")) { ps.setNull(5, Types.INTEGER); }
			else { ps.setInt(5, resultSet.getInt("Marque")); }
			ps.setInt(6, resultSet.getInt("Famille_1"));
			if (resultSet.getString("Famille_2").equals("NULL")) { ps.setNull(7, Types.INTEGER); }
			else { ps.setInt(7, resultSet.getInt("Famille_2")); }
			ps.setDouble(8, resultSet.getDouble("Prix_Vente"));
			ps.setDouble(9, resultSet.getDouble("Prix_Achat"));
			ps.setDouble(10, resultSet.getDouble("Poids"));
			ps.setString(11, resultSet.getString("Description"));

			ps2.setString(1, resultSet.getString("Article_Id"));
			ps2.setInt(2, resultSet.getInt("Stock")>0?resultSet.getInt("Stock"):0);

			ps3.setString(1, resultSet.getString("Article_Id"));
			ps3.setString(2, resultSet.getString("Article_Id"));

			ps.addBatch();
			ps2.addBatch();
			ps3.addBatch();
			i++;
			if (i>100) {
				ps.executeBatch();
				ps2.executeBatch();
				ps3.executeBatch();
				i=0;				
			}
			
			String nomImage = resultSet.getString("Nom_Image");

			if (!(nomImage == null || nomImage.equals(""))) {
				File tempFile = new File(dossierRoot + "/iobuffer/" + nomImage);
				if (tempFile.exists()) {
					manager.creerPhotos(nomImage, resultSet.getString("Article_Id"));
				}
			}
		}
		ps.executeBatch();
		ps2.executeBatch();
		ps3.executeBatch();

		s.closeConnection(con, null);

		if (reussi) {
			r.addParameter("reussi", "OUI");
		}
		else {
			r.addParameter("reussi", "NON");
		}

		return true;

	}

}
