/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

package org.opensi.util.tools;


import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;


public class Formatter {
	
	
	private DecimalFormatSymbols dfs = new DecimalFormatSymbols();
	private DecimalFormat df;
	
		
	
	public Formatter(String pattern) {
		
		dfs.setDecimalSeparator('.');
    dfs.setGroupingSeparator(' ');
		
		df = new DecimalFormat(pattern);
		df.setNegativeSuffix("");
		df.setNegativePrefix("-");
		df.setPositiveSuffix("");
    df.setDecimalFormatSymbols(dfs);
    df.setGroupingSize(3);
    df.setGroupingUsed(false);
	}
	
	
	public Formatter(String pattern, boolean grouping) {
					
		this(pattern);
		df.setGroupingUsed(grouping);
	}
  
	
	public void setPattern(String pattern) {

  	df.applyPattern(pattern);
  }
	
	
	public void setDecimalSeparator(char decimalSeparator) {
	
		dfs.setDecimalSeparator(decimalSeparator);
	}
	
	
	/** renvoie le nombre pass en paramtre format */

  public String get(String number) {
    try {
			String numTemp = new String(number);
			numTemp = numTemp.replaceAll(" ", "");
			numTemp = numTemp.replace(',', '.');
      return df.format(Double.parseDouble(numTemp));
    }
    catch (NumberFormatException nfe) {
    	return number;
    }
	}
	
	
	public String get(double number) {
    try {
      return df.format(number);
    }
    catch (NumberFormatException nfe) {
    	return String.valueOf(number);
    }
	}
	 
	  
} // fin Formatter
