/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

package org.opensi.util.tools;


import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;


public class DateTime {


	private Calendar dt;
	
	
	/** instancie un DateTime  la date courante **/
	
	public DateTime() {
		
		dt = Calendar.getInstance();
	}
	
		
  public DateTime(int jour, int mois, int annee) {
				
		dt = Calendar.getInstance();
		dt.set(annee, mois-1, jour);
	}
	
	public DateTime(long timeInMillis) {
	
		dt = Calendar.getInstance();
		dt.setTimeInMillis(timeInMillis);
	}
	
	
	/** renvoie la date en milli secondes **/
	
	public long getTimeInMillis() {	
	
		return dt.getTimeInMillis();
  }
	
	
	/** renvoie la date en milli secondes avec lments de time  0 **/
	
	public long getDateInMillis() {
	
		Calendar c = Calendar.getInstance();
		c.clear();
		
		c.set(Calendar.YEAR, dt.get(Calendar.YEAR));
		c.set(Calendar.MONTH, dt.get(Calendar.MONTH));
		c.set(Calendar.DAY_OF_MONTH, dt.get(Calendar.DAY_OF_MONTH));
			
		return c.getTimeInMillis();
  }
	
	
	/** renvoie la date  la dernire milli-seconde du jour **/
	
	public long getDateFullTime() {
	
		Calendar c = Calendar.getInstance();
		c.setTimeInMillis(getDateInMillis());
		
		c.set(Calendar.HOUR_OF_DAY, 23);
		c.set(Calendar.MINUTE, 59);
		c.set(Calendar.SECOND, 59);
		c.set(Calendar.MILLISECOND, 999);
		
		return c.getTimeInMillis();		
  }
	
	
	public int getDay() { return dt.get(Calendar.DAY_OF_MONTH); }
	public int getMonth() { return dt.get(Calendar.MONTH) + 1; }
	public int getYear() { return dt.get(Calendar.YEAR); }
	
	public void setDay(int day) { dt.set(Calendar.DAY_OF_MONTH, day); }	
	public void setMonth(int month) {	dt.set(Calendar.MONTH, month-1); }	
	public void setYear(int year) { dt.set(Calendar.YEAR, year); }
	
	public void setDate(int jour, int mois, int annee) {

		dt.set(annee, mois-1, jour);
	}	
	
	public void setTimeInMillis(long timeInMillis) {
	
		dt.setTimeInMillis(timeInMillis);
	}
	
	/** renvoie le dernier jour du mois courant **/
	
	public int currentMaxDay() {
	
		return dt.getActualMaximum(Calendar.DAY_OF_MONTH);
	}
	
	/** renvoie le dernier jour du mois prcdent **/
	
	public int previousMaxDay() {
	
		Calendar c = Calendar.getInstance();
		c.setTimeInMillis(getTimeInMillis());
		c.set(Calendar.DAY_OF_MONTH, 1);
		c.set(Calendar.MONTH, c.get(Calendar.MONTH) - 1);
	
		return c.getActualMaximum(Calendar.DAY_OF_MONTH);
	}
	
	/** renvoie le dernier jour du mois suivant **/
	
	public int nextMaxDay() {
	
		Calendar c = Calendar.getInstance();
		c.setTimeInMillis(getTimeInMillis());
		c.set(Calendar.DAY_OF_MONTH, 1);
		c.set(Calendar.MONTH, c.get(Calendar.MONTH) + 1);
	
		return c.getActualMaximum(Calendar.DAY_OF_MONTH);
	}
	
	
	public long addMonth(int nbMonths) {
		
		dt.add(Calendar.MONTH, nbMonths);		
		return dt.getTimeInMillis();		
	}
	
	
	public static int gapInMonths(long start, long end) {
	
		Calendar c1 = Calendar.getInstance();
		c1.setTimeInMillis(start);
		
		Calendar c2 = Calendar.getInstance();
		c2.setTimeInMillis(end);
			
		return (c2.get(Calendar.YEAR) - c1.get(Calendar.YEAR)) * 12 + c2.get(Calendar.MONTH) - c1.get(Calendar.MONTH) + 1;
	}
	
	
	/** parse une date donne selon une pattern, -1 si pas de correspondance **/
	
	public static long parseDate(String dateStr, String pattern) {
		try {
		
			SimpleDateFormat sdf = new SimpleDateFormat(pattern);
			sdf.setLenient(false);
	
			Date date = sdf.parse(dateStr, new java.text.ParsePosition(0));
		
			return date.getTime();
			
		} catch(NullPointerException npe) {
			return -1;
		}
	}
	
	
	/** renvoie une date formatte selon la pattern donne **/
	
	public static String formatTime(long timeInMillis, String pattern) {
	
		SimpleDateFormat sdf = new SimpleDateFormat(pattern);
		
		return sdf.format(new Date(timeInMillis));
	}
	
	
	public static boolean isBissextile(int annee) {
		
    	return (annee % 4 == 0 && (annee % 100 != 0 || annee % 400 == 0));
	}


} // fin DateTime
