/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

package org.opensi.util.openoffice;

public class OooStyleColonne extends OooStyle

{

	private float largeur;
	private final float LARGEUR_DEFAUT=2.267f;



	public OooStyleColonne(String lenom)
	{
		super(lenom);
		largeur=LARGEUR_DEFAUT;
	}
	

	public void setLargeur(float laLargeur)
	{
		if(laLargeur<0.5)
		{
			largeur=LARGEUR_DEFAUT;
		}
		else
		{
			largeur=laLargeur;
		}
	}
	
	public String getFamilleStyle()
	{
		return "table-column";
	}

	public String getPropriete()
	{
		return "fo:break-before=\"auto\" style:column-width=\""+largeur+"cm\"";
	}


}
